/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitorWithProperties;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.util.Preconditions;

public class FlatRelationshipModifications
implements RelationshipModifications {
    private final SortedMap<Long, NodeData> data = new TreeMap<Long, NodeData>();

    public FlatRelationshipModifications(RelationshipData ... creations) {
        this.mapData(creations, NodeData::creations);
    }

    public FlatRelationshipModifications(RelationshipData[] creations, RelationshipData[] deletions) {
        this.mapData(creations, NodeData::creations);
        this.mapData(deletions, NodeData::deletions);
    }

    private void mapData(RelationshipData[] relationships, Function<NodeData, SortedMap<Integer, List<RelationshipData>>> mapFunction) {
        for (RelationshipData relationship : relationships) {
            this.mapNode(relationship, relationship.startNode, mapFunction);
            if (relationship.startNode == relationship.endNode) continue;
            this.mapNode(relationship, relationship.endNode, mapFunction);
        }
    }

    private void mapNode(RelationshipData relationship, long node, Function<NodeData, SortedMap<Integer, List<RelationshipData>>> mapFunction) {
        NodeData nodeData = this.data.computeIfAbsent(node, n -> new NodeData());
        mapFunction.apply(nodeData).computeIfAbsent(relationship.type, type -> new ArrayList()).add(relationship);
    }

    public RelationshipModifications.RelationshipBatch creations() {
        return this.allAsBatch(NodeData::creations);
    }

    public RelationshipModifications.RelationshipBatch deletions() {
        return this.allAsBatch(NodeData::deletions);
    }

    private FlatRelationshipBatch allAsBatch(Function<NodeData, SortedMap<Integer, List<RelationshipData>>> mapFunction) {
        return new FlatRelationshipBatch(this.data.values().stream().flatMap(n -> ((SortedMap)mapFunction.apply((NodeData)n)).values().stream()).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public void forEachSplit(RelationshipModifications.IdsVisitor visitor) {
        this.data.forEach((nodeId, nodeData) -> visitor.accept((Object)new RelationshipModifications.NodeRelationshipIds(){
            final /* synthetic */ Long val$nodeId;
            final /* synthetic */ NodeData val$nodeData;
            {
                this.val$nodeId = l;
                this.val$nodeData = nodeData;
            }

            public long nodeId() {
                return this.val$nodeId;
            }

            public boolean hasCreations() {
                return !this.val$nodeData.creations.isEmpty();
            }

            public boolean hasCreations(int type) {
                return this.val$nodeData.creations.containsKey(type);
            }

            public boolean hasDeletions() {
                return !this.val$nodeData.deletions.isEmpty();
            }

            public RelationshipModifications.RelationshipBatch creations() {
                return new FlatRelationshipBatch(this.val$nodeData.creations.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            }

            public RelationshipModifications.RelationshipBatch deletions() {
                return new FlatRelationshipBatch(this.val$nodeData.deletions.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            }

            public void forEachCreationSplitInterruptible(RelationshipModifications.InterruptibleTypeIdsVisitor visitor) {
                for (Map.Entry<Integer, List<RelationshipData>> entry : this.val$nodeData.creations.entrySet()) {
                    if (visitor.test((Object)new FlatNodeRelationshipTypeIds(entry.getKey(), entry.getValue(), this.val$nodeId))) break;
                }
            }

            public void forEachDeletionSplitInterruptible(RelationshipModifications.InterruptibleTypeIdsVisitor visitor) {
                for (Map.Entry<Integer, List<RelationshipData>> entry : this.val$nodeData.deletions.entrySet()) {
                    if (visitor.test((Object)new FlatNodeRelationshipTypeIds(entry.getKey(), entry.getValue(), this.val$nodeId))) break;
                }
            }
        }));
    }

    public static RelationshipModifications singleCreate(long id, int type, long startNode, long endNode) {
        return new FlatRelationshipModifications(FlatRelationshipModifications.relationship(id, type, startNode, endNode));
    }

    public static RelationshipModifications singleCreate(long id, int type, long startNode, long endNode, Collection<StorageProperty> properties) {
        return new FlatRelationshipModifications(FlatRelationshipModifications.relationship(id, type, startNode, endNode, properties));
    }

    public static RelationshipModifications singleCreate(RelationshipData relationship) {
        return new FlatRelationshipModifications(relationship);
    }

    public static RelationshipModifications modifications(RelationshipData[] creations, RelationshipData[] deletions) {
        return new FlatRelationshipModifications(creations, deletions);
    }

    public static RelationshipModifications creations(RelationshipData ... creations) {
        return new FlatRelationshipModifications(creations);
    }

    public static RelationshipModifications deletions(RelationshipData ... deletions) {
        return new FlatRelationshipModifications(FlatRelationshipModifications.relationships(new RelationshipData[0]), deletions);
    }

    public static RelationshipData relationship(long id, int type, long startNode, long endNode) {
        return new RelationshipData(id, type, startNode, endNode);
    }

    public static RelationshipData relationship(long id, int type, long startNode, long endNode, Collection<StorageProperty> properties) {
        return new RelationshipData(id, type, startNode, endNode, properties);
    }

    public static RelationshipModifications singleDelete(long id, int type, long startNode, long endNode) {
        return new FlatRelationshipModifications(FlatRelationshipModifications.relationships(new RelationshipData[0]), FlatRelationshipModifications.relationships(FlatRelationshipModifications.relationship(id, type, startNode, endNode)));
    }

    public static RelationshipModifications singleDelete(RelationshipData relationship) {
        return new FlatRelationshipModifications(FlatRelationshipModifications.relationships(new RelationshipData[0]), FlatRelationshipModifications.relationships(relationship));
    }

    public static RelationshipData[] relationships(RelationshipData ... relationships) {
        return relationships;
    }

    public record RelationshipData(long id, int type, long startNode, long endNode, Collection<StorageProperty> properties) {
        public RelationshipData(long id, int type, long startNode, long endNode) {
            this(id, type, startNode, endNode, Collections.emptyList());
        }

        public RelationshipDirection direction(long fromNodePov) {
            Preconditions.checkState((fromNodePov == this.startNode || fromNodePov == this.endNode ? 1 : 0) != 0, (String)(fromNodePov + " is neither node " + this.startNode + " nor " + this.endNode));
            return fromNodePov == this.startNode ? (this.startNode == this.endNode ? RelationshipDirection.LOOP : RelationshipDirection.OUTGOING) : RelationshipDirection.INCOMING;
        }

        public long neighbourNode(long fromNodeIdPov) {
            return this.startNode == fromNodeIdPov ? this.endNode : this.startNode;
        }
    }

    private static class NodeData {
        final SortedMap<Integer, List<RelationshipData>> creations = new TreeMap<Integer, List<RelationshipData>>();
        final SortedMap<Integer, List<RelationshipData>> deletions = new TreeMap<Integer, List<RelationshipData>>();

        private NodeData() {
        }

        SortedMap<Integer, List<RelationshipData>> creations() {
            return this.creations;
        }

        SortedMap<Integer, List<RelationshipData>> deletions() {
            return this.deletions;
        }
    }

    private static class FlatRelationshipBatch
    implements RelationshipModifications.RelationshipBatch {
        private final Collection<RelationshipData> relationships;

        FlatRelationshipBatch(Collection<RelationshipData> relationships) {
            this.relationships = relationships;
        }

        public int size() {
            return this.relationships.size();
        }

        public <E extends Exception> void forEach(RelationshipVisitorWithProperties<E> relationship) throws E {
            for (RelationshipData rel : this.relationships) {
                relationship.visit(rel.id, rel.type, rel.startNode, rel.endNode, rel.properties);
            }
        }
    }

    private static class FlatNodeRelationshipTypeIds
    implements RelationshipModifications.NodeRelationshipTypeIds {
        private final int type;
        private final List<RelationshipData> relationships;
        private final Long nodeId;

        FlatNodeRelationshipTypeIds(int type, List<RelationshipData> relationships, Long nodeId) {
            this.type = type;
            this.relationships = relationships;
            this.nodeId = nodeId;
        }

        public int type() {
            return this.type;
        }

        public boolean hasOut() {
            return this.relationships.stream().anyMatch(r -> r.direction(this.nodeId) == RelationshipDirection.OUTGOING);
        }

        public boolean hasIn() {
            return this.relationships.stream().anyMatch(r -> r.direction(this.nodeId) == RelationshipDirection.INCOMING);
        }

        public boolean hasLoop() {
            return this.relationships.stream().anyMatch(r -> r.direction(this.nodeId) == RelationshipDirection.LOOP);
        }

        public RelationshipModifications.RelationshipBatch out() {
            return new FlatRelationshipBatch(this.relationships.stream().filter(r -> r.direction(this.nodeId) == RelationshipDirection.OUTGOING).collect(Collectors.toList()));
        }

        public RelationshipModifications.RelationshipBatch in() {
            return new FlatRelationshipBatch(this.relationships.stream().filter(r -> r.direction(this.nodeId) == RelationshipDirection.INCOMING).collect(Collectors.toList()));
        }

        public RelationshipModifications.RelationshipBatch loop() {
            return new FlatRelationshipBatch(this.relationships.stream().filter(r -> r.direction(this.nodeId) == RelationshipDirection.LOOP).collect(Collectors.toList()));
        }
    }
}

