/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.server.helpers.PropertyTypeDispatcher;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.Serializer;

public class ValueRepresentation
extends Representation {
    private final Object value;
    private static final PropertyTypeDispatcher<Void, Representation> PROPERTY_REPRESENTATION = new PropertyTypeDispatcher<Void, Representation>(){

        @Override
        protected Representation dispatchBooleanProperty(boolean property, Void param) {
            return ValueRepresentation.bool(property);
        }

        @Override
        protected Representation dispatchPointProperty(Point point, Void param) {
            return new ValueRepresentation(RepresentationType.POINT, point);
        }

        @Override
        protected Representation dispatchTemporalProperty(Temporal temporal, Void param) {
            return new ValueRepresentation(RepresentationType.TEMPORAL, temporal);
        }

        @Override
        protected Representation dispatchTemporalAmountProperty(TemporalAmount temporalAmount, Void param) {
            return new ValueRepresentation(RepresentationType.TEMPORAL_AMOUNT, temporalAmount);
        }

        @Override
        protected Representation dispatchByteProperty(byte property, Void param) {
            return new ValueRepresentation(RepresentationType.BYTE, property);
        }

        @Override
        protected Representation dispatchCharacterProperty(char property, Void param) {
            return new ValueRepresentation(RepresentationType.CHAR, Character.valueOf(property));
        }

        @Override
        protected Representation dispatchDoubleProperty(double property, Void param) {
            return new ValueRepresentation(RepresentationType.DOUBLE, property);
        }

        @Override
        protected Representation dispatchFloatProperty(float property, Void param) {
            return new ValueRepresentation(RepresentationType.FLOAT, Float.valueOf(property));
        }

        @Override
        protected Representation dispatchIntegerProperty(int property, Void param) {
            return new ValueRepresentation(RepresentationType.INTEGER, property);
        }

        @Override
        protected Representation dispatchLongProperty(long property, Void param) {
            return new ValueRepresentation(RepresentationType.LONG, property);
        }

        @Override
        protected Representation dispatchShortProperty(short property, Void param) {
            return new ValueRepresentation(RepresentationType.SHORT, property);
        }

        @Override
        protected Representation dispatchStringProperty(String property, Void param) {
            return ValueRepresentation.string(property);
        }

        @Override
        protected Representation dispatchStringArrayProperty(String[] property, Void param) {
            return ListRepresentation.strings(property);
        }

        @Override
        protected Representation dispatchPointArrayProperty(Point[] property, Void param) {
            return ListRepresentation.points(property);
        }

        @Override
        protected Representation dispatchTemporalArrayProperty(Temporal[] property, Void param) {
            return ListRepresentation.temporals(property);
        }

        @Override
        protected Representation dispatchTemporalAmountArrayProperty(TemporalAmount[] property, Void param) {
            return ListRepresentation.temporalAmounts(property);
        }

        private Iterable<Representation> dispatch(PropertyTypeDispatcher.PropertyArray<?> array) {
            return new IterableWrapper<Representation, Object>(this, array){

                protected Representation underlyingObjectToObject(Object object) {
                    return ValueRepresentation.property(object);
                }
            };
        }

        @Override
        protected Representation dispatchByteArrayProperty(PropertyTypeDispatcher.PropertyArray<Byte> array, Void param) {
            return this.toListRepresentation(RepresentationType.BYTE, array);
        }

        @Override
        protected Representation dispatchShortArrayProperty(PropertyTypeDispatcher.PropertyArray<Short> array, Void param) {
            return this.toListRepresentation(RepresentationType.SHORT, array);
        }

        private ListRepresentation toListRepresentation(RepresentationType type, PropertyTypeDispatcher.PropertyArray<?> array) {
            return new ListRepresentation(type, this.dispatch(array));
        }

        @Override
        protected Representation dispatchCharacterArrayProperty(PropertyTypeDispatcher.PropertyArray<Character> array, Void param) {
            return this.toListRepresentation(RepresentationType.CHAR, array);
        }

        @Override
        protected Representation dispatchIntegerArrayProperty(PropertyTypeDispatcher.PropertyArray<Integer> array, Void param) {
            return this.toListRepresentation(RepresentationType.INTEGER, array);
        }

        @Override
        protected Representation dispatchLongArrayProperty(PropertyTypeDispatcher.PropertyArray<Long> array, Void param) {
            return this.toListRepresentation(RepresentationType.LONG, array);
        }

        @Override
        protected Representation dispatchFloatArrayProperty(PropertyTypeDispatcher.PropertyArray<Float> array, Void param) {
            return this.toListRepresentation(RepresentationType.FLOAT, array);
        }

        @Override
        protected Representation dispatchDoubleArrayProperty(PropertyTypeDispatcher.PropertyArray<Double> array, Void param) {
            return this.toListRepresentation(RepresentationType.DOUBLE, array);
        }

        @Override
        protected Representation dispatchBooleanArrayProperty(PropertyTypeDispatcher.PropertyArray<Boolean> array, Void param) {
            return this.toListRepresentation(RepresentationType.BOOLEAN, array);
        }
    };

    private ValueRepresentation(RepresentationType type, Object value) {
        super(type);
        this.value = value;
    }

    @Override
    String serialize(RepresentationFormat format, URI baseUri) {
        String result = format.serializeValue(this.type, this.value);
        format.complete();
        return result;
    }

    @Override
    void addTo(ListSerializer serializer) {
        serializer.writer.writeValue(this.type, this.value);
    }

    @Override
    void putTo(MappingSerializer serializer, String key) {
        serializer.writer.writeValue(this.type, key, this.value);
    }

    public static ValueRepresentation ofNull() {
        return new ValueRepresentation(RepresentationType.NULL, null);
    }

    public static ValueRepresentation string(String value) {
        return new ValueRepresentation(RepresentationType.STRING, value);
    }

    public static ValueRepresentation point(Point value) {
        return new ValueRepresentation(RepresentationType.POINT, value);
    }

    public static ValueRepresentation temporal(Temporal value) {
        return new ValueRepresentation(RepresentationType.TEMPORAL, value.toString());
    }

    public static ValueRepresentation temporalAmount(TemporalAmount value) {
        return new ValueRepresentation(RepresentationType.TEMPORAL_AMOUNT, value.toString());
    }

    public static ValueRepresentation number(int value) {
        return new ValueRepresentation(RepresentationType.INTEGER, value);
    }

    public static ValueRepresentation number(long value) {
        return new ValueRepresentation(RepresentationType.LONG, value);
    }

    public static ValueRepresentation number(double value) {
        return new ValueRepresentation(RepresentationType.DOUBLE, value);
    }

    public static ValueRepresentation bool(boolean value) {
        return new ValueRepresentation(RepresentationType.BOOLEAN, value);
    }

    public static ValueRepresentation relationshipType(RelationshipType type) {
        return new ValueRepresentation(RepresentationType.RELATIONSHIP_TYPE, type.name());
    }

    public static ValueRepresentation uri(final String path) {
        return new ValueRepresentation(RepresentationType.URI, null){

            @Override
            String serialize(RepresentationFormat format, URI baseUri) {
                return Serializer.joinBaseWithRelativePath(baseUri, path);
            }

            @Override
            void addTo(ListSerializer serializer) {
                serializer.addUri(path);
            }

            @Override
            void putTo(MappingSerializer serializer, String key) {
                serializer.putRelativeUri(key, path);
            }
        };
    }

    public static ValueRepresentation template(final String path) {
        return new ValueRepresentation(RepresentationType.TEMPLATE, null){

            @Override
            String serialize(RepresentationFormat format, URI baseUri) {
                return Serializer.joinBaseWithRelativePath(baseUri, path);
            }

            @Override
            void addTo(ListSerializer serializer) {
                serializer.addUriTemplate(path);
            }

            @Override
            void putTo(MappingSerializer serializer, String key) {
                serializer.putRelativeUriTemplate(key, path);
            }
        };
    }

    static Representation property(Object property) {
        return PROPERTY_REPRESENTATION.dispatch(property, null);
    }
}

