/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.MediaType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.GraphDatabaseSPI;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.RelationshipNotFoundException;

public abstract class RepresentationFormat
implements InputFormat {
    final MediaType mediaType;

    public RepresentationFormat(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.mediaType);
    }

    String serializeValue(RepresentationType type, Object value) {
        return this.serializeValue(type.valueName, value);
    }

    protected abstract String serializeValue(String var1, Object var2);

    ListWriter serializeList(RepresentationType type) {
        if (type.listName == null) {
            throw new IllegalStateException("Invalid list type: " + type);
        }
        return this.serializeList(type.listName);
    }

    protected abstract ListWriter serializeList(String var1);

    MappingWriter serializeMapping(RepresentationType type) {
        return this.serializeMapping(type.valueName);
    }

    protected abstract MappingWriter serializeMapping(String var1);

    protected abstract String complete(ListWriter var1);

    protected abstract String complete(MappingWriter var1);

    @Override
    public ParameterList readParameterList(String input) throws BadInputException {
        return new ParameterList(this.readMap(input, new String[0])){

            @Override
            protected Boolean convertBoolean(Object value) throws BadInputException {
                return RepresentationFormat.this.convertBoolean(value);
            }

            @Override
            protected Byte convertByte(Object value) throws BadInputException {
                return RepresentationFormat.this.convertByte(value);
            }

            @Override
            protected Character convertCharacter(Object value) throws BadInputException {
                return RepresentationFormat.this.convertCharacter(value);
            }

            @Override
            protected Double convertDouble(Object value) throws BadInputException {
                return RepresentationFormat.this.convertDouble(value);
            }

            @Override
            protected Float convertFloat(Object value) throws BadInputException {
                return RepresentationFormat.this.convertFloat(value);
            }

            @Override
            protected Integer convertInteger(Object value) throws BadInputException {
                return RepresentationFormat.this.convertInteger(value);
            }

            @Override
            protected Long convertLong(Object value) throws BadInputException {
                return RepresentationFormat.this.convertLong(value);
            }

            @Override
            protected Node convertNode(GraphDatabaseSPI graphDb, Object value) throws BadInputException {
                return RepresentationFormat.this.convertNode(graphDb, value);
            }

            @Override
            protected Relationship convertRelationship(GraphDatabaseSPI graphDb, Object value) throws BadInputException {
                return RepresentationFormat.this.convertRelationship(graphDb, value);
            }

            @Override
            protected Short convertShort(Object value) throws BadInputException {
                return RepresentationFormat.this.convertShort(value);
            }

            @Override
            protected String convertString(Object value) throws BadInputException {
                return RepresentationFormat.this.convertString(value);
            }

            @Override
            protected URI convertURI(Object value) throws BadInputException {
                return RepresentationFormat.this.convertURI(value);
            }
        };
    }

    protected Relationship convertRelationship(GraphDatabaseSPI graphDb, Object value) throws BadInputException {
        if (value instanceof Relationship) {
            return (Relationship)value;
        }
        if (value instanceof URI) {
            try {
                return this.getRelationship(graphDb, (URI)value);
            }
            catch (RelationshipNotFoundException e) {
                throw new BadInputException(e);
            }
        }
        if (value instanceof String) {
            try {
                return this.getRelationship(graphDb, (String)value);
            }
            catch (RelationshipNotFoundException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Node convertNode(GraphDatabaseSPI graphDb, Object value) throws BadInputException {
        if (value instanceof Node) {
            return (Node)value;
        }
        if (value instanceof URI) {
            try {
                return this.getNode(graphDb, (URI)value);
            }
            catch (NodeNotFoundException e) {
                throw new BadInputException(e);
            }
        }
        if (value instanceof String) {
            try {
                return this.getNode(graphDb, (String)value);
            }
            catch (NodeNotFoundException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Node getNode(GraphDatabaseSPI graphDb, String value) throws BadInputException, NodeNotFoundException {
        try {
            return this.getNode(graphDb, new URI(value));
        }
        catch (URISyntaxException e) {
            throw new BadInputException(e);
        }
    }

    protected Node getNode(GraphDatabaseSPI graphDb, URI uri) throws BadInputException, NodeNotFoundException {
        try {
            return graphDb.getNodeById(this.extractId(uri));
        }
        catch (NotFoundException e) {
            throw new NodeNotFoundException(e);
        }
    }

    private long extractId(URI uri) throws BadInputException {
        String[] path = uri.getPath().split("/");
        try {
            return Long.parseLong(path[path.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new BadInputException(e);
        }
    }

    private Relationship getRelationship(GraphDatabaseSPI graphDb, String value) throws BadInputException, RelationshipNotFoundException {
        try {
            return this.getRelationship(graphDb, new URI(value));
        }
        catch (URISyntaxException e) {
            throw new BadInputException(e);
        }
    }

    protected Relationship getRelationship(GraphDatabaseSPI graphDb, URI uri) throws BadInputException, RelationshipNotFoundException {
        try {
            return graphDb.getRelationshipById(this.extractId(uri));
        }
        catch (NotFoundException e) {
            throw new RelationshipNotFoundException();
        }
    }

    protected URI convertURI(Object value) throws BadInputException {
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof String) {
            try {
                return new URI((String)value);
            }
            catch (URISyntaxException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected String convertString(Object value) throws BadInputException {
        if (value instanceof String) {
            return (String)value;
        }
        throw new BadInputException("Could not convert!");
    }

    protected Short convertShort(Object value) throws BadInputException {
        if (value instanceof Number && !(value instanceof Float) && !(value instanceof Double)) {
            short primitive = ((Number)value).shortValue();
            if ((long)primitive != ((Number)value).longValue()) {
                throw new BadInputException("Input did not fit in short");
            }
            return primitive;
        }
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Long convertLong(Object value) throws BadInputException {
        if (value instanceof Number && !(value instanceof Float) && !(value instanceof Double)) {
            long primitive = ((Number)value).longValue();
            return primitive;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Integer convertInteger(Object value) throws BadInputException {
        if (value instanceof Number && !(value instanceof Float) && !(value instanceof Double)) {
            int primitive = ((Number)value).intValue();
            if ((long)primitive != ((Number)value).longValue()) {
                throw new BadInputException("Input did not fit in int");
            }
            return primitive;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Float convertFloat(Object value) throws BadInputException {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            catch (NumberFormatException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Double convertDouble(Object value) throws BadInputException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Character convertCharacter(Object value) throws BadInputException {
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Number) {
            int primitive = ((Number)value).intValue();
            if ((long)primitive != ((Number)value).longValue() || primitive > 65535) {
                throw new BadInputException("Input did not fit in char");
            }
            return Character.valueOf((char)primitive);
        }
        if (value instanceof String && ((String)value).length() == 1) {
            return Character.valueOf(((String)value).charAt(0));
        }
        throw new BadInputException("Could not convert!");
    }

    protected Byte convertByte(Object value) throws BadInputException {
        if (value instanceof Number) {
            byte primitive = ((Number)value).byteValue();
            if ((long)primitive != ((Number)value).longValue()) {
                throw new BadInputException("Input did not fit in byte");
            }
            return primitive;
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }

    protected Boolean convertBoolean(Object value) throws BadInputException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            try {
                return Boolean.parseBoolean((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadInputException(e);
            }
        }
        throw new BadInputException("Could not convert!");
    }
}

