/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb.metadata;

import apoc.SystemPropertyKeys;
import apoc.export.util.ProgressReporter;
import apoc.systemdb.metadata.ExportMetadata;
import apoc.util.JsonUtil;
import apoc.util.Util;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.helpers.collection.Pair;

public class ExportTrigger
implements ExportMetadata {
    @Override
    public List<Pair<String, String>> export(Node node, ProgressReporter progressReporter) {
        String name = (String)node.getProperty(SystemPropertyKeys.name.name());
        String query = (String)node.getProperty(SystemPropertyKeys.statement.name());
        try {
            String selector = Util.toCypherMap((Map)((Map)JsonUtil.OBJECT_MAPPER.readValue((String)node.getProperty(SystemPropertyKeys.selector.name()), Map.class)));
            String params = Util.toCypherMap((Map)((Map)JsonUtil.OBJECT_MAPPER.readValue((String)node.getProperty(SystemPropertyKeys.params.name()), Map.class)));
            Object statement = String.format("CALL apoc.trigger.add('%s', '%s', %s, {params: %s});", name, query, selector, params);
            if (((Boolean)node.getProperty(SystemPropertyKeys.paused.name())).booleanValue()) {
                statement = (String)statement + String.format("\nCALL apoc.trigger.pause('%s');", name);
            }
            progressReporter.nextRow();
            return List.of(Pair.of((Object)this.getFileName(node, ExportMetadata.Type.Trigger.name()), (Object)statement));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

