/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb.metadata;

import apoc.SystemPropertyKeys;
import apoc.custom.CypherProceduresHandler;
import apoc.export.util.ProgressReporter;
import apoc.systemdb.metadata.ExportMetadata;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.procs.FieldSignature;

public class ExportProcedure
implements ExportMetadata {
    @Override
    public List<Pair<String, String>> export(Node node, ProgressReporter progressReporter) {
        String inputs = ExportProcedure.getSignature(node, SystemPropertyKeys.inputs.name());
        String outputName = SystemPropertyKeys.output.name();
        String outputs = node.hasProperty(outputName) ? (String)node.getProperty(outputName) : ExportProcedure.getSignature(node, SystemPropertyKeys.outputs.name());
        String statement = String.format("CALL apoc.custom.declareProcedure('%s(%s) :: (%s)', '%s', '%s', '%s');", node.getProperty(SystemPropertyKeys.name.name()), inputs, outputs, node.getProperty(SystemPropertyKeys.statement.name()), node.getProperty(SystemPropertyKeys.mode.name()), node.getProperty(SystemPropertyKeys.description.name()));
        progressReporter.nextRow();
        return List.of(Pair.of((Object)this.getFileName(node, ExportMetadata.Type.CypherProcedure.name()), (Object)statement));
    }

    static String getSignature(Node node, String name) {
        return CypherProceduresHandler.deserializeSignatures((String)node.getProperty(name)).stream().map(FieldSignature::toString).collect(Collectors.joining(", "));
    }
}

