/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.aws;

import apoc.Extended;
import apoc.nlp.NLPHelperFunctions;
import apoc.nlp.aws.AWSClient;
import apoc.nlp.aws.AWSVirtualEntitiesGraph;
import apoc.nlp.aws.AWSVirtualKeyPhrasesGraph;
import apoc.nlp.aws.AWSVirtualSentimentVirtualGraph;
import apoc.nlp.aws.DummyAWSClient;
import apoc.nlp.aws.RealAWSClient;
import apoc.result.NodeWithMapResult;
import apoc.result.VirtualGraph;
import apoc.util.JsonUtil;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import com.amazonaws.services.comprehend.model.BatchItemError;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Extended
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0002J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapoc/nlp/aws/AWSProcedures;", "", "()V", "log", "Lorg/neo4j/logging/Log;", "tx", "Lorg/neo4j/graphdb/Transaction;", "awsClient", "Lapoc/nlp/aws/AWSClient;", "config", "", "", "entitiesGraph", "Ljava/util/stream/Stream;", "Lapoc/result/VirtualGraph;", "source", "entitiesStream", "Lapoc/result/NodeWithMapResult;", "keyPhrasesGraph", "keyPhrasesStream", "sentimentGraph", "sentimentStream", "Companion", "apoc"})
public final class AWSProcedures {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Context
    @JvmField
    @Nullable
    public Log log;
    @Context
    @JvmField
    @Nullable
    public Transaction tx;

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.entities.stream", mode=Mode.READ)
    @Description(value="Returns a stream of entities for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> entitiesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        NLPHelperFunctions.INSTANCE.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.entities((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(AWSProcedures::entitiesStream$lambda-2);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"batches.mapIndexed { ind\u2026e, result!!) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.entities.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) entity graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> entitiesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AWSVirtualEntitiesGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        NLPHelperFunctions.INSTANCE.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.entityRelationshipType(config);
        String relationshipProperty = (String)config.getOrDefault("writeRelationshipProperty", "score");
        boolean storeGraph = (Boolean)config.getOrDefault("write", (Object)false);
        Number scoreCutoff = (Number)config.getOrDefault("scoreCutoff", (Object)0.0);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var13_12 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.entities(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BatchDetectEntitiesResult result;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)$dstr$batch$result.component1();
            BatchDetectEntitiesResult batchDetectEntitiesResult = result = (BatchDetectEntitiesResult)$dstr$batch$result.component2();
            Intrinsics.checkNotNull((Object)batchDetectEntitiesResult);
            collection.add(new AWSVirtualEntitiesGraph(batchDetectEntitiesResult, batch, relationshipType, relationshipProperty, scoreCutoff));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AWSVirtualEntitiesGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.keyPhrases.stream", mode=Mode.READ)
    @Description(value="Returns a stream of key phrases for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> keyPhrasesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        NLPHelperFunctions.INSTANCE.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.keyPhrases((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(AWSProcedures::keyPhrasesStream$lambda-8);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"batches.mapIndexed { ind\u2026e, result!!) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.keyPhrases.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) key phrases graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> keyPhrasesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AWSVirtualKeyPhrasesGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        NLPHelperFunctions.INSTANCE.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.keyPhraseRelationshipType(config);
        String relationshipProperty = (String)config.getOrDefault("writeRelationshipProperty", "score");
        boolean storeGraph = (Boolean)config.getOrDefault("write", (Object)false);
        Number scoreCutoff = (Number)config.getOrDefault("scoreCutoff", (Object)0.0);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var13_12 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.keyPhrases(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BatchDetectKeyPhrasesResult result;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)$dstr$batch$result.component1();
            BatchDetectKeyPhrasesResult batchDetectKeyPhrasesResult = result = (BatchDetectKeyPhrasesResult)$dstr$batch$result.component2();
            Intrinsics.checkNotNull((Object)batchDetectKeyPhrasesResult);
            collection.add(new AWSVirtualKeyPhrasesGraph(batchDetectKeyPhrasesResult, batch, relationshipType, relationshipProperty, scoreCutoff));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AWSVirtualKeyPhrasesGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.sentiment.stream", mode=Mode.READ)
    @Description(value="Returns stream of sentiment for items in provided text")
    @NotNull
    public final Stream<NodeWithMapResult> sentimentStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        NLPHelperFunctions.INSTANCE.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.sentiment((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(AWSProcedures::sentimentStream$lambda-14);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"batches.mapIndexed { ind\u2026e, result!!) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.sentiment.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) sentiment graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> sentimentGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AWSVirtualSentimentVirtualGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        NLPHelperFunctions.INSTANCE.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        boolean storeGraph = (Boolean)config.getOrDefault("write", (Object)false);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var10_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.sentiment(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BatchDetectSentimentResult result;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)$dstr$batch$result.component1();
            BatchDetectSentimentResult batchDetectSentimentResult = result = (BatchDetectSentimentResult)$dstr$batch$result.component2();
            Intrinsics.checkNotNull((Object)batchDetectSentimentResult);
            collection.add(new AWSVirtualSentimentVirtualGraph(batchDetectSentimentResult, batch));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AWSVirtualSentimentVirtualGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    private final AWSClient awsClient(Map<String, ? extends Object> config) {
        AWSClient aWSClient;
        boolean useDummyClient = (Boolean)config.getOrDefault("unsupportedDummyClient", (Object)false);
        if (useDummyClient) {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            aWSClient = new DummyAWSClient(config, log);
        } else {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            aWSClient = new RealAWSClient(config, log);
        }
        return aWSClient;
    }

    /*
     * WARNING - void declaration
     */
    private static final Stream entitiesStream$lambda-2(Pair $dstr$batch$result) {
        void $this$mapIndexedTo$iv$iv;
        List batch = (List)$dstr$batch$result.component1();
        BatchDetectEntitiesResult result = (BatchDetectEntitiesResult)$dstr$batch$result.component2();
        Iterable $this$mapIndexed$iv = batch;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void node;
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node node2 = (Node)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BatchDetectEntitiesResult batchDetectEntitiesResult = result;
            Intrinsics.checkNotNull((Object)batchDetectEntitiesResult);
            collection.add(Companion.transformResults((int)index, (Node)node, batchDetectEntitiesResult));
        }
        return ((List)destination$iv$iv).stream();
    }

    /*
     * WARNING - void declaration
     */
    private static final Stream keyPhrasesStream$lambda-8(Pair $dstr$batch$result) {
        void $this$mapIndexedTo$iv$iv;
        List batch = (List)$dstr$batch$result.component1();
        BatchDetectKeyPhrasesResult result = (BatchDetectKeyPhrasesResult)$dstr$batch$result.component2();
        Iterable $this$mapIndexed$iv = batch;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void node;
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node node2 = (Node)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BatchDetectKeyPhrasesResult batchDetectKeyPhrasesResult = result;
            Intrinsics.checkNotNull((Object)batchDetectKeyPhrasesResult);
            collection.add(Companion.transformResults((int)index, (Node)node, batchDetectKeyPhrasesResult));
        }
        return ((List)destination$iv$iv).stream();
    }

    /*
     * WARNING - void declaration
     */
    private static final Stream sentimentStream$lambda-14(Pair $dstr$batch$result) {
        void $this$mapIndexedTo$iv$iv;
        List batch = (List)$dstr$batch$result.component1();
        BatchDetectSentimentResult result = (BatchDetectSentimentResult)$dstr$batch$result.component2();
        Iterable $this$mapIndexed$iv = batch;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void node;
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node node2 = (Node)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BatchDetectSentimentResult batchDetectSentimentResult = result;
            Intrinsics.checkNotNull((Object)batchDetectSentimentResult);
            collection.add(Companion.transformResults((int)index, (Node)node, batchDetectSentimentResult));
        }
        return ((List)destination$iv$iv).stream();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lapoc/nlp/aws/AWSProcedures$Companion;", "", "()V", "transformResults", "Lapoc/result/NodeWithMapResult;", "index", "", "node", "Lorg/neo4j/graphdb/Node;", "res", "Lcom/amazonaws/services/comprehend/model/BatchDetectEntitiesResult;", "Lcom/amazonaws/services/comprehend/model/BatchDetectKeyPhrasesResult;", "Lcom/amazonaws/services/comprehend/model/BatchDetectSentimentResult;", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node, @NotNull BatchDetectEntitiesResult res) {
            List list;
            Object v1;
            List list2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                list2 = res.getResultList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"res.resultList");
                for (Object t : (Iterable)list2) {
                    BatchDetectEntitiesItemResult result = (BatchDetectEntitiesItemResult)t;
                    boolean bl = false;
                    Integer n = result.getIndex();
                    int n2 = index;
                    if (!(n != null && n == n2)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            BatchDetectEntitiesItemResult result = v1;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                Intrinsics.checkNotNull((Object)objectMapper);
                Object object = objectMapper.convertValue((Object)result, Map.class);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                }
                list2 = NodeWithMapResult.withResult((Node)node, (Map)((Map)object));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                NodeWi\u2026ing, Any?>)\n            }");
                list = list2;
            } else {
                Object v6;
                Pair[] pairArray;
                block6: {
                    pairArray = res.getErrorList();
                    Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"res.errorList");
                    for (Object t : (Iterable)pairArray) {
                        BatchItemError error = (BatchItemError)t;
                        boolean bl = false;
                        Integer n = error.getIndex();
                        int n3 = index;
                        if (!(n != null && n == n3)) continue;
                        v6 = t;
                        break block6;
                    }
                    v6 = null;
                }
                BatchItemError err = v6;
                pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError == null ? null : batchItemError.getErrorCode()));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 == null ? null : batchItemError2.getErrorMessage()));
                list2 = NodeWithMapResult.withError((Node)node, (Map)MapsKt.mapOf((Pair[])pairArray));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                val er\u2026orMessage))\n            }");
                list = list2;
            }
            return list;
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node, @NotNull BatchDetectKeyPhrasesResult res) {
            List list;
            Object v1;
            List list2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                list2 = res.getResultList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"res.resultList");
                for (Object t : (Iterable)list2) {
                    BatchDetectKeyPhrasesItemResult result = (BatchDetectKeyPhrasesItemResult)t;
                    boolean bl = false;
                    Integer n = result.getIndex();
                    int n2 = index;
                    if (!(n != null && n == n2)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            BatchDetectKeyPhrasesItemResult result = v1;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                Intrinsics.checkNotNull((Object)objectMapper);
                Object object = objectMapper.convertValue((Object)result, Map.class);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                }
                list2 = NodeWithMapResult.withResult((Node)node, (Map)((Map)object));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                NodeWi\u2026ing, Any?>)\n            }");
                list = list2;
            } else {
                Object v6;
                Pair[] pairArray;
                block6: {
                    pairArray = res.getErrorList();
                    Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"res.errorList");
                    for (Object t : (Iterable)pairArray) {
                        BatchItemError error = (BatchItemError)t;
                        boolean bl = false;
                        Integer n = error.getIndex();
                        int n3 = index;
                        if (!(n != null && n == n3)) continue;
                        v6 = t;
                        break block6;
                    }
                    v6 = null;
                }
                BatchItemError err = v6;
                pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError == null ? null : batchItemError.getErrorCode()));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 == null ? null : batchItemError2.getErrorMessage()));
                list2 = NodeWithMapResult.withError((Node)node, (Map)MapsKt.mapOf((Pair[])pairArray));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                val er\u2026orMessage))\n            }");
                list = list2;
            }
            return list;
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node, @NotNull BatchDetectSentimentResult res) {
            List list;
            Object v1;
            List list2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                list2 = res.getResultList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"res.resultList");
                for (Object t : (Iterable)list2) {
                    BatchDetectSentimentItemResult result = (BatchDetectSentimentItemResult)t;
                    boolean bl = false;
                    Integer n = result.getIndex();
                    int n2 = index;
                    if (!(n != null && n == n2)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            BatchDetectSentimentItemResult result = v1;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                Intrinsics.checkNotNull((Object)objectMapper);
                Object object = objectMapper.convertValue((Object)result, Map.class);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                }
                list2 = NodeWithMapResult.withResult((Node)node, (Map)((Map)object));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                NodeWi\u2026ing, Any?>)\n            }");
                list = list2;
            } else {
                Object v6;
                Pair[] pairArray;
                block6: {
                    pairArray = res.getErrorList();
                    Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"res.errorList");
                    for (Object t : (Iterable)pairArray) {
                        BatchItemError error = (BatchItemError)t;
                        boolean bl = false;
                        Integer n = error.getIndex();
                        int n3 = index;
                        if (!(n != null && n == n3)) continue;
                        v6 = t;
                        break block6;
                    }
                    v6 = null;
                }
                BatchItemError err = v6;
                pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError == null ? null : batchItemError.getErrorCode()));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 == null ? null : batchItemError2.getErrorMessage()));
                list2 = NodeWithMapResult.withError((Node)node, (Map)MapsKt.mapOf((Pair[])pairArray));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n                val er\u2026orMessage))\n            }");
                list = list2;
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

