/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.load.LoadDirectoryHandler;
import apoc.load.LoadDirectoryItem;
import apoc.result.StringResult;
import apoc.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadDirectory {
    @Context
    public Log log;
    @Context
    public GraphDatabaseService db;
    @Context
    public LoadDirectoryHandler loadDirectoryHandler;
    @Context
    public Transaction tx;

    @Procedure(name="apoc.load.directory.async.add", mode=Mode.WRITE)
    @Description(value="apoc.load.directory.async.add(name, cypher, pattern, urlDir, {}) YIELD name, status, pattern, cypher, urlDir, config, error - Add or replace a folder listener with a specific name, pattern and url directory that execute the specified cypher query when an event is triggered and return listener list")
    public Stream<LoadDirectoryItem.LoadDirectoryResult> add(@Name(value="name") String name, @Name(value="cypher") String cypher, @Name(value="pattern", defaultValue="*") String pattern, @Name(value="urlDir", defaultValue="") String urlDir, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        ApocConfig.apocConfig().checkReadAllowed(urlDir);
        Util.validateQuery((GraphDatabaseService)this.db, (String)cypher, (QueryExecutionType.QueryType[])new QueryExecutionType.QueryType[]{QueryExecutionType.QueryType.READ_WRITE, QueryExecutionType.QueryType.WRITE});
        LoadDirectoryItem.LoadDirectoryConfig conf = new LoadDirectoryItem.LoadDirectoryConfig(config);
        LoadDirectoryItem loadDirectoryItem = new LoadDirectoryItem(name, pattern, cypher, LoadDirectory.checkIfUrlBlankAndGetFileUrl(urlDir), conf);
        this.loadDirectoryHandler.add(loadDirectoryItem);
        return this.loadDirectoryHandler.list();
    }

    @Procedure(value="apoc.load.directory.async.remove")
    @Description(value="apoc.load.directory.async.remove(name) YIELD name, status, pattern, cypher, urlDir, config, error - Remove a folder listener by name and return remaining listeners, if any")
    public Stream<LoadDirectoryItem.LoadDirectoryResult> remove(@Name(value="name") String name) {
        this.loadDirectoryHandler.remove(name);
        return this.loadDirectoryHandler.list();
    }

    @Procedure(value="apoc.load.directory.async.removeAll")
    @Description(value="apoc.load.directory.async.removeAll() - Remove all folder listeners")
    public Stream<LoadDirectoryItem.LoadDirectoryResult> removeAll() {
        this.loadDirectoryHandler.removeAll();
        return Stream.empty();
    }

    @Procedure(value="apoc.load.directory.async.list")
    @Description(value="apoc.load.directory.async.list() YIELD name, status, pattern, cypher, urlDir, config, error - List of all folder listeners")
    public Stream<LoadDirectoryItem.LoadDirectoryResult> list() {
        return this.loadDirectoryHandler.list();
    }

    @Procedure
    @Description(value="apoc.load.directory('pattern', 'urlDir', {config}) YIELD value - Loads list of all files in folder specified by urlDir or in import folder if urlDir string is empty or not specified")
    public Stream<StringResult> directory(@Name(value="pattern", defaultValue="*") String pattern, @Name(value="urlDir", defaultValue="") String urlDir, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        if (urlDir == null) {
            throw new IllegalArgumentException("Invalid (null) urlDir");
        }
        urlDir = LoadDirectory.checkIfUrlBlankAndGetFileUrl(urlDir);
        boolean isRecursive = Util.toBoolean((Object)config.getOrDefault("recursive", true));
        Collection files = FileUtils.listFiles((File)apoc.util.FileUtils.getPathFromUrlString((String)urlDir).toFile(), (IOFileFilter)new WildcardFileFilter(pattern), (IOFileFilter)(isRecursive ? TrueFileFilter.TRUE : FileFileFilter.INSTANCE));
        return files.stream().map(i -> {
            String urlFile = i.toString();
            return new StringResult(LoadDirectoryHandler.getPathDependingOnUseNeo4jConfig(urlFile));
        });
    }

    public static String checkIfUrlBlankAndGetFileUrl(String urlDir) throws IOException {
        if (StringUtils.isBlank((CharSequence)urlDir)) {
            Path pathImport = Paths.get(apoc.util.FileUtils.getDirImport(), new String[0]).toAbsolutePath();
            return pathImport.toUri().toString().replaceAll(".$", "");
        }
        return apoc.util.FileUtils.changeFileUrlIfImportDirectoryConstrained((String)urlDir.replace("?", "%3F"));
    }
}

