/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

import apoc.Extended;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.storable.DurationValue;

@Extended
public class CollFull {
    @UserFunction
    @Description(value="apoc.coll.avgDuration([duration('P2DT3H'), duration('PT1H45S'), ...]) -  returns the average of a list of duration values")
    public DurationValue avgDuration(@Name(value="durations") List<DurationValue> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        long count = 0L;
        double monthsRunningAvg = 0.0;
        double daysRunningAvg = 0.0;
        double secondsRunningAvg = 0.0;
        double nanosRunningAvg = 0.0;
        for (DurationValue duration : list) {
            monthsRunningAvg += ((double)duration.get((TemporalUnit)ChronoUnit.MONTHS) - monthsRunningAvg) / (double)(++count);
            daysRunningAvg += ((double)duration.get((TemporalUnit)ChronoUnit.DAYS) - daysRunningAvg) / (double)count;
            secondsRunningAvg += ((double)duration.get((TemporalUnit)ChronoUnit.SECONDS) - secondsRunningAvg) / (double)count;
            nanosRunningAvg += ((double)duration.get((TemporalUnit)ChronoUnit.NANOS) - nanosRunningAvg) / (double)count;
        }
        return DurationValue.approximate((double)monthsRunningAvg, (double)daysRunningAvg, (double)secondsRunningAvg, (double)nanosRunningAvg).normalize();
    }
}

