/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.aws;

import apoc.nlp.NLPVirtualGraph;
import apoc.nlp.aws.AWSProcedures;
import apoc.result.VirtualGraph;
import apoc.result.VirtualNode;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J#\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\t\u0010\u0017\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lapoc/nlp/aws/AWSVirtualSentimentVirtualGraph;", "Lapoc/nlp/NLPVirtualGraph;", "detectEntitiesResult", "Lcom/amazonaws/services/comprehend/model/BatchDetectSentimentResult;", "sourceNodes", "", "Lorg/neo4j/graphdb/Node;", "(Lcom/amazonaws/services/comprehend/model/BatchDetectSentimentResult;Ljava/util/List;)V", "component1", "component2", "copy", "createVirtualGraph", "Lapoc/result/VirtualGraph;", "transaction", "Lorg/neo4j/graphdb/Transaction;", "equals", "", "other", "", "extractDocument", "index", "", "sourceNode", "hashCode", "toString", "", "Companion", "apoc"})
public final class AWSVirtualSentimentVirtualGraph
extends NLPVirtualGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BatchDetectSentimentResult detectEntitiesResult;
    @NotNull
    private final List<Node> sourceNodes;

    public AWSVirtualSentimentVirtualGraph(@NotNull BatchDetectSentimentResult detectEntitiesResult, @NotNull List<? extends Node> sourceNodes) {
        Intrinsics.checkNotNullParameter((Object)detectEntitiesResult, (String)"detectEntitiesResult");
        Intrinsics.checkNotNullParameter(sourceNodes, (String)"sourceNodes");
        this.detectEntitiesResult = detectEntitiesResult;
        this.sourceNodes = sourceNodes;
    }

    @Override
    @Nullable
    public Object extractDocument(int index, @NotNull Node sourceNode) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        return AWSProcedures.Companion.transformResults((int)index, (Node)sourceNode, (BatchDetectSentimentResult)this.detectEntitiesResult).value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VirtualGraph createVirtualGraph(@Nullable Transaction transaction) {
        boolean storeGraph = transaction != null;
        Set allNodes = new LinkedHashSet();
        Set allRelationships = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = this.sourceNodes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Node node;
            void sourceNode;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node node2 = (Node)item$iv;
            int index = n;
            boolean bl = false;
            Object object = this.extractDocument(index, (Node)sourceNode);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Map document = (Map)object;
            Pair<String, Float> pair = Companion.extractSentiment(document);
            String sentiment = (String)pair.component1();
            float score = ((Number)pair.component2()).floatValue();
            if (storeGraph) {
                sourceNode.setProperty("sentiment", (Object)sentiment);
                sourceNode.setProperty("sentimentScore", (Object)Float.valueOf(score));
                node = sourceNode;
            } else {
                Iterable iterable = sourceNode.getPropertyKeys();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"sourceNode.propertyKeys");
                VirtualNode virtualNode = new VirtualNode((Node)sourceNode, CollectionsKt.toList((Iterable)iterable));
                virtualNode.setProperty("sentiment", (Object)sentiment);
                virtualNode.setProperty("sentimentScore", (Object)Float.valueOf(score));
                node = (Node)virtualNode;
            }
            void node3 = node;
            allNodes.add(node3);
        }
        return new VirtualGraph("Graph", (Iterable)allNodes, (Iterable)allRelationships, MapsKt.emptyMap());
    }

    private final BatchDetectSentimentResult component1() {
        return this.detectEntitiesResult;
    }

    private final List<Node> component2() {
        return this.sourceNodes;
    }

    @NotNull
    public final AWSVirtualSentimentVirtualGraph copy(@NotNull BatchDetectSentimentResult detectEntitiesResult, @NotNull List<? extends Node> sourceNodes) {
        Intrinsics.checkNotNullParameter((Object)detectEntitiesResult, (String)"detectEntitiesResult");
        Intrinsics.checkNotNullParameter(sourceNodes, (String)"sourceNodes");
        return new AWSVirtualSentimentVirtualGraph(detectEntitiesResult, sourceNodes);
    }

    public static /* synthetic */ AWSVirtualSentimentVirtualGraph copy$default(AWSVirtualSentimentVirtualGraph aWSVirtualSentimentVirtualGraph, BatchDetectSentimentResult batchDetectSentimentResult, List list, int n, Object object) {
        if ((n & 1) != 0) {
            batchDetectSentimentResult = aWSVirtualSentimentVirtualGraph.detectEntitiesResult;
        }
        if ((n & 2) != 0) {
            list = aWSVirtualSentimentVirtualGraph.sourceNodes;
        }
        return aWSVirtualSentimentVirtualGraph.copy(batchDetectSentimentResult, list);
    }

    @NotNull
    public String toString() {
        return "AWSVirtualSentimentVirtualGraph(detectEntitiesResult=" + this.detectEntitiesResult + ", sourceNodes=" + this.sourceNodes + ")";
    }

    public int hashCode() {
        int result = this.detectEntitiesResult.hashCode();
        result = result * 31 + ((Object)this.sourceNodes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AWSVirtualSentimentVirtualGraph)) {
            return false;
        }
        AWSVirtualSentimentVirtualGraph aWSVirtualSentimentVirtualGraph = (AWSVirtualSentimentVirtualGraph)other;
        if (!Intrinsics.areEqual((Object)this.detectEntitiesResult, (Object)aWSVirtualSentimentVirtualGraph.detectEntitiesResult)) {
            return false;
        }
        return Intrinsics.areEqual(this.sourceNodes, aWSVirtualSentimentVirtualGraph.sourceNodes);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b\u00a8\u0006\t"}, d2={"Lapoc/nlp/aws/AWSVirtualSentimentVirtualGraph$Companion;", "", "()V", "extractSentiment", "Lkotlin/Pair;", "", "", "value", "", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<String, Float> extractSentiment(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Object object = value.get("sentiment");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String sentiment = WordUtils.capitalizeFully((String)((String)object));
            Object object2 = value.get("sentimentScore");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Map sentimentScore = (Map)object2;
            Intrinsics.checkNotNullExpressionValue((Object)sentiment, (String)"sentiment");
            String string = sentiment.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            Object v = sentimentScore.get(string);
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            return new Pair((Object)sentiment, (Object)Float.valueOf(((Float)v).floatValue()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

