/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.mongodb.MongoDBUtils;
import apoc.mongodb.MongoDbConfig;
import apoc.util.Util;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCommandException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNumber;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

class MongoDBColl
implements MongoDBUtils.Coll {
    private static final ObjectMapper jsonMapper = new ObjectMapper().enable(DeserializationFeature.USE_LONG_FOR_INTS);
    public static final String ID = "_id";
    private final MongoCollection<Document> collection;
    private final MongoClient mongoClient;
    private boolean compatibleValues = false;
    private boolean doorStop = false;
    private final MongoDatabase database;
    private boolean extractReferences = false;
    private boolean objectIdAsMap = true;
    public static final String ERROR_MESSAGE = "The connection string must have %s name";

    private MongoDBColl(String url, String db, String coll) {
        MongoClientURI connectionString = new MongoClientURI(url);
        this.mongoClient = new MongoClient(connectionString);
        this.database = this.mongoClient.getDatabase(db);
        this.collection = this.database.getCollection(coll);
    }

    public MongoDBColl(String url, String db, String coll, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
        this(url, db, coll);
        this.getConfigs(compatibleValues, extractReferences, objectIdAsMap);
    }

    public MongoDBColl(String uri, MongoDbConfig conf) {
        String collectionName;
        MongoClientURI connectionString = new MongoClientURI(uri);
        if (connectionString.getDatabase() == null) {
            throw new RuntimeException(String.format(ERROR_MESSAGE, "db"));
        }
        String confCollection = conf.getCollection();
        if (StringUtils.isNotBlank((String)confCollection)) {
            collectionName = confCollection;
        } else {
            String collectionFromUri = connectionString.getCollection();
            if (collectionFromUri == null) {
                throw new RuntimeException(String.format(ERROR_MESSAGE, "collection"));
            }
            collectionName = collectionFromUri;
        }
        this.mongoClient = new MongoClient(connectionString);
        this.database = this.mongoClient.getDatabase(connectionString.getDatabase());
        try {
            this.database.runCommand((Bson)new Document("listCollections", (Object)1));
        }
        catch (MongoCommandException e) {
            this.mongoClient.close();
            throw new RuntimeException(e);
        }
        this.collection = this.database.getCollection(collectionName);
        this.getConfigs(true, conf.isExtractReferences(), conf.isObjectIdAsMap());
    }

    private void getConfigs(boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
        this.compatibleValues = compatibleValues;
        this.extractReferences = extractReferences;
        this.objectIdAsMap = objectIdAsMap;
    }

    @Override
    public void close() {
        if (this.doorStop) {
            return;
        }
        this.mongoClient.close();
    }

    private Map<String, Object> documentToPackableMap(Map<String, Object> document) {
        return (Map)this.convertAndExtract(document);
    }

    public Object convertAndExtract(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            return map.entrySet().stream().map(e -> {
                Object value;
                if (ID.equals(e.getKey())) {
                    if (this.compatibleValues && this.objectIdAsMap) {
                        try {
                            value = jsonMapper.readValue(jsonMapper.writeValueAsBytes(e.getValue()), Map.class);
                        }
                        catch (Exception exc) {
                            throw new RuntimeException("Cannot convert document to json and back to Map " + exc.getMessage());
                        }
                    } else {
                        value = e.getValue().toString();
                    }
                } else {
                    value = this.convertAndExtract(e.getValue());
                }
                return new AbstractMap.SimpleEntry(e.getKey(), value);
            }).collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
        }
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            return collection.stream().map(elem -> this.convertAndExtract(elem)).collect(Collectors.toList());
        }
        if (data.getClass().isArray() && !data.getClass().getComponentType().isPrimitive() && data.getClass().getComponentType().equals(String.class)) {
            return Stream.of((Object[])data).map(elem -> this.convertAndExtract(elem)).collect(Collectors.toList());
        }
        if (this.compatibleValues) {
            if (data instanceof Integer) {
                return ((Integer)data).longValue();
            }
            if (data instanceof BsonInt64 || data instanceof BsonInt32) {
                return ((BsonNumber)data).longValue();
            }
            if (data instanceof BsonDouble) {
                return ((BsonDouble)data).doubleValue();
            }
            if (data instanceof Binary) {
                return ((Binary)data).getData();
            }
            if (data instanceof Float) {
                return ((Float)data).doubleValue();
            }
            if (data instanceof BsonTimestamp) {
                return (long)((BsonTimestamp)data).getTime();
            }
            if (data instanceof MinKey || data instanceof MaxKey) {
                return data.toString();
            }
            if (data instanceof BsonRegularExpression) {
                return ((BsonRegularExpression)data).getPattern();
            }
            if (data instanceof Code) {
                return ((Code)data).getCode();
            }
            if (data instanceof Symbol) {
                return ((Symbol)data).getSymbol();
            }
        }
        if (data instanceof Date) {
            return LocalDateTime.ofInstant(((Date)data).toInstant(), ZoneId.systemDefault());
        }
        if (data instanceof ObjectId) {
            return this.extractReferences ? this.extractReference((ObjectId)data) : data.toString();
        }
        return data;
    }

    private Object extractReference(ObjectId objectId) {
        return StreamSupport.stream(this.database.listCollectionNames().spliterator(), false).map(collectionName -> this.database.getCollection(collectionName)).map(collection -> (Document)collection.find((Bson)new Document(ID, (Object)objectId)).first()).filter(result -> result != null && !result.isEmpty()).findFirst().map(this::documentToPackableMap).orElse(null);
    }

    @Override
    public Map<String, Object> first(Map<String, Object> query) {
        return this.documentToPackableMap((Map)this.collection.find((Bson)new Document(query)).first());
    }

    @Override
    public Stream<Map<String, Object>> all(Map<String, Object> query, Long skip, Long limit) {
        FindIterable documents;
        FindIterable findIterable = documents = query == null ? this.collection.find() : this.collection.find((Bson)new Document(query));
        if (skip != 0L) {
            documents = documents.skip(skip.intValue());
        }
        if (limit != 0L) {
            documents = documents.limit(limit.intValue());
        }
        return this.asStream((MongoIterable<Document>)documents);
    }

    @Override
    public long count(Map<String, Object> query) {
        return query == null ? this.collection.count() : this.collection.count((Bson)new Document(query));
    }

    @Override
    public long count(Document query) {
        return this.collection.count((Bson)query);
    }

    @Override
    public Stream<Map<String, Object>> aggregate(List<Document> pipeline) {
        return this.asStream((MongoIterable<Document>)this.collection.aggregate(pipeline));
    }

    @Override
    public Stream<Map<String, Object>> find(Map<String, Object> query, Map<String, Object> project, Map<String, Object> sort, Long skip, Long limit) {
        FindIterable documents;
        FindIterable findIterable = documents = query == null ? this.collection.find() : this.collection.find((Bson)new Document(query));
        if (project != null) {
            documents = documents.projection((Bson)new Document(project));
        }
        if (sort != null) {
            documents = documents.sort((Bson)new Document(sort));
        }
        if (skip != 0L) {
            documents = documents.skip(skip.intValue());
        }
        if (limit != 0L) {
            documents = documents.limit(limit.intValue());
        }
        return this.asStream((MongoIterable<Document>)documents);
    }

    @Override
    public Stream<Map<String, Object>> find(Document query, Document project, Document sort, int skip, int limit) {
        FindIterable documents = this.collection.find((Bson)query).projection((Bson)project).sort((Bson)sort).skip(skip).limit(limit);
        return this.asStream((MongoIterable<Document>)documents);
    }

    private FindIterable<Document> getDocuments(Map<String, Object> query) {
        return query == null ? this.collection.find() : this.collection.find((Bson)new Document(query));
    }

    private Stream<Map<String, Object>> asStream(MongoIterable<Document> result) {
        this.doorStop = true;
        Iterable it = () -> result.iterator();
        return (Stream)StreamSupport.stream(it.spliterator(), false).map(doc -> this.documentToPackableMap((Map<String, Object>)doc)).onClose(() -> {
            Util.close((AutoCloseable)result.iterator());
            Util.close((AutoCloseable)this.mongoClient);
        });
    }

    @Override
    public void insert(List<Map<String, Object>> docs) {
        for (Map<String, Object> doc : docs) {
            this.collection.insertOne((Object)new Document(doc));
        }
    }

    @Override
    public void insertDocs(List<Document> documents) {
        this.collection.insertMany(documents);
    }

    @Override
    public long update(Map<String, Object> query, Map<String, Object> update) {
        return this.update(new Document(query), new Document(update));
    }

    @Override
    public long update(Document query, Document update) {
        UpdateResult updateResult = this.collection.updateMany((Bson)query, (Bson)update);
        return updateResult.getModifiedCount();
    }

    @Override
    public long delete(Map<String, Object> query) {
        return this.delete(new Document(query));
    }

    @Override
    public long delete(Document query) {
        DeleteResult result = this.collection.deleteMany((Bson)query);
        return result.getDeletedCount();
    }
}

