/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.load.HtmlResultInterface;
import apoc.load.LoadHtml;
import apoc.load.LoadHtmlConfig;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.neo4j.logging.Log;

public class PlainText
implements HtmlResultInterface {
    @Override
    public String getResult(Document document, String selector, LoadHtmlConfig config, List<String> errorList, Log log) {
        LoadHtmlConfig.FailSilently failConfig = config.getFailSilently();
        StringBuilder plainText = new StringBuilder();
        Elements elements = document.select(selector);
        for (Element element : elements) {
            String result = this.getResult(config, errorList, log, failConfig, element);
            plainText.append(result);
        }
        return plainText.toString();
    }

    private String getResult(LoadHtmlConfig config, List<String> errorList, Log log, LoadHtmlConfig.FailSilently failConfig, Element element) {
        return LoadHtml.withError(element, errorList, failConfig, log, () -> this.getPlainText(element, config));
    }

    public String getPlainText(Element element, LoadHtmlConfig config) {
        FormattingVisitor formatter = new FormattingVisitor(config);
        NodeTraversor.traverse((NodeVisitor)formatter, (Node)element);
        return formatter.toString();
    }

    private static class FormattingVisitor
    implements NodeVisitor {
        private int width = 0;
        private final int textSize;
        private final StringBuilder builder = new StringBuilder();

        private FormattingVisitor(LoadHtmlConfig config) {
            this.textSize = config.getTextSize();
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.append("\n - ");
            } else if (name.equals("dt")) {
                this.builder.append("  ");
            } else {
                CharSequence[] charSequences = new CharSequence[]{"p", "h1", "h2", "h3", "h4", "h5", "tr"};
                if (StringUtils.containsAny((CharSequence)name, (CharSequence[])charSequences)) {
                    this.append("\n");
                }
            }
        }

        public void tail(Node node, int depth) {
            CharSequence[] charSequences = new CharSequence[]{"br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5"};
            if (StringUtils.containsAny((CharSequence)node.nodeName(), (CharSequence[])charSequences)) {
                this.append("\n");
            }
        }

        private void append(String text) {
            if (text.startsWith("\n")) {
                this.builder.append(text);
                this.width = 0;
                return;
            }
            if (!StringUtils.isBlank((CharSequence)text)) {
                for (String word : text.split("\\s+")) {
                    if (word.length() + this.width > this.textSize) {
                        this.builder.append("\n");
                        this.width = word.length();
                    } else {
                        this.width += word.length();
                    }
                    this.builder.append(word).append(" ");
                }
            }
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

