/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.Extended;
import apoc.bolt.BoltConnection;
import apoc.result.RowResult;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Bolt {
    @Context
    public GraphDatabaseService db;

    private <T> T withConnection(String url, Map<String, Object> config, Function<BoltConnection, T> action) throws URISyntaxException {
        BoltConnection connection = BoltConnection.from(config, url);
        return action.apply(connection);
    }

    @Procedure
    @Description(value="apoc.bolt.load(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> load(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        return this.withConnection(url, config, conn -> conn.loadFromSession(statement, params));
    }

    @Procedure(value="apoc.bolt.load.fromLocal", mode=Mode.WRITE)
    public Stream<RowResult> fromLocal(@Name(value="url") String url, @Name(value="localStatement") String localStatement, @Name(value="remoteStatement") String remoteStatement, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        return this.withConnection(url, config, conn -> conn.loadFromLocal(localStatement, remoteStatement, this.db));
    }

    @Procedure
    @Description(value="apoc.bolt.execute(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for reads and writes")
    public Stream<RowResult> execute(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        HashMap<String, Object> configuration = new HashMap<String, Object>(config);
        configuration.put("readOnly", false);
        return this.load(url, statement, params, configuration);
    }
}

