/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.Extended;
import apoc.algo.PathFinding;
import apoc.result.WeightedPathResult;
import java.util.stream.Stream;
import org.neo4j.graphalgo.BasicEvaluationContext;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.EvaluationContext;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class PathFindingFull {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;

    @Procedure
    @Description(value="apoc.algo.aStarWithPoint(startNode, endNode, 'relTypesAndDirs', 'distance','pointProp') - equivalent to apoc.algo.aStar but accept a Point type as a pointProperty instead of Number types as latitude and longitude properties")
    public Stream<WeightedPathResult> aStarWithPoint(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="relationshipTypesAndDirections") String relTypesAndDirs, @Name(value="weightPropertyName") String weightPropertyName, @Name(value="pointPropertyName") String pointPropertyName) {
        PathFinder algo = GraphAlgoFactory.aStar((EvaluationContext)new BasicEvaluationContext(this.tx, this.db), (PathExpander)PathFinding.buildPathExpander((String)relTypesAndDirs), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)weightPropertyName), (EstimateEvaluator)new PathFinding.GeoEstimateEvaluatorPointCustom(pointPropertyName));
        return WeightedPathResult.streamWeightedPathResult((Node)startNode, (Node)endNode, (PathFinder)algo);
    }
}

