/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfig;
import apoc.load.Jdbc;
import apoc.util.Util;
import java.util.Iterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class JdbcRegistererInitFactory
extends ExtensionFactory<Dependencies> {
    public JdbcRegistererInitFactory() {
        super(ExtensionType.GLOBAL, "JdbcDriverRegisterer");
    }

    public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
        return new LifecycleAdapter(){

            public void init() throws Exception {
                Util.newDaemonThread(() -> {
                    ApocConfig apocConfig = dependencies.apocConfig();
                    while (!apocConfig.isInitialized()) {
                        Util.sleep((int)10);
                    }
                    Iterators.stream((Iterator)apocConfig.getKeys("apoc.jdbc")).filter(k -> k.endsWith("driver")).forEach(k -> Jdbc.loadDriver(k));
                }).start();
            }
        };
    }

    public static interface Dependencies {
        public ApocConfig apocConfig();
    }
}

