/*
 * Decompiled with CFR 0.152.
 */
package apoc.ttl;

import apoc.Extended;
import apoc.TTLConfig;
import apoc.date.Date;
import apoc.util.MapUtil;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

@Extended
public class TTL {
    @Context
    public TTLConfig ttlConfig;
    @Context
    public GraphDatabaseAPI db;

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.ttl.expire(node,time,'time-unit') - expire node at specified time by setting :TTL label and `ttl` property")
    public void expire(@Name(value="node") Node node, @Name(value="time") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)Date.unit((String)timeUnit).toMillis(time));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.ttl.expireIn(node,timeDelta,'time-unit') - expire node after specified length of time time by setting :TTL label and `ttl` property")
    public void expireIn(@Name(value="node") Node node, @Name(value="timeDelta") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)(System.currentTimeMillis() + Date.unit((String)timeUnit).toMillis(time)));
    }

    @UserFunction
    public Map<String, Object> config() {
        TTLConfig.Values values = this.ttlConfig.configFor(this.db);
        return MapUtil.map((Object[])new Object[]{"enabled", values.enabled, "schedule", values.schedule, "limit", values.limit});
    }
}

