/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.Extended;
import apoc.Pools;
import apoc.periodic.BatchAndTotalCollector;
import apoc.periodic.BatchAndTotalResult;
import apoc.periodic.LoopingBatchAndTotalResult;
import apoc.periodic.PeriodicUtils;
import apoc.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Extended
public class PeriodicExtended {
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public Log log;
    @Context
    public Pools pools;
    @Context
    public Transaction tx;

    private void recordError(Map<String, Long> executionErrors, Exception e) {
        String msg = ExceptionUtils.getRootCause((Throwable)e).getMessage();
        executionErrors.compute(msg, (s, i) -> i == null ? 1L : i + 1L);
    }

    private void validateQuery(String statement) {
        this.db.executeTransactionally("EXPLAIN " + statement);
    }

    @Procedure(mode=Mode.WRITE)
    @Deprecated
    @Description(value="apoc.periodic.rock_n_roll_while('some cypher for knowing when to stop', 'some cypher for iteration', 'some cypher as action on each iteration', 10000) YIELD batches, total - run the action statement in batches over the iterator statement's results in a separate thread. Returns number of batches and total processed rows")
    public Stream<LoopingBatchAndTotalResult> rock_n_roll_while(@Name(value="cypherLoop") String cypherLoop, @Name(value="cypherIterate") String cypherIterate, @Name(value="cypherAction") String cypherAction, @Name(value="batchSize") long batchSize) {
        Map fieldStatement = Util.map((Object[])new String[]{"cypherLoop", cypherLoop, "cypherIterate", cypherIterate});
        this.validateQueries(fieldStatement);
        Stream<LoopingBatchAndTotalResult> allResults = Stream.empty();
        HashMap<String, Object> loopParams = new HashMap<String, Object>(1);
        Object value = null;
        while (true) {
            loopParams.put("previous", value);
            try (Result result = this.tx.execute(cypherLoop, loopParams);){
                value = result.next().get("loop");
                if (!Util.toBoolean(value)) {
                    Stream<LoopingBatchAndTotalResult> stream = allResults;
                    return stream;
                }
            }
            this.log.info("starting batched operation using iteration `%s` in separate thread", new Object[]{cypherIterate});
            result = this.tx.execute(cypherIterate);
            try {
                Stream oneResult = PeriodicUtils.iterateAndExecuteBatchedInSeparateThread((GraphDatabaseService)this.db, (TerminationGuard)this.terminationGuard, (Log)this.log, (Pools)this.pools, (int)((int)batchSize), (boolean)false, (boolean)false, (long)0L, (Iterator)result, (tx, params) -> tx.execute(cypherAction, params).getQueryStatistics(), (int)50, (int)-1);
                Object loopParam = value;
                allResults = Stream.concat(allResults, oneResult.map(r -> r.inLoop(loopParam)));
                continue;
            }
            finally {
                if (result == null) continue;
                result.close();
                continue;
            }
            break;
        }
    }

    private void validateQueries(Map<String, String> fieldStatement) {
        String error = fieldStatement.entrySet().stream().map(e -> {
            try {
                this.validateQuery((String)e.getValue());
                return null;
            }
            catch (Exception exception) {
                return String.format("Exception for field `%s`, message: %s", e.getKey(), exception.getMessage());
            }
        }).filter(e -> e != null).collect(Collectors.joining("\n"));
        if (!error.isEmpty()) {
            throw new RuntimeException(error);
        }
    }

    @Deprecated
    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.periodic.rock_n_roll('some cypher for iteration', 'some cypher as action on each iteration', 10000) YIELD batches, total - run the action statement in batches over the iterator statement's results in a separate thread. Returns number of batches and total processed rows")
    public Stream<BatchAndTotalResult> rock_n_roll(@Name(value="cypherIterate") String cypherIterate, @Name(value="cypherAction") String cypherAction, @Name(value="batchSize") long batchSize) {
        Map fieldStatement = Util.map((Object[])new String[]{"cypherIterate", cypherIterate, "cypherAction", cypherAction});
        this.validateQueries(fieldStatement);
        this.log.info("starting batched operation using iteration `%s` in separate thread", new Object[]{cypherIterate});
        try (Result result = this.tx.execute(cypherIterate);){
            Stream stream = PeriodicUtils.iterateAndExecuteBatchedInSeparateThread((GraphDatabaseService)this.db, (TerminationGuard)this.terminationGuard, (Log)this.log, (Pools)this.pools, (int)((int)batchSize), (boolean)false, (boolean)false, (long)0L, (Iterator)result, (tx, p) -> tx.execute(cypherAction, p).getQueryStatistics(), (int)50, (int)-1);
            return stream;
        }
    }

    private long executeAndReportErrors(Transaction tx, BiConsumer<Transaction, Map<String, Object>> consumer, Map<String, Object> params, List<Map<String, Object>> batch, int returnValue, AtomicLong localCount, BatchAndTotalCollector collector) {
        try {
            consumer.accept(tx, params);
            if (localCount != null) {
                localCount.getAndIncrement();
            }
            return returnValue;
        }
        catch (Exception e) {
            collector.incrementFailedOps((long)batch.size());
            collector.amendFailedParamsMap(batch);
            this.recordError(collector.getOperationErrors(), e);
            throw e;
        }
    }
}

