/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.result.StringResult;
import apoc.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.URIUtil;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadDirectory {
    @Context
    public Log log;

    @Procedure
    @Description(value="apoc.load.directory('pattern', 'urlDir', {config}) YIELD value - Loads list of all files in folder specified by urlDir or in import folder if urlDir string is empty or not specified")
    public Stream<StringResult> directory(@Name(value="pattern", defaultValue="*") String pattern, @Name(value="urlDir", defaultValue="") String urlDir, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        if (urlDir == null) {
            throw new IllegalArgumentException("Invalid (null) urlDir");
        }
        String dirImport = ApocConfig.apocConfig().getString("dbms.directories.import", "import");
        urlDir = urlDir.isEmpty() ? URIUtil.encodePath((String)dirImport) : apoc.util.FileUtils.changeFileUrlIfImportDirectoryConstrained((String)URIUtil.encodePath((String)urlDir));
        boolean isRecursive = Util.toBoolean((Object)config.getOrDefault("recursive", true));
        Collection files = FileUtils.listFiles((File)Paths.get(URI.create(urlDir).getPath(), new String[0]).toFile(), (IOFileFilter)new WildcardFileFilter(pattern), (IOFileFilter)(isRecursive ? TrueFileFilter.TRUE : FileFileFilter.INSTANCE));
        return files.stream().map(i -> {
            String urlFile = i.toString();
            return new StringResult(apoc.util.FileUtils.isImportUsingNeo4jConfig() ? StringUtils.replaceOnce((String)urlFile, (String)(dirImport + File.separator), (String)"") : urlFile);
        });
    }
}

