/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase.document;

import apoc.couchbase.document.CouchbaseDocument;
import apoc.couchbase.document.CouchbaseUtils;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.java.kv.GetResult;
import java.time.Instant;
import java.util.Map;

public abstract class CouchbaseObjectDocument<T>
implements CouchbaseDocument<T> {
    public String id;
    public long expiry;
    public long cas;
    public Map<String, Object> mutationToken;

    public CouchbaseObjectDocument(GetResult getResult, String id, MutationToken mutationToken) {
        this.id = id;
        this.expiry = getResult.expiryTime().orElse(Instant.ofEpochMilli(0L)).toEpochMilli();
        this.cas = getResult.cas();
        this.mutationToken = CouchbaseUtils.convertMutationTokenToMap(mutationToken);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCas() {
        return this.cas;
    }

    @Override
    public long getExpiry() {
        return this.expiry;
    }

    @Override
    public Map<String, Object> getMutationToken() {
        return this.mutationToken;
    }
}

