/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.ApocConfig;
import apoc.couchbase.CouchbaseConnection;
import com.couchbase.client.core.env.IoEnvironment;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.neo4j.internal.helpers.collection.Pair;
import org.parboiled.common.StringUtils;

public class CouchbaseManager {
    protected static final String COUCHBASE_CONFIG_KEY = "couchbase.";
    protected static final String USERNAME_CONFIG_KEY = "username";
    protected static final String PASSWORD_CONFIG_KEY = "password";
    protected static final String URI_CONFIG_KEY = "uri";
    protected static final String PORT_CONFIG_KEY = "port";
    private static final Map<String, Object> DEFAULT_CONFIG;

    protected CouchbaseManager() {
    }

    protected static URI checkAndGetURI(String hostOrKey) {
        URI uri = URI.create(hostOrKey);
        if (!StringUtils.isEmpty((String)uri.getScheme())) {
            String userInfo = uri.getUserInfo();
            if (StringUtils.isEmpty((String)userInfo)) {
                throw new RuntimeException("URI must include credentials otherwise use apoc.couchbase.<key>.* configuration");
            }
            String[] infoTokens = userInfo.split(":");
            if (infoTokens.length != 2) {
                throw new RuntimeException("Credentials must be defined according URI specifications");
            }
            return uri;
        }
        return null;
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromConfigurationKey(String configurationKey) {
        String password;
        Configuration couchbaseConfig = CouchbaseManager.getKeyMap(configurationKey);
        String username = couchbaseConfig.getString(USERNAME_CONFIG_KEY);
        if (username == null || (password = couchbaseConfig.getString(PASSWORD_CONFIG_KEY)) == null) {
            throw new RuntimeException("Please check you 'apoc.couchbase." + configurationKey + "' configuration, username and password are missing");
        }
        String url = couchbaseConfig.getString(URI_CONFIG_KEY);
        if (url == null) {
            throw new RuntimeException("Please check you 'apoc.couchbase." + configurationKey + "' configuration, url is missing");
        }
        return Pair.of((Object)PasswordAuthenticator.create((String)username.toString(), (String)password.toString()), Arrays.asList(url.toString().split(",")));
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromHost(URI host) {
        List<Object> nodes = Collections.emptyList();
        try {
            nodes = Arrays.asList(new URI(host.getScheme(), null, host.getHost(), host.getPort(), null, null, null).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String[] credentials = host.getUserInfo().split(":");
        return Pair.of((Object)PasswordAuthenticator.create((String)credentials[0], (String)credentials[1]), nodes);
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromHostOrKey(String hostOrKey) {
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            return CouchbaseManager.getConnectionObjectsFromConfigurationKey(hostOrKey);
        }
        return CouchbaseManager.getConnectionObjectsFromHost(singleHostURI);
    }

    public static CouchbaseConnection getConnection(String hostOrKey, String bucketName) {
        PasswordAuthenticator passwordAuthenticator = CouchbaseManager.getPasswordAuthenticator(hostOrKey);
        ClusterEnvironment env = CouchbaseManager.getEnv();
        return new CouchbaseConnection(hostOrKey, passwordAuthenticator, bucketName, env);
    }

    private static ClusterEnvironment getEnv() {
        ClusterEnvironment.Builder builder = ClusterEnvironment.builder();
        builder.timeoutConfig(TimeoutConfig.kvTimeout((Duration)Duration.ofMillis(Integer.parseInt(CouchbaseManager.getConfig("kvTimeout")))));
        builder.timeoutConfig(TimeoutConfig.connectTimeout((Duration)Duration.ofMillis(Long.parseLong(CouchbaseManager.getConfig("connectTimeout")))));
        builder.ioEnvironment(IoEnvironment.builder().eventLoopThreadCount(Integer.parseInt(CouchbaseManager.getConfig("ioPoolSize"))));
        return builder.build();
    }

    private static PasswordAuthenticator getPasswordAuthenticator(String hostOrKey) {
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            String password;
            Configuration couchbaseConfig = CouchbaseManager.getKeyMap(hostOrKey);
            String username = couchbaseConfig.getString(USERNAME_CONFIG_KEY);
            if (username == null || (password = couchbaseConfig.getString(PASSWORD_CONFIG_KEY)) == null) {
                throw new RuntimeException("Please check you 'apoc.couchbase." + hostOrKey + "' configuration, username and password are missing");
            }
            return PasswordAuthenticator.create((String)username.toString(), (String)password.toString());
        }
        String[] userInfo = singleHostURI.getUserInfo().split(":");
        return PasswordAuthenticator.create((String)userInfo[0], (String)userInfo[1]);
    }

    protected static Configuration getKeyMap(String hostOrKey) {
        Configuration couchbaseConfig = ApocConfig.apocConfig().getConfig().subset("apoc.couchbase." + hostOrKey);
        if (couchbaseConfig.isEmpty()) {
            throw new RuntimeException("Please check apoc.conf file 'apoc.couchbase." + hostOrKey + "' is missing");
        }
        return couchbaseConfig;
    }

    public static String getConfig(String key) {
        return ApocConfig.apocConfig().getString("apoc.couchbase." + key, DEFAULT_CONFIG.get(key).toString());
    }

    static {
        HashMap<String, Number> cfg = new HashMap<String, Number>();
        cfg.put("connectTimeout", 5000L);
        cfg.put("kvTimeout", 2500);
        cfg.put("ioPoolSize", 3);
        DEFAULT_CONFIG = Collections.unmodifiableMap(cfg);
    }
}

