/*
 * Decompiled with CFR 0.152.
 */
package apoc.ttl;

import apoc.ApocConfig;
import apoc.util.Util;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class TTLLifeCycle
extends LifecycleAdapter {
    public static final int INITIAL_DELAY = 30;
    public static final int DEFAULT_SCHEDULE = 60;
    private static final Group TTL_GROUP = Group.INDEX_UPDATING;
    private final JobScheduler scheduler;
    private final GraphDatabaseAPI db;
    private final ApocConfig apocConfig;
    private JobHandle ttlIndexJobHandle;
    private JobHandle ttlJobHandle;
    private Log log;

    public TTLLifeCycle(JobScheduler scheduler, GraphDatabaseAPI db, ApocConfig apocConfig, Log log) {
        this.scheduler = scheduler;
        this.db = db;
        this.apocConfig = apocConfig;
        this.log = log;
    }

    public void start() {
        boolean enabled = this.apocConfig.getBoolean("apoc.ttl.enabled");
        if (enabled) {
            long ttlSchedule = this.apocConfig.getInt("apoc.ttl.schedule", 60);
            this.ttlIndexJobHandle = this.scheduler.schedule(TTL_GROUP, this::createTTLIndex, (long)((int)((double)ttlSchedule * 0.8)), TimeUnit.SECONDS);
            long limit = this.apocConfig.getInt("apoc.ttl.limit", 1000);
            this.ttlJobHandle = this.scheduler.scheduleRecurring(TTL_GROUP, () -> this.expireNodes(limit), ttlSchedule, ttlSchedule, TimeUnit.SECONDS);
        }
    }

    public void expireNodes(long limit) {
        try {
            if (!Util.isWriteableInstance((GraphDatabaseAPI)this.db)) {
                return;
            }
            this.db.executeTransactionally("MATCH (t:TTL) where t.ttl < timestamp() WITH t LIMIT $limit DETACH DELETE t", Util.map((Object[])new Object[]{"limit", limit}), result -> {
                QueryStatistics stats = result.getQueryStatistics();
                if (stats.getNodesDeleted() > 0) {
                    this.log.info("TTL: Expired %d nodes %d relationships", new Object[]{stats.getNodesDeleted(), stats.getRelationshipsDeleted()});
                }
                return null;
            });
        }
        catch (Exception e) {
            this.log.error("TTL: Error deleting expired nodes", (Throwable)e);
        }
    }

    public void createTTLIndex() {
        try {
            this.db.executeTransactionally("call apoc.schema.assert({ TTL: ['ttl'] }, null, false)");
        }
        catch (Exception e) {
            this.log.error("TTL: Error creating index", (Throwable)e);
        }
    }

    public void stop() {
        if (this.ttlIndexJobHandle != null) {
            this.ttlIndexJobHandle.cancel();
        }
        if (this.ttlJobHandle != null) {
            this.ttlJobHandle.cancel();
        }
    }
}

