/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class SystemDb {
    @Context
    public ApocConfig apocConfig;
    @Context
    public SecurityContext securityContext;
    @Context
    public ProcedureCallContext callContext;

    @Procedure
    public Stream<NodesAndRelationshipsResult> graph() {
        Util.checkAdmin((SecurityContext)this.securityContext, (ProcedureCallContext)this.callContext, (String)"apoc.systemdb.graph");
        return this.withSystemDbTransaction(tx -> {
            HashMap<Long, VirtualNode> virtualNodes = new HashMap<Long, VirtualNode>();
            for (Node node : tx.getAllNodes()) {
                virtualNodes.put(-node.getId(), new VirtualNode(-node.getId(), (Label[])Iterables.asArray(Label.class, (Iterable)node.getLabels()), node.getAllProperties()));
            }
            List<Relationship> relationships = tx.getAllRelationships().stream().map(rel -> new VirtualRelationship(-rel.getId(), (Node)virtualNodes.get(-rel.getStartNodeId()), (Node)virtualNodes.get(-rel.getEndNodeId()), rel.getType(), rel.getAllProperties())).collect(Collectors.toList());
            return Stream.of(new NodesAndRelationshipsResult(Iterables.asList(virtualNodes.values()), relationships));
        });
    }

    @Procedure
    public Stream<RowResult> execute(@Name(value="DDL command") String command, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        Util.checkAdmin((SecurityContext)this.securityContext, (ProcedureCallContext)this.callContext, (String)"apoc.systemdb.execute");
        return this.withSystemDbTransaction(tx -> tx.execute(command, params).stream().map(map -> new RowResult(map)));
    }

    private <T> T withSystemDbTransaction(Function<Transaction, T> function) {
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            T result = function.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public static class NodesAndRelationshipsResult {
        public List<Node> nodes;
        public List<Relationship> relationships;

        public NodesAndRelationshipsResult(List<Node> nodes, List<Relationship> relationships) {
            this.nodes = nodes;
            this.relationships = relationships;
        }
    }
}

