/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.azure;

import apoc.nlp.NLPHelperFunctions;
import apoc.nlp.azure.AzureClient;
import apoc.nlp.azure.AzureVirtualEntitiesGraph;
import apoc.nlp.azure.AzureVirtualKeyPhrasesGraph;
import apoc.nlp.azure.AzureVirtualSentimentVirtualGraph;
import apoc.nlp.azure.DummyAzureClient;
import apoc.nlp.azure.RealAzureClient;
import apoc.result.NodeWithMapResult;
import apoc.result.VirtualGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0002J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapoc/nlp/azure/AzureProcedures;", "", "()V", "log", "Lorg/neo4j/logging/Log;", "tx", "Lorg/neo4j/graphdb/Transaction;", "azureClient", "Lapoc/nlp/azure/AzureClient;", "config", "", "", "entities", "Ljava/util/stream/Stream;", "Lapoc/result/NodeWithMapResult;", "source", "entitiesGraph", "Lapoc/result/VirtualGraph;", "keyPhrases", "keyPhrasesGraph", "sentiment", "sentimentGraph", "Companion", "apoc"})
public final class AzureProcedures {
    @Context
    @JvmField
    @Nullable
    public Log log;
    @Context
    @JvmField
    @Nullable
    public Transaction tx;
    @NotNull
    private static final List<String> CONFIG_PROPS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.azure.sentiment.stream", mode=Mode.READ)
    @Description(value="Provides a sentiment analysis for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> sentiment(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        String[] stringArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        Collection collection = CONFIG_PROPS;
        Object object = config;
        Object object2 = NLPHelperFunctions.INSTANCE;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        ((NLPHelperFunctions)object2).verifyKeys((Map<String, ? extends Object>)object, Arrays.copyOf(stringArray3, stringArray3.length));
        AzureClient client = this.azureClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv;
            int n3 = n2;
            object2 = collection2;
            boolean bl2 = false;
            object = client.sentiment((List<? extends Node>)batch, (int)index);
            object2.add(object);
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(new Function<T, Stream<? extends R>>(convertedSource){
            final /* synthetic */ List $convertedSource;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Stream<NodeWithMapResult> apply(List<? extends Map<String, ? extends Object>> result) {
                void $this$mapTo$iv$iv;
                List<? extends Map<String, ? extends Object>> list = result;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"result");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map map = (Map)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    NodeWithMapResult nodeWithMapResult = RealAzureClient.Companion.responseToNodeWithMapResult((Map<String, ? extends Object>)it, this.$convertedSource);
                    collection.add(nodeWithMapResult);
                }
                return ((List)destination$iv$iv).stream();
            }
            {
                this.$convertedSource = list;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed {inde\u2026ertedSource) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.azure.sentiment.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) sentiment graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> sentimentGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AzureVirtualSentimentVirtualGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        Iterable $this$mapIndexedTo$iv$iv;
        String[] stringArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty((Map<String, ? extends Object>)config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        Collection collection2 = CONFIG_PROPS;
        Object object = config;
        Object object2 = NLPHelperFunctions.INSTANCE;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        ((NLPHelperFunctions)object2).verifyKeys((Map<String, ? extends Object>)object, Arrays.copyOf(stringArray3, stringArray3.length));
        AzureClient client = this.azureClient((Map<String, ? extends Object>)config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.keyPhraseRelationshipType((Map<String, ? extends Object>)config);
        Object object3 = config.getOrDefault("write", false);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object3;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv2;
            int n3 = n2;
            object2 = collection;
            boolean bl2 = false;
            object = new Pair((Object)batch, client.sentiment((List<? extends Node>)batch, (int)index));
            object2.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            collection = (List)$dstr$batch$result.component1();
            List result = (List)$dstr$batch$result.component2();
            object = new AzureVirtualSentimentVirtualGraph(result, (List<? extends Node>)batch);
            object2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AzureVirtualSentimentVirtualGraph)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            object2.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"NLPHelperFunctions.parti\u2026                .stream()");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.azure.entities.stream", mode=Mode.READ)
    @Description(value="Provides a entity analysis for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> entities(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        String[] stringArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        Collection collection = CONFIG_PROPS;
        Object object = config;
        Object object2 = NLPHelperFunctions.INSTANCE;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        ((NLPHelperFunctions)object2).verifyKeys((Map<String, ? extends Object>)object, Arrays.copyOf(stringArray3, stringArray3.length));
        AzureClient client = this.azureClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv;
            int n3 = n2;
            object2 = collection2;
            boolean bl2 = false;
            object = client.entities((List<? extends Node>)batch, (int)index);
            object2.add(object);
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(new Function<T, Stream<? extends R>>(convertedSource){
            final /* synthetic */ List $convertedSource;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Stream<NodeWithMapResult> apply(List<? extends Map<String, ? extends Object>> result) {
                void $this$mapTo$iv$iv;
                List<? extends Map<String, ? extends Object>> list = result;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"result");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map map = (Map)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    NodeWithMapResult nodeWithMapResult = RealAzureClient.Companion.responseToNodeWithMapResult((Map<String, ? extends Object>)it, this.$convertedSource);
                    collection.add(nodeWithMapResult);
                }
                return ((List)destination$iv$iv).stream();
            }
            {
                this.$convertedSource = list;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed {inde\u2026ertedSource) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.azure.entities.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) entity graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> entitiesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AzureVirtualEntitiesGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        Iterable $this$mapIndexedTo$iv$iv;
        String[] stringArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty((Map<String, ? extends Object>)config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        Collection collection2 = CONFIG_PROPS;
        Object object = config;
        Object object2 = NLPHelperFunctions.INSTANCE;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        ((NLPHelperFunctions)object2).verifyKeys((Map<String, ? extends Object>)object, Arrays.copyOf(stringArray3, stringArray3.length));
        AzureClient client = this.azureClient((Map<String, ? extends Object>)config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.entityRelationshipType((Map<String, ? extends Object>)config);
        Object object3 = config.getOrDefault("writeRelationshipProperty", (Object)"score");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String relationshipProperty = (String)object3;
        Object object4 = config.getOrDefault("write", false);
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object4;
        Object object5 = config.getOrDefault("scoreCutoff", 0.0);
        if (object5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
        }
        Number scoreCutoff = (Number)object5;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv2;
            int n3 = n2;
            object2 = collection;
            boolean bl2 = false;
            object = new Pair((Object)batch, client.entities((List<? extends Node>)batch, (int)index));
            object2.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            collection = (List)$dstr$batch$result.component1();
            List result = (List)$dstr$batch$result.component2();
            object = new AzureVirtualEntitiesGraph(result, (List<? extends Node>)batch, relationshipType, relationshipProperty, scoreCutoff);
            object2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AzureVirtualEntitiesGraph)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            object2.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"NLPHelperFunctions.parti\u2026                .stream()");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.azure.keyPhrases.stream", mode=Mode.READ)
    @Description(value="Provides a entity analysis for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> keyPhrases(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        String[] stringArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        Collection collection = CONFIG_PROPS;
        Object object = config;
        Object object2 = NLPHelperFunctions.INSTANCE;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        ((NLPHelperFunctions)object2).verifyKeys((Map<String, ? extends Object>)object, Arrays.copyOf(stringArray3, stringArray3.length));
        AzureClient client = this.azureClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv;
            int n3 = n2;
            object2 = collection2;
            boolean bl2 = false;
            object = client.keyPhrases((List<? extends Node>)batch, (int)index);
            object2.add(object);
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(new Function<T, Stream<? extends R>>(convertedSource){
            final /* synthetic */ List $convertedSource;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Stream<NodeWithMapResult> apply(List<? extends Map<String, ? extends Object>> result) {
                void $this$mapTo$iv$iv;
                List<? extends Map<String, ? extends Object>> list = result;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"result");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map map = (Map)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    NodeWithMapResult nodeWithMapResult = RealAzureClient.Companion.responseToNodeWithMapResult((Map<String, ? extends Object>)it, this.$convertedSource);
                    collection.add(nodeWithMapResult);
                }
                return ((List)destination$iv$iv).stream();
            }
            {
                this.$convertedSource = list;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed { ind\u2026ertedSource) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.azure.keyPhrases.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) key phrase graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> keyPhrasesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AzureVirtualKeyPhrasesGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        Iterable $this$mapIndexedTo$iv$iv;
        String[] stringArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty((Map<String, ? extends Object>)config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        Collection collection2 = CONFIG_PROPS;
        Object object = config;
        Object object2 = NLPHelperFunctions.INSTANCE;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        ((NLPHelperFunctions)object2).verifyKeys((Map<String, ? extends Object>)object, Arrays.copyOf(stringArray3, stringArray3.length));
        AzureClient client = this.azureClient((Map<String, ? extends Object>)config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.keyPhraseRelationshipType((Map<String, ? extends Object>)config);
        Object object3 = config.getOrDefault("write", false);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object3;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv2;
            int n3 = n2;
            object2 = collection;
            boolean bl2 = false;
            object = new Pair((Object)batch, client.keyPhrases((List<? extends Node>)batch, (int)index));
            object2.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            collection = (List)$dstr$batch$result.component1();
            List result = (List)$dstr$batch$result.component2();
            object = new AzureVirtualKeyPhrasesGraph(result, (List<? extends Node>)batch, relationshipType);
            object2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AzureVirtualKeyPhrasesGraph)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            object2.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"NLPHelperFunctions.parti\u2026                .stream()");
        return stream;
    }

    private final AzureClient azureClient(Map<String, ? extends Object> config) {
        AzureClient azureClient;
        Object object = config.getOrDefault("unsupportedDummyClient", (Object)false);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean useDummyClient = (Boolean)object;
        if (useDummyClient) {
            Log log = this.log;
            if (log == null) {
                Intrinsics.throwNpe();
            }
            azureClient = new DummyAzureClient(config, log);
        } else {
            String string = MapsKt.getValue(config, (Object)"url").toString();
            String string2 = MapsKt.getValue(config, (Object)"key").toString();
            Log log = this.log;
            if (log == null) {
                Intrinsics.throwNpe();
            }
            azureClient = new RealAzureClient(string, string2, log, config);
        }
        return azureClient;
    }

    static {
        Companion = new Companion(null);
        CONFIG_PROPS = CollectionsKt.listOf((Object[])new String[]{"key", "url"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapoc/nlp/azure/AzureProcedures$Companion;", "", "()V", "CONFIG_PROPS", "", "", "getCONFIG_PROPS", "()Ljava/util/List;", "apoc"})
    public static final class Companion {
        @NotNull
        public final List<String> getCONFIG_PROPS() {
            return CONFIG_PROPS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

