/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Extended;
import apoc.result.MapResult;
import apoc.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadHtml {
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Procedure
    @Description(value="apoc.load.html('url',{name: jquery, name2: jquery}, config) YIELD value - Load Html page and return the result as a Map")
    public Stream<MapResult> html(@Name(value="url") String url, @Name(value="query", defaultValue="{}") Map<String, String> query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.readHtmlPage(url, query, config);
    }

    private Stream<MapResult> readHtmlPage(String url, Map<String, String> query, Map<String, Object> config) {
        try {
            String charset = config.getOrDefault("charset", "UTF-8").toString();
            String baseUri = config.getOrDefault("baseUri", "").toString();
            Document document = Jsoup.parse((InputStream)Util.openInputStream((String)url, null, null), (String)charset, (String)baseUri);
            HashMap output = new HashMap();
            query.keySet().stream().forEach(key -> {
                Elements elements = document.select((String)query.get(key));
                output.put(key, this.getElements(elements, config));
            });
            return Stream.of(new MapResult(output));
        }
        catch (Exception e) {
            throw new RuntimeException("Can't read the HTML from: " + url);
        }
    }

    private List<Map<String, Object>> getElements(Elements elements, Map<String, Object> config) {
        ArrayList<Map<String, Object>> elementList = new ArrayList<Map<String, Object>>();
        for (Element element : elements) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (element.attributes().size() > 0) {
                result.put("attributes", this.getAttributes(element));
            }
            if (!element.data().isEmpty()) {
                result.put("data", element.data());
            }
            if (!element.val().isEmpty()) {
                result.put("value", element.val());
            }
            if (!element.tagName().isEmpty()) {
                result.put("tagName", element.tagName());
            }
            if (Util.toBoolean((Object)config.getOrDefault("children", false))) {
                if (element.hasText()) {
                    result.put("text", element.ownText());
                }
                result.put("children", this.getElements(element.children(), config));
            } else if (element.hasText()) {
                result.put("text", element.text());
            }
            elementList.add(result);
        }
        return elementList;
    }

    private Map<String, String> getAttributes(Element element) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute attribute : element.attributes()) {
            if (attribute.getValue().isEmpty()) continue;
            attributes.put(attribute.getKey(), attribute.getValue());
        }
        return attributes;
    }
}

