/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.ApocConfig;
import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.custom.Signatures;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public class CypherProceduresHandler
extends LifecycleAdapter
implements AvailabilityListener {
    public static final String PREFIX = "custom";
    public static final String FUNCTION = "function";
    public static final String PROCEDURE = "procedure";
    public static final String CUSTOM_PROCEDURES_REFRESH = "apoc.custom.procedures.refresh";
    public static final List<FieldSignature> DEFAULT_INPUTS = Collections.singletonList(FieldSignature.inputField((String)"params", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.ntMap(Collections.emptyMap())));
    public static final List<FieldSignature> DEFAULT_MAP_OUTPUT = Collections.singletonList(FieldSignature.inputField((String)"row", (Neo4jTypes.AnyType)Neo4jTypes.NTMap));
    private final GraphDatabaseAPI api;
    private final Log log;
    private final GraphDatabaseService systemDb;
    private final GlobalProcedures globalProceduresRegistry;
    private final JobScheduler jobScheduler;
    private long lastUpdate;
    private final ThrowingFunction<Context, Transaction, ProcedureException> transactionComponentFunction;
    private Set<ProcedureSignature> registeredProcedureSignatures = Collections.emptySet();
    private Set<UserFunctionSignature> registeredUserFunctionSignatures = Collections.emptySet();
    private static Group REFRESH_GROUP = Group.STORAGE_MAINTENANCE;
    private JobHandle restoreProceduresHandle;

    public CypherProceduresHandler(GraphDatabaseAPI db, JobScheduler jobScheduler, ApocConfig apocConfig, Log userLog, GlobalProcedures globalProceduresRegistry) {
        this.api = db;
        this.log = userLog;
        this.jobScheduler = jobScheduler;
        this.systemDb = apocConfig.getSystemDb();
        this.globalProceduresRegistry = globalProceduresRegistry;
        this.transactionComponentFunction = globalProceduresRegistry.lookupComponentProvider(Transaction.class, true);
    }

    public void available() {
        this.restoreProceduresAndFunctions();
        long refreshInterval = ApocConfig.apocConfig().getInt(CUSTOM_PROCEDURES_REFRESH, 60000);
        this.restoreProceduresHandle = this.jobScheduler.scheduleRecurring(REFRESH_GROUP, () -> {
            if (this.getLastUpdate() > this.lastUpdate) {
                this.restoreProceduresAndFunctions();
            }
        }, refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
    }

    public void unavailable() {
        if (this.restoreProceduresHandle != null) {
            this.restoreProceduresHandle.cancel();
        }
    }

    public Mode mode(String s) {
        return s == null ? Mode.READ : Mode.valueOf((String)s.toUpperCase());
    }

    public Stream<ProcedureOrFunctionDescriptor> readSignatures() {
        List descriptors;
        try (Transaction tx = this.systemDb.beginTx();){
            descriptors = tx.findNodes((Label)SystemLabels.ApocCypherProcedures, SystemPropertyKeys.database.name(), (Object)this.api.databaseName()).stream().map(node -> {
                if (node.hasLabel((Label)SystemLabels.Procedure)) {
                    return this.procedureDescriptor((Node)node);
                }
                if (node.hasLabel((Label)SystemLabels.Function)) {
                    return this.userFunctionDescriptor((Node)node);
                }
                throw new IllegalStateException("don't know what to do with systemdb node " + node);
            }).collect(Collectors.toList());
            tx.commit();
        }
        return descriptors.stream();
    }

    private ProcedureDescriptor procedureDescriptor(Node node) {
        String statement = (String)node.getProperty(SystemPropertyKeys.statement.name());
        String name = (String)node.getProperty(SystemPropertyKeys.name.name());
        String description = (String)node.getProperty(SystemPropertyKeys.description.name(), null);
        String property = (String)node.getProperty(SystemPropertyKeys.inputs.name());
        List<FieldSignature> inputs = this.deserializeSignatures(property);
        List<FieldSignature> outputSignature = this.deserializeSignatures((String)node.getProperty(SystemPropertyKeys.outputs.name()));
        return new ProcedureDescriptor(Signatures.createProcedureSignature(new QualifiedName(new String[]{PREFIX}, name), inputs, outputSignature, Mode.valueOf((String)((String)node.getProperty(SystemPropertyKeys.mode.name()))), false, null, new String[0], description, null, false, false, false, false), statement);
    }

    private UserFunctionDescriptor userFunctionDescriptor(Node node) {
        String statement = (String)node.getProperty(SystemPropertyKeys.statement.name());
        String name = (String)node.getProperty(SystemPropertyKeys.name.name());
        String description = (String)node.getProperty(SystemPropertyKeys.description.name(), null);
        String property = (String)node.getProperty(SystemPropertyKeys.inputs.name());
        List<FieldSignature> inputs = this.deserializeSignatures(property);
        boolean forceSingle = (Boolean)node.getProperty(SystemPropertyKeys.forceSingle.name(), (Object)false);
        return new UserFunctionDescriptor(new UserFunctionSignature(new QualifiedName(new String[]{PREFIX}, name), inputs, this.typeof((String)node.getProperty(SystemPropertyKeys.output.name())), null, new String[0], description, "apoc.custom", false), statement, forceSingle);
    }

    public void restoreProceduresAndFunctions() {
        this.lastUpdate = System.currentTimeMillis();
        Set currentProcedureSignatures = Collections.synchronizedSet(new HashSet());
        Set currentUserFunctionSignatures = Collections.synchronizedSet(new HashSet());
        this.readSignatures().forEach(descriptor -> {
            descriptor.register();
            if (descriptor instanceof ProcedureDescriptor) {
                ProcedureSignature signature = ((ProcedureDescriptor)descriptor).getSignature();
                currentProcedureSignatures.add(signature);
                this.registeredProcedureSignatures.remove(signature);
            } else {
                UserFunctionSignature signature = ((UserFunctionDescriptor)descriptor).getSignature();
                currentUserFunctionSignatures.add(signature);
                this.registeredUserFunctionSignatures.remove(signature);
            }
        });
        this.registeredProcedureSignatures.forEach(signature -> this.registerProcedure((ProcedureSignature)signature, null));
        this.registeredUserFunctionSignatures.forEach(signature -> this.registerFunction((UserFunctionSignature)signature, null, false));
        this.registeredProcedureSignatures = currentProcedureSignatures;
        this.registeredUserFunctionSignatures = currentUserFunctionSignatures;
        this.api.executeTransactionally("call db.clearQueryCaches()");
    }

    private <T> T withSystemDb(Function<Transaction, T> action) {
        try (Transaction tx = this.systemDb.beginTx();){
            T result = action.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public void storeFunction(UserFunctionSignature signature, String statement, boolean forceSingle) {
        this.withSystemDb(tx -> {
            Node node = Util.mergeNode((Transaction)tx, (Label)SystemLabels.ApocCypherProcedures, (Label)SystemLabels.Function, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.api.databaseName()), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)signature.name().name())});
            node.setProperty(SystemPropertyKeys.description.name(), signature.description().orElse(null));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(SystemPropertyKeys.inputs.name(), (Object)this.serializeSignatures(signature.inputSignature()));
            node.setProperty(SystemPropertyKeys.output.name(), (Object)signature.outputType().toString());
            node.setProperty(SystemPropertyKeys.forceSingle.name(), (Object)forceSingle);
            this.setLastUpdate((Transaction)tx);
            this.registerFunction(signature, statement, forceSingle);
            return null;
        });
    }

    public void storeProcedure(ProcedureSignature signature, String statement) {
        this.withSystemDb(tx -> {
            Node node = Util.mergeNode((Transaction)tx, (Label)SystemLabels.ApocCypherProcedures, (Label)SystemLabels.Procedure, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.api.databaseName()), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)signature.name().name())});
            node.setProperty(SystemPropertyKeys.description.name(), signature.description().orElse(null));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(SystemPropertyKeys.inputs.name(), (Object)this.serializeSignatures(signature.inputSignature()));
            node.setProperty(SystemPropertyKeys.outputs.name(), (Object)this.serializeSignatures(signature.outputSignature()));
            node.setProperty(SystemPropertyKeys.mode.name(), (Object)signature.mode().name());
            this.setLastUpdate((Transaction)tx);
            this.registerProcedure(signature, statement);
            return null;
        });
    }

    private String serializeSignatures(List<FieldSignature> signatures) {
        List mapped = signatures.stream().map(fs -> MapUtil.map((Object[])new Object[]{"name", fs.name(), "type", fs.neo4jType().toString(), "default", fs.defaultValue().orElse(DefaultParameterValue.nullValue((Neo4jTypes.AnyType)new Neo4jTypes.AnyType())).value()})).collect(Collectors.toList());
        return Util.toJson(mapped);
    }

    private List<FieldSignature> deserializeSignatures(String s) {
        List mapped = (List)Util.fromJson((String)s, List.class);
        return mapped.stream().map(map -> {
            String typeString = (String)map.get("type");
            if (typeString.endsWith("?")) {
                typeString = typeString.substring(0, typeString.length() - 1);
            }
            Neo4jTypes.AnyType type = this.typeof(typeString);
            Object deflt = map.get("default");
            if (deflt == null) {
                return FieldSignature.inputField((String)((String)map.get("name")), (Neo4jTypes.AnyType)type);
            }
            return FieldSignature.inputField((String)((String)map.get("name")), (Neo4jTypes.AnyType)type, (DefaultParameterValue)new DefaultParameterValue(deflt, type));
        }).collect(Collectors.toList());
    }

    private void setLastUpdate(Transaction tx) {
        Node node = tx.findNode((Label)SystemLabels.ApocCypherProceduresMeta, SystemPropertyKeys.database.name(), (Object)this.api.databaseName());
        if (node == null) {
            node = tx.createNode(new Label[]{SystemLabels.ApocCypherProceduresMeta});
            node.setProperty(SystemPropertyKeys.database.name(), (Object)this.api.databaseName());
        }
        node.setProperty(SystemPropertyKeys.lastUpdated.name(), (Object)System.currentTimeMillis());
    }

    private long getLastUpdate() {
        return this.withSystemDb(tx -> {
            Node node = tx.findNode((Label)SystemLabels.ApocCypherProceduresMeta, SystemPropertyKeys.database.name(), (Object)this.api.databaseName());
            return node == null ? 0L : (Long)node.getProperty(SystemPropertyKeys.lastUpdated.name());
        });
    }

    public ProcedureSignature procedureSignature(String name, String mode, List<List<String>> outputs, List<List<String>> inputs, String description) {
        boolean admin = false;
        return new ProcedureSignature(CypherProceduresHandler.qualifiedName(name), this.inputSignatures(inputs), this.outputSignatures(outputs), Mode.valueOf((String)mode.toUpperCase()), admin, null, new String[0], description, null, false, false, true, false);
    }

    public UserFunctionSignature functionSignature(String name, String output, List<List<String>> inputs, String description) {
        Neo4jTypes.AnyType outType = this.typeof(output.isEmpty() ? "LIST OF MAP" : output);
        return new UserFunctionSignature(CypherProceduresHandler.qualifiedName(name), this.inputSignatures(inputs), outType, null, new String[0], description, "apoc.custom", false);
    }

    public boolean registerProcedure(final ProcedureSignature signature, final String statement) {
        try {
            this.globalProceduresRegistry.register((CallableProcedure)new CallableProcedure.BasicProcedure(signature){

                public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
                    if (statement == null) {
                        String error = String.format("There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", signature.name());
                        throw new QueryExecutionException(error, null, "Neo.ClientError.Statement.SyntaxError");
                    }
                    Map<String, Object> params = CypherProceduresHandler.this.params(input, signature.inputSignature(), ctx.valueMapper());
                    Transaction tx = (Transaction)CypherProceduresHandler.this.transactionComponentFunction.apply((Object)ctx);
                    Result result = tx.execute(statement, params);
                    resourceTracker.registerCloseableResource((AutoCloseable)result);
                    List outputs = signature.outputSignature();
                    String[] names = outputs == null ? null : (String[])outputs.stream().map(FieldSignature::name).toArray(String[]::new);
                    boolean defaultOutputs = outputs == null || outputs.equals(DEFAULT_MAP_OUTPUT);
                    Stream<AnyValue[]> stream = result.stream().map(row -> CypherProceduresHandler.this.toResult((Map<String, Object>)row, names, defaultOutputs));
                    return Iterators.asRawIterator(stream);
                }
            }, true);
            this.registeredProcedureSignatures.add(signature);
            return true;
        }
        catch (Exception e) {
            this.log.error("Could not register procedure: " + signature.name() + " with " + statement + "\n accepting" + signature.inputSignature() + " resulting in " + signature.outputSignature() + " mode " + signature.mode(), (Throwable)e);
            return false;
        }
    }

    public boolean registerFunction(final UserFunctionSignature signature, final String statement, final boolean forceSingle) {
        try {
            this.globalProceduresRegistry.register((CallableUserFunction)new CallableUserFunction.BasicUserFunction(signature){

                public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
                    if (statement == null) {
                        String error = String.format("Unknown function '%s'", signature.name());
                        throw new QueryExecutionException(error, null, "Neo.ClientError.Statement.SyntaxError");
                    }
                    Map<String, Object> params = CypherProceduresHandler.this.params(input, signature.inputSignature(), ctx.valueMapper());
                    Neo4jTypes.AnyType outType = signature.outputType();
                    Transaction tx = (Transaction)CypherProceduresHandler.this.transactionComponentFunction.apply((Object)ctx);
                    try (Result result = tx.execute(statement, params);){
                        if (!result.hasNext()) {
                            AnyValue anyValue = null;
                            return anyValue;
                        }
                        if (outType.equals(Neo4jTypes.NTAny)) {
                            AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                            return anyValue;
                        }
                        List cols = result.columns();
                        if (cols.isEmpty()) {
                            AnyValue anyValue = null;
                            return anyValue;
                        }
                        if (!forceSingle && outType instanceof Neo4jTypes.ListType) {
                            Neo4jTypes.ListType listType = (Neo4jTypes.ListType)outType;
                            Neo4jTypes.AnyType innerType = listType.innerType();
                            if (innerType instanceof Neo4jTypes.MapType) {
                                AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                                return anyValue;
                            }
                            if (cols.size() == 1) {
                                AnyValue anyValue = ValueUtils.of(result.stream().map(row -> row.get(cols.get(0))).collect(Collectors.toList()));
                                return anyValue;
                            }
                        } else {
                            Map row2 = result.next();
                            if (outType instanceof Neo4jTypes.MapType) {
                                AnyValue anyValue = ValueUtils.of((Object)row2);
                                return anyValue;
                            }
                            if (cols.size() == 1) {
                                AnyValue anyValue = ValueUtils.of(row2.get(cols.get(0)));
                                return anyValue;
                            }
                        }
                        throw new IllegalStateException("Result mismatch " + cols + " output type is " + outType);
                    }
                }
            }, true);
            this.registeredUserFunctionSignatures.add(signature);
            return true;
        }
        catch (Exception e) {
            this.log.error("Could not register function: " + signature + "\nwith: " + statement + "\n single result " + forceSingle, (Throwable)e);
            return false;
        }
    }

    public static QualifiedName qualifiedName(@Name(value="name") String name) {
        String[] names = name.split("\\.");
        ArrayList<String> namespace = new ArrayList<String>(names.length);
        namespace.add(PREFIX);
        namespace.addAll(Arrays.asList(names));
        return new QualifiedName(namespace.subList(0, namespace.size() - 1), names[names.length - 1]);
    }

    public List<FieldSignature> inputSignatures(@Name(value="inputs", defaultValue="null") List<List<String>> inputs) {
        List<FieldSignature> inputSignature = inputs == null ? Collections.singletonList(FieldSignature.inputField((String)"params", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.ntMap(Collections.emptyMap()))) : inputs.stream().map(pair -> {
            DefaultParameterValue defaultValue = this.defaultValue((String)pair.get(1), pair.size() > 2 ? (String)pair.get(2) : null);
            return defaultValue == null ? FieldSignature.inputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1))) : FieldSignature.inputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1)), (DefaultParameterValue)defaultValue);
        }).collect(Collectors.toList());
        return inputSignature;
    }

    public List<FieldSignature> outputSignatures(@Name(value="outputs", defaultValue="null") List<List<String>> outputs) {
        return outputs == null ? Collections.singletonList(FieldSignature.inputField((String)"row", (Neo4jTypes.AnyType)Neo4jTypes.NTMap)) : outputs.stream().map(pair -> FieldSignature.outputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1)))).collect(Collectors.toList());
    }

    private Neo4jTypes.AnyType typeof(String typeName) {
        typeName = typeName.replaceAll("\\?", "");
        if ((typeName = typeName.toUpperCase()).startsWith("LIST OF ")) {
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.typeof(typeName.substring(8)));
        }
        if (typeName.startsWith("LIST ")) {
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.typeof(typeName.substring(5)));
        }
        switch (typeName) {
            case "ANY": {
                return Neo4jTypes.NTAny;
            }
            case "MAP": {
                return Neo4jTypes.NTMap;
            }
            case "NODE": {
                return Neo4jTypes.NTNode;
            }
            case "REL": {
                return Neo4jTypes.NTRelationship;
            }
            case "RELATIONSHIP": {
                return Neo4jTypes.NTRelationship;
            }
            case "EDGE": {
                return Neo4jTypes.NTRelationship;
            }
            case "PATH": {
                return Neo4jTypes.NTPath;
            }
            case "NUMBER": {
                return Neo4jTypes.NTNumber;
            }
            case "LONG": {
                return Neo4jTypes.NTInteger;
            }
            case "INT": {
                return Neo4jTypes.NTInteger;
            }
            case "INTEGER": {
                return Neo4jTypes.NTInteger;
            }
            case "FLOAT": {
                return Neo4jTypes.NTFloat;
            }
            case "DOUBLE": {
                return Neo4jTypes.NTFloat;
            }
            case "BOOL": {
                return Neo4jTypes.NTBoolean;
            }
            case "BOOLEAN": {
                return Neo4jTypes.NTBoolean;
            }
            case "DATE": {
                return Neo4jTypes.NTDate;
            }
            case "TIME": {
                return Neo4jTypes.NTTime;
            }
            case "LOCALTIME": {
                return Neo4jTypes.NTLocalTime;
            }
            case "DATETIME": {
                return Neo4jTypes.NTDateTime;
            }
            case "LOCALDATETIME": {
                return Neo4jTypes.NTLocalDateTime;
            }
            case "DURATION": {
                return Neo4jTypes.NTDuration;
            }
            case "POINT": {
                return Neo4jTypes.NTPoint;
            }
            case "GEO": {
                return Neo4jTypes.NTGeometry;
            }
            case "GEOMETRY": {
                return Neo4jTypes.NTGeometry;
            }
            case "STRING": {
                return Neo4jTypes.NTString;
            }
            case "TEXT": {
                return Neo4jTypes.NTString;
            }
        }
        return Neo4jTypes.NTString;
    }

    private DefaultParameterValue defaultValue(String typeName, String stringValue) {
        if (stringValue == null) {
            return null;
        }
        Object value = JsonUtil.parse((String)stringValue, null, Object.class);
        if (value == null) {
            return null;
        }
        if ((typeName = typeName.toUpperCase()).startsWith("LIST ")) {
            return DefaultParameterValue.ntList((List)((List)value), (Neo4jTypes.AnyType)this.typeof(typeName.substring(5)));
        }
        switch (typeName) {
            case "MAP": {
                return DefaultParameterValue.ntMap((Map)((Map)value));
            }
            case "NODE": 
            case "REL": 
            case "RELATIONSHIP": 
            case "EDGE": 
            case "PATH": {
                return null;
            }
            case "NUMBER": {
                return value instanceof Float || value instanceof Double ? DefaultParameterValue.ntFloat((double)((Number)value).doubleValue()) : DefaultParameterValue.ntInteger((long)((Number)value).longValue());
            }
            case "LONG": 
            case "INT": 
            case "INTEGER": {
                return DefaultParameterValue.ntInteger((long)((Number)value).longValue());
            }
            case "FLOAT": 
            case "DOUBLE": {
                return DefaultParameterValue.ntFloat((double)((Number)value).doubleValue());
            }
            case "BOOL": 
            case "BOOLEAN": {
                return DefaultParameterValue.ntBoolean((boolean)((Boolean)value));
            }
            case "DATE": 
            case "TIME": 
            case "LOCALTIME": 
            case "DATETIME": 
            case "LOCALDATETIME": 
            case "DURATION": 
            case "POINT": 
            case "GEO": 
            case "GEOMETRY": {
                return null;
            }
            case "STRING": 
            case "TEXT": {
                return DefaultParameterValue.ntString((String)value.toString());
            }
        }
        return null;
    }

    private AnyValue[] toResult(Map<String, Object> row, String[] names, boolean defaultOutputs) {
        if (defaultOutputs) {
            return new AnyValue[]{this.convertToValueRecursive(row)};
        }
        AnyValue[] result = new AnyValue[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.convertToValueRecursive(row.get(names[i]));
        }
        return result;
    }

    private AnyValue convertToValueRecursive(Object ... toConverts) {
        switch (toConverts.length) {
            case 0: {
                return Values.NO_VALUE;
            }
            case 1: {
                Object toConvert = toConverts[0];
                if (toConvert instanceof List) {
                    List list = (List)toConvert;
                    AnyValue[] objects = (AnyValue[])list.stream().map(x -> this.convertToValueRecursive(x)).toArray(AnyValue[]::new);
                    return VirtualValues.list((AnyValue[])objects);
                }
                if (toConvert instanceof Map) {
                    Map map = (Map)toConvert;
                    MapValueBuilder builder = new MapValueBuilder(map.size());
                    map.entrySet().stream().forEach(e -> builder.add((String)e.getKey(), this.convertToValueRecursive(e.getValue())));
                    return builder.build();
                }
                if (toConvert instanceof Entity || toConvert instanceof Path) {
                    return ValueUtils.asAnyValue((Object)toConvert);
                }
                return Values.of((Object)toConvert);
            }
        }
        AnyValue[] values = (AnyValue[])Arrays.stream(toConverts).map(c -> this.convertToValueRecursive(c)).toArray(AnyValue[]::new);
        return VirtualValues.list((AnyValue[])values);
    }

    public Map<String, Object> params(AnyValue[] input, List<FieldSignature> fieldSignatures, ValueMapper valueMapper) {
        if (input == null || input.length == 0) {
            return Collections.emptyMap();
        }
        if (fieldSignatures == null || fieldSignatures.isEmpty() || fieldSignatures.equals(DEFAULT_INPUTS)) {
            return (Map)input[0].map(valueMapper);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(input.length);
        for (int i = 0; i < input.length; ++i) {
            params.put(fieldSignatures.get(i).name(), input[i].map(valueMapper));
        }
        return params;
    }

    public void removeProcedure(String name) {
        this.withSystemDb(tx -> {
            Node node = (Node)Iterators.single(tx.findNodes((Label)SystemLabels.ApocCypherProcedures, SystemPropertyKeys.database.name(), (Object)this.api.databaseName(), SystemPropertyKeys.name.name(), (Object)name).stream().filter(n -> n.hasLabel((Label)SystemLabels.Procedure)).iterator());
            ProcedureDescriptor descriptor = this.procedureDescriptor(node);
            this.registerProcedure(descriptor.getSignature(), null);
            this.registeredProcedureSignatures.remove(descriptor.getSignature());
            node.delete();
            this.setLastUpdate((Transaction)tx);
            return null;
        });
    }

    public void removeFunction(String name) {
        this.withSystemDb(tx -> {
            Node node = (Node)Iterators.single(tx.findNodes((Label)SystemLabels.ApocCypherProcedures, SystemPropertyKeys.database.name(), (Object)this.api.databaseName(), SystemPropertyKeys.name.name(), (Object)name).stream().filter(n -> n.hasLabel((Label)SystemLabels.Function)).iterator());
            UserFunctionDescriptor descriptor = this.userFunctionDescriptor(node);
            this.registerFunction(descriptor.getSignature(), null, false);
            this.registeredUserFunctionSignatures.remove(descriptor.getSignature());
            node.delete();
            this.setLastUpdate((Transaction)tx);
            return null;
        });
    }

    public class UserFunctionDescriptor
    extends ProcedureOrFunctionDescriptor {
        private final UserFunctionSignature signature;
        private final boolean forceSingle;

        public UserFunctionDescriptor(UserFunctionSignature signature, String statement, boolean forceSingle) {
            super(statement);
            this.signature = signature;
            this.forceSingle = forceSingle;
        }

        public UserFunctionSignature getSignature() {
            return this.signature;
        }

        public boolean isForceSingle() {
            return this.forceSingle;
        }

        @Override
        public void register() {
            CypherProceduresHandler.this.registerFunction(this.getSignature(), this.getStatement(), this.isForceSingle());
        }
    }

    public class ProcedureDescriptor
    extends ProcedureOrFunctionDescriptor {
        private final ProcedureSignature signature;

        public ProcedureDescriptor(ProcedureSignature signature, String statement) {
            super(statement);
            this.signature = signature;
        }

        public ProcedureSignature getSignature() {
            return this.signature;
        }

        @Override
        public void register() {
            CypherProceduresHandler.this.registerProcedure(this.getSignature(), this.getStatement());
        }
    }

    public abstract class ProcedureOrFunctionDescriptor {
        private final String statement;

        protected ProcedureOrFunctionDescriptor(String statement) {
            this.statement = statement;
        }

        public String getStatement() {
            return this.statement;
        }

        public abstract void register();
    }
}

