/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.util.StreamConnection;
import apoc.util.s3.S3Params;
import apoc.util.s3.S3URLConnection;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;

public class S3Aws {
    AmazonS3 s3Client;
    private static final List<String> LOCALSTACK_IPS = Arrays.asList("127.0.0.1", "0.0.0.0", "localhost");

    /*
     * Unable to fully structure code
     */
    public S3Aws(S3Params s3Params, String region) {
        super();
        credentialsProvider = S3Aws.getCredentialsProvider(s3Params.getAccessKey(), s3Params.getSecretKey(), s3Params.getSessionToken());
        builder = AmazonS3ClientBuilder.standard();
        builder.withCredentials(credentialsProvider);
        if (!StringUtils.isNotBlank((String)s3Params.getEndpoint())) ** GOTO lbl-1000
        if (S3Aws.LOCALSTACK_IPS.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(S3Aws.LOCALSTACK_IPS))) {
            config = new ClientConfiguration();
            config.setProtocol(Protocol.HTTP);
            builder.withClientConfiguration(config);
        } else lbl-1000:
        // 2 sources

        {
            builder.withClientConfiguration(S3URLConnection.buildClientConfig());
        }
        builder.withPathStyleAccessEnabled(Boolean.valueOf(true));
        region = Objects.nonNull(region) != false ? region : s3Params.getRegion();
        endpoint = s3Params.getEndpoint();
        if (Objects.nonNull(endpoint)) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Params.getEndpoint(), region));
        } else if (Objects.nonNull(region)) {
            builder.withRegion(region);
        }
        this.s3Client = (AmazonS3)builder.build();
    }

    public AmazonS3 getClient() {
        return this.s3Client;
    }

    public StreamConnection getS3AwsInputStream(final S3Params s3Params) {
        final S3Object s3Object = this.s3Client.getObject(s3Params.getBucket(), s3Params.getKey());
        final ObjectMetadata metadata = s3Object.getObjectMetadata();
        return new StreamConnection(){

            @Override
            public InputStream getInputStream() {
                return s3Object.getObjectContent();
            }

            @Override
            public String getEncoding() {
                return metadata.getContentEncoding();
            }

            @Override
            public long getLength() {
                return metadata.getContentLength();
            }

            @Override
            public String getName() {
                return s3Params.getKey();
            }
        };
    }

    private static AWSCredentialsProvider getCredentialsProvider(String accessKey, String secretKey, String sessionToken) {
        if (StringUtils.isNotBlank((String)accessKey) && StringUtils.isNotBlank((String)secretKey)) {
            Object credentials = StringUtils.isNotBlank((String)sessionToken) ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
            return new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        }
        return new DefaultAWSCredentialsProviderChain();
    }
}

