/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfiguration;
import apoc.Pools;
import apoc.export.util.CountingInputStream;
import apoc.path.RelationshipTypeAndDirections;
import apoc.util.DateFormatUtil;
import apoc.util.FileUtils;
import apoc.util.JsonUtil;
import apoc.util.StreamConnection;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Scanner;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.lang.model.SourceVersion;
import org.apache.commons.io.IOUtils;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionGuardException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.procedure.TerminationGuard;

public class Util {
    public static final Label[] NO_LABELS = new Label[0];
    public static final String NODE_COUNT = "MATCH (n) RETURN count(*) as result";
    public static final String REL_COUNT = "MATCH ()-->() RETURN count(*) as result";
    public static final String COMPILED = "interpreted";

    public static String labelString(List<String> labelNames) {
        return labelNames.stream().map(Util::quote).collect(Collectors.joining(":"));
    }

    public static String labelString(Node n) {
        return Util.joinLabels(n.getLabels(), ":");
    }

    public static String joinLabels(Iterable<Label> labels, String s) {
        return StreamSupport.stream(labels.spliterator(), false).map(Label::name).collect(Collectors.joining(s));
    }

    public static List<String> labelStrings(Node n) {
        return StreamSupport.stream(n.getLabels().spliterator(), false).map(Label::name).sorted().collect(Collectors.toList());
    }

    public static Label[] labels(Object labelNames) {
        if (labelNames == null) {
            return NO_LABELS;
        }
        if (labelNames instanceof List) {
            LinkedHashSet names = new LinkedHashSet((List)labelNames);
            Label[] labels = new Label[names.size()];
            int i = 0;
            for (Object l : names) {
                if (l == null) continue;
                labels[i++] = Label.label((String)l.toString());
            }
            if (i <= labels.length) {
                return Arrays.copyOf(labels, i);
            }
            return labels;
        }
        return new Label[]{Label.label((String)labelNames.toString())};
    }

    public static RelationshipType type(Object type) {
        if (type == null) {
            throw new RuntimeException("No relationship-type provided");
        }
        return RelationshipType.withName((String)type.toString());
    }

    public static LongStream ids(Object ids) {
        if (ids == null) {
            return LongStream.empty();
        }
        if (ids instanceof Number) {
            return LongStream.of(((Number)ids).longValue());
        }
        if (ids instanceof Node) {
            return LongStream.of(((Node)ids).getId());
        }
        if (ids instanceof Relationship) {
            return LongStream.of(((Relationship)ids).getId());
        }
        if (ids instanceof Collection) {
            Collection coll = (Collection)ids;
            return coll.stream().mapToLong(o -> ((Number)o).longValue());
        }
        if (ids instanceof Iterable) {
            Spliterator spliterator = ((Iterable)ids).spliterator();
            return StreamSupport.stream(spliterator, false).mapToLong(o -> ((Number)o).longValue());
        }
        throw new RuntimeException("Can't convert " + ids.getClass() + " to a stream of long ids");
    }

    public static Stream<Object> stream(Object values) {
        if (values == null) {
            return Stream.empty();
        }
        if (values instanceof Collection) {
            return ((Collection)values).stream();
        }
        if (values instanceof Object[]) {
            return Stream.of((Object[])values);
        }
        if (values instanceof Iterable) {
            Spliterator spliterator = ((Iterable)values).spliterator();
            return StreamSupport.stream(spliterator, false);
        }
        return Stream.of(values);
    }

    public static Stream<Node> nodeStream(GraphDatabaseService db, Object ids) {
        return Util.stream(ids).map(id -> Util.node(db, id));
    }

    public static Node node(GraphDatabaseService db, Object id) {
        if (id instanceof Node) {
            return (Node)id;
        }
        if (id instanceof Number) {
            return db.getNodeById(((Number)id).longValue());
        }
        throw new RuntimeException("Can't convert " + id.getClass() + " to a Node");
    }

    public static Stream<Relationship> relsStream(GraphDatabaseService db, Object ids) {
        return Util.stream(ids).map(id -> Util.relationship(db, id));
    }

    public static Relationship relationship(GraphDatabaseService db, Object id) {
        if (id instanceof Relationship) {
            return (Relationship)id;
        }
        if (id instanceof Number) {
            return db.getRelationshipById(((Number)id).longValue());
        }
        throw new RuntimeException("Can't convert " + id.getClass() + " to a Relationship");
    }

    public static double doubleValue(PropertyContainer pc, String prop, Number defaultValue) {
        return Util.toDouble(pc.getProperty(prop, (Object)defaultValue));
    }

    public static double doubleValue(PropertyContainer pc, String prop) {
        return Util.doubleValue(pc, prop, 0);
    }

    public static Direction parseDirection(String direction) {
        if (null == direction) {
            return Direction.BOTH;
        }
        try {
            return Direction.valueOf((String)direction.toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot convert value '%s' to Direction. Legal values are '%s'", direction, Arrays.toString(Direction.values())));
        }
    }

    public static RelationshipType[] toRelTypes(List<String> relTypeStrings) {
        RelationshipType[] relTypes = new RelationshipType[relTypeStrings.size()];
        for (int i = 0; i < relTypes.length; ++i) {
            relTypes[i] = RelationshipType.withName((String)relTypeStrings.get(i));
        }
        return relTypes;
    }

    public static RelationshipType[] allRelationshipTypes(GraphDatabaseService db) {
        return (RelationshipType[])Iterables.asArray(RelationshipType.class, (Iterable)db.getAllRelationshipTypes());
    }

    public static RelationshipType[] typesAndDirectionsToTypesArray(String typesAndDirections) {
        ArrayList<Object> relationshipTypes = new ArrayList<Object>();
        for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(typesAndDirections)) {
            if (null == pair.first()) continue;
            relationshipTypes.add(pair.first());
        }
        return relationshipTypes.toArray(new RelationshipType[relationshipTypes.size()]);
    }

    public static <T> Future<T> inTxFuture(ExecutorService pool, GraphDatabaseService db, Callable<T> callable) {
        GraphDatabaseAPI api = (GraphDatabaseAPI)db;
        LogService logService = (LogService)api.getDependencyResolver().resolveDependency(LogService.class, DependencyResolver.SelectionStrategy.FIRST);
        Log userLog = logService.getUserLog(Util.class);
        return Util.inTxFuture(pool, db, userLog, callable);
    }

    public static <T> Future<T> inTxFuture(ExecutorService pool, GraphDatabaseService db, Log log, Callable<T> callable) {
        try {
            return pool.submit(() -> {
                try (Transaction tx = db.beginTx();){
                    Object result = callable.call();
                    tx.success();
                    Object v = result;
                    return v;
                }
                catch (Exception e) {
                    log.error("Error while executing background job because of the following exception (the task will be killed):", (Throwable)e);
                    throw e;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing in separate transaction", e);
        }
    }

    public static <T> T inTx(GraphDatabaseService db, Callable<T> callable) {
        try {
            return Util.inTxFuture(Pools.DEFAULT, db, callable).get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing in separate transaction: " + e.getMessage(), e);
        }
    }

    public static <T> T inThread(Callable<T> callable) {
        try {
            return Util.inFuture(callable).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing in separate thread: " + e.getMessage(), e);
        }
    }

    public static <T> Future<T> inFuture(Callable<T> callable) {
        return Pools.DEFAULT.submit(callable);
    }

    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Map<String, Object> subMap(Map<String, ?> params, String prefix) {
        HashMap<String, Object> config = new HashMap<String, Object>(10);
        int len = prefix.length() + (prefix.isEmpty() || prefix.endsWith(".") ? 0 : 1);
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            config.put(key.substring(len), entry.getValue());
        }
        return config;
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            String s = value.toString();
            if (s.contains(".")) {
                return (long)Double.parseDouble(s);
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            String s = value.toString();
            if (s.contains(".")) {
                return (int)Double.parseDouble(s);
            }
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static URLConnection openUrlConnection(String url, Map<String, Object> headers) throws IOException {
        URL src = new URL(url);
        URLConnection con = src.openConnection();
        con.setRequestProperty("User-Agent", "APOC Procedures for Neo4j");
        if (headers != null) {
            Object method = headers.get("method");
            if (method != null && con instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)con;
                http.setRequestMethod(method.toString());
                http.setChunkedStreamingMode(0x100000);
                http.setInstanceFollowRedirects(true);
            }
            headers.forEach((k, v) -> con.setRequestProperty((String)k, v == null ? "" : v.toString()));
        }
        con.setConnectTimeout(Util.toLong(ApocConfiguration.get("http.timeout.connect", 10000)).intValue());
        con.setReadTimeout(Util.toLong(ApocConfiguration.get("http.timeout.read", 60000)).intValue());
        return con;
    }

    public static boolean isRedirect(HttpURLConnection con) throws IOException {
        boolean isRedirectCode;
        int code = con.getResponseCode();
        boolean bl = isRedirectCode = code >= 300 && code < 400;
        if (isRedirectCode) {
            URL location = new URL(con.getHeaderField("Location"));
            String oldProtocol = con.getURL().getProtocol();
            String protocol = location.getProtocol();
            if (!protocol.equals(oldProtocol) && !protocol.startsWith(oldProtocol)) {
                throw new RuntimeException("The redirect URI has a different protocol: " + location.toString());
            }
        }
        return isRedirectCode;
    }

    private static void writePayload(URLConnection con, String payload) throws IOException {
        if (payload == null) {
            return;
        }
        con.setDoOutput(true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(con.getOutputStream(), "UTF-8"));
        writer.write(payload);
        writer.close();
    }

    private static String handleRedirect(URLConnection con, String url) throws IOException {
        if (!(con instanceof HttpURLConnection)) {
            return url;
        }
        if (!Util.isRedirect((HttpURLConnection)con)) {
            return url;
        }
        return con.getHeaderField("Location");
    }

    public static CountingInputStream openInputStream(String urlAddress, Map<String, Object> headers, String payload) throws IOException {
        if (urlAddress.contains("!") && (urlAddress.contains(".zip") || urlAddress.contains(".tar") || urlAddress.contains(".tgz"))) {
            return Util.getStreamCompressedFile(urlAddress, headers, payload);
        }
        StreamConnection sc = Util.getStreamConnection(urlAddress, headers, payload);
        return sc.toCountingInputStream();
    }

    private static CountingInputStream getStreamCompressedFile(String urlAddress, Map<String, Object> headers, String payload) throws IOException {
        String[] tokens = urlAddress.split("!");
        urlAddress = tokens[0];
        if (tokens.length != 2) {
            throw new IllegalArgumentException("filename can't be null or empty");
        }
        String zipFileName = tokens[1];
        StreamConnection sc = Util.getStreamConnection(urlAddress, headers, payload);
        InputStream stream = Util.getFileStreamIntoCompressedFile(sc.getInputStream(), zipFileName);
        return new CountingInputStream(stream, sc.getLength());
    }

    private static StreamConnection getStreamConnection(String urlAddress, Map<String, Object> headers, String payload) throws IOException {
        return FileUtils.SupportedProtocols.from(urlAddress).getStreamConnection(urlAddress, headers, payload);
    }

    private static InputStream getInputStream(StreamConnection sc, String urlAddress) throws IOException {
        InputStream stream = sc.getInputStream();
        String encoding = sc.getEncoding();
        if ("gzip".equals(encoding) || urlAddress.endsWith(".gz")) {
            return new GZIPInputStream(stream);
        }
        if ("deflate".equals(encoding)) {
            return new DeflaterInputStream(stream);
        }
        return stream;
    }

    private static InputStream getFileStreamIntoCompressedFile(InputStream is, String fileName) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(is);){
            ZipEntry zipEntry;
            while ((zipEntry = zip.getNextEntry()) != null) {
                if (zipEntry.isDirectory() || !zipEntry.getName().equals(fileName)) continue;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)zip));
                return byteArrayInputStream;
            }
        }
        return null;
    }

    public static StreamConnection readHttpInputStream(String urlAddress, Map<String, Object> headers, String payload) throws IOException {
        FileUtils.checkReadAllowed(urlAddress);
        URLConnection con = Util.openUrlConnection(urlAddress, headers);
        Util.writePayload(con, payload);
        String newUrl = Util.handleRedirect(con, urlAddress);
        if (newUrl != null && !urlAddress.equals(newUrl)) {
            con.getInputStream().close();
            return Util.readHttpInputStream(newUrl, headers, payload);
        }
        return new StreamConnection.UrlStreamConnection(con);
    }

    public static boolean toBoolean(Object value) {
        return value != null && (!(value instanceof Number) || ((Number)value).longValue() != 0L) && (!(value instanceof String) || !value.equals("") && !((String)value).equalsIgnoreCase("false") && !((String)value).equalsIgnoreCase("no") && !((String)value).equalsIgnoreCase("0")) && (!(value instanceof Boolean) || !value.equals(false));
    }

    public static String encodeUrlComponent(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported character set utf-8");
        }
    }

    public static String toJson(Object value) {
        try {
            return JsonUtil.OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to JSON");
        }
    }

    public static <T> T fromJson(String value, Class<T> type) {
        try {
            return (T)JsonUtil.OBJECT_MAPPER.readValue(value, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " from JSON");
        }
    }

    public static Stream<List<Object>> partitionSubList(List<Object> data, int partitions) {
        return Util.partitionSubList(data, partitions, null);
    }

    public static Stream<List<Object>> partitionSubList(List<Object> data, int partitions, List<Object> tombstone) {
        if (partitions == 0) {
            partitions = 1;
        }
        ArrayList<Object> list = new ArrayList<Object>(data);
        int total = list.size();
        int batchSize = Math.max((int)Math.ceil((double)total / (double)partitions), 1);
        Stream<List<Object>> stream = IntStream.range(0, partitions).parallel().mapToObj(part -> list.subList(Math.min(part * batchSize, total), Math.min((part + 1) * batchSize, total))).filter(partition -> !partition.isEmpty());
        return tombstone == null ? stream : Stream.concat(stream, Stream.of(tombstone));
    }

    public static Long runNumericQuery(GraphDatabaseService db, String query, Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        try (ResourceIterator it = db.execute(query, params).columnAs("result");){
            Long l = (Long)it.next();
            return l;
        }
    }

    public static long nodeCount(GraphDatabaseService db) {
        return Util.runNumericQuery(db, NODE_COUNT, null);
    }

    public static long relCount(GraphDatabaseService db) {
        return Util.runNumericQuery(db, REL_COUNT, null);
    }

    public static LongStream toLongStream(final PrimitiveLongIterator it) {
        PrimitiveIterator.OfLong iterator = new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public long nextLong() {
                return it.next();
            }
        };
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static String readResourceFile(String name) {
        InputStream is = Util.class.getClassLoader().getResourceAsStream(name);
        return new Scanner(is).useDelimiter("\\Z").next();
    }

    public static Map<String, Object> readMap(String value) {
        try {
            return (Map)JsonUtil.OBJECT_MAPPER.readValue(value, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read as JSON " + value);
        }
    }

    public static <T> List<T> take(Iterator<T> iterator, int batchsize) {
        ArrayList<T> result = new ArrayList<T>(batchsize);
        while (iterator.hasNext() && batchsize-- > 0) {
            result.add(iterator.next());
        }
        return result;
    }

    public static Map<String, Object> merge(Map<String, Object> first, Map<String, Object> second) {
        if (second == null || second.isEmpty()) {
            return first == null ? Collections.EMPTY_MAP : first;
        }
        if (first == null || first.isEmpty()) {
            return second == null ? Collections.EMPTY_MAP : second;
        }
        HashMap<String, Object> combined = new HashMap<String, Object>(first);
        combined.putAll(second);
        return combined;
    }

    public static <T> Map<String, T> map(Object ... values) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < values.length; i += 2) {
            if (values[i] == null) continue;
            map.put(values[i].toString(), values[i + 1]);
        }
        return map;
    }

    public static <T> Map<String, T> map(List<Object> pairs) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(pairs.size() / 2);
        Iterator<Object> it = pairs.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = it.next();
            if (key == null) continue;
            res.put(key.toString(), value);
        }
        return res;
    }

    public static <T, R> List<R> map(Stream<T> stream, Function<T, R> mapper) {
        return stream.map(mapper).collect(Collectors.toList());
    }

    public static <T, R> List<R> map(Collection<T> collection, Function<T, R> mapper) {
        return Util.map(collection.stream(), mapper);
    }

    public static Map<String, Object> mapFromLists(List<String> keys, List<Object> values) {
        if (keys == null || values == null || keys.size() != values.size()) {
            throw new RuntimeException("keys and values lists have to be not null and of same size");
        }
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (keys.size() == 1) {
            return Collections.singletonMap(keys.get(0), values.get(0));
        }
        ListIterator<Object> it = values.listIterator();
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(keys.size());
        for (String key : keys) {
            res.put(key, it.next());
        }
        return res;
    }

    public static Map<String, Object> mapFromPairs(List<List<Object>> pairs) {
        if (pairs.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(pairs.size());
        for (List<Object> pair : pairs) {
            Object key;
            if (pair.isEmpty() || (key = pair.get(0)) == null) continue;
            Object value = pair.size() >= 2 ? pair.get(1) : null;
            map.put(key.toString(), value);
        }
        return map;
    }

    public static String cleanUrl(String url) {
        try {
            URL source = new URL(url);
            String file = source.getFile();
            if (source.getRef() != null) {
                file = file + "#" + source.getRef();
            }
            return new URL(source.getProtocol(), source.getHost(), source.getPort(), file).toString();
        }
        catch (MalformedURLException mfu) {
            return String.format("invalid URL (%s)", url);
        }
    }

    public static <T> T getFuture(Future<T> f, Map<String, Long> errorMessages, AtomicInteger errors, T errorValue) {
        try {
            return f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            errors.incrementAndGet();
            errorMessages.compute(e.getMessage(), (s, i) -> i == null ? 1L : i + 1L);
            return errorValue;
        }
    }

    public static <T> T getFutureOrCancel(Future<T> f, Map<String, Long> errorMessages, AtomicInteger errors, T errorValue) {
        try {
            if (f.isDone()) {
                return f.get();
            }
            f.cancel(false);
            errors.incrementAndGet();
        }
        catch (InterruptedException | ExecutionException e) {
            errors.incrementAndGet();
            errorMessages.compute(e.getMessage(), (s, i) -> i == null ? 1L : i + 1L);
        }
        return errorValue;
    }

    public static void logErrors(String message, Map<String, Long> errors, Log log) {
        if (!errors.isEmpty()) {
            log.bulk(l -> {
                l.warn(message);
                errors.forEach((k, v) -> l.warn("%d times: %s", new Object[]{v, k}));
            });
        }
    }

    public static void checkAdmin(SecurityContext securityContext, String procedureName) {
        if (!securityContext.isAdmin()) {
            throw new RuntimeException("This procedure " + procedureName + " is only available to admin users");
        }
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String quote(String var) {
        return SourceVersion.isIdentifier(var) && !var.startsWith("$") ? var : '`' + var + '`';
    }

    public static String sanitizeAndQuote(String var) {
        return Util.quote(var.replaceAll("`", ""));
    }

    public static String param(String var) {
        return var.charAt(0) == '$' || var.charAt(0) == '{' ? var : '{' + Util.quote(var) + '}';
    }

    public static String withMapping(Stream<String> columns, Function<String, String> withMapping) {
        String with = columns.map(withMapping).collect(Collectors.joining(","));
        return with.isEmpty() ? with : " WITH " + with + " ";
    }

    public static boolean isWriteableInstance(GraphDatabaseAPI db) {
        try {
            try {
                boolean isSlave;
                Class<?> hadb = Class.forName("org.neo4j.kernel.ha.HighlyAvailableGraphDatabase");
                boolean bl = isSlave = hadb.isInstance(db) && (Boolean)hadb.getMethod("isMaster", new Class[0]).invoke((Object)db, new Object[0]) == false;
                if (isSlave) {
                    return false;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException hadb) {
                // empty catch block
            }
            String role = (String)db.execute("CALL dbms.cluster.role()").columnAs("role").next();
            return role.equalsIgnoreCase("LEADER");
        }
        catch (QueryExecutionException e) {
            if (e.getStatusCode().equalsIgnoreCase("Neo.ClientError.Procedure.ProcedureNotFound")) {
                return true;
            }
            throw e;
        }
    }

    public static boolean transactionIsTerminated(TerminationGuard db) {
        try {
            db.check();
            return false;
        }
        catch (NotInTransactionException | TransactionGuardException | TransactionTerminatedException tge) {
            return true;
        }
    }

    public static void waitForFutures(List<Future> futures) {
        for (Future future : futures) {
            try {
                if (future == null) continue;
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeFinished(List<Future> futures) {
        if (futures.size() > 25) {
            futures.removeIf(Future::isDone);
        }
    }

    public static void close(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isNotNullOrEmpty(String s) {
        return s != null && s.trim().length() != 0;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static Map<String, String> getRequestParameter(String parameters) {
        HashMap<String, String> params = null;
        if (Objects.nonNull(parameters)) {
            String[] queryStrings;
            params = new HashMap<String, String>();
            for (String query : queryStrings = parameters.split("&")) {
                String[] parts = query.split("=");
                if (parts.length != 2) continue;
                params.put(parts[0], parts[1]);
            }
        }
        return params;
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static <T> T createInstanceOrNull(String className) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public static Optional<String> getLoadUrlByConfigFile(String loadType, String key, String suffix) {
        key = Optional.ofNullable(key).map(s -> s + "." + suffix).orElse("");
        Object value = ApocConfiguration.get(loadType).get(key);
        return Optional.ofNullable(value).map(Object::toString);
    }

    public static String dateFormat(TemporalAccessor value, String format) {
        return Util.getFormat(format).format(value);
    }

    public static Duration durationParse(String value) {
        return Duration.parse(value);
    }

    public static DateTimeFormatter getFormat(String format) {
        return DateFormatUtil.getOrCreate(format);
    }

    public static char parseCharFromConfig(Map<String, Object> config, String key, char defaultValue) {
        String separator = (String)config.getOrDefault(key, "");
        if (separator == null || separator.isEmpty()) {
            return defaultValue;
        }
        if ("TAB".equals(separator)) {
            return '\t';
        }
        return separator.charAt(0);
    }

    public static Map<String, Object> flattenMap(Map<String, Object> map) {
        return Util.flattenMap(map, null);
    }

    public static Map<String, Object> flattenMap(Map<String, Object> map, String prefix) {
        return map.entrySet().stream().flatMap(entry -> {
            String key = prefix != null && !prefix.isEmpty() ? prefix + "." + (String)entry.getKey() : (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                return Util.flattenMap((Map)value, key).entrySet().stream();
            }
            AbstractMap.SimpleEntry newEntry = new AbstractMap.SimpleEntry(key, entry.getValue());
            return Stream.of(newEntry);
        }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }
}

