/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.export.util.CountingInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;

public interface StreamConnection {
    public InputStream getInputStream() throws IOException;

    public String getEncoding();

    public long getLength();

    public String getName();

    default public CountingInputStream toCountingInputStream() throws IOException {
        if ("gzip".equals(this.getEncoding()) || this.getName().endsWith(".gz")) {
            return new CountingInputStream(new GZIPInputStream(this.getInputStream()), this.getLength());
        }
        if ("deflate".equals(this.getName())) {
            return new CountingInputStream(new DeflaterInputStream(this.getInputStream()), this.getLength());
        }
        return new CountingInputStream(this.getInputStream(), this.getLength());
    }

    public static class FileStreamConnection
    implements StreamConnection {
        public static final String CANNOT_OPEN_FILE_FOR_READING = "Cannot open file %s for reading.";
        private final File file;

        public FileStreamConnection(File file) throws IOException {
            this.file = file;
            if (!(file.exists() && file.isFile() && file.canRead())) {
                throw new IOException(String.format(CANNOT_OPEN_FILE_FOR_READING, file.getAbsolutePath()));
            }
        }

        public FileStreamConnection(URI fileName) throws IOException {
            this(new File(fileName));
        }

        public FileStreamConnection(String fileName) throws IOException {
            this(new File(fileName));
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return FileUtils.openInputStream((File)this.file);
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }
    }

    public static class UrlStreamConnection
    implements StreamConnection {
        private final URLConnection con;

        public UrlStreamConnection(URLConnection con) {
            this.con = con;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.con.getInputStream();
        }

        @Override
        public String getEncoding() {
            return this.con.getContentEncoding();
        }

        @Override
        public long getLength() {
            return this.con.getContentLength();
        }

        @Override
        public String getName() {
            return this.con.getURL().toString();
        }
    }
}

