/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleRateLimiter {
    private final AtomicInteger countDownLatch = new AtomicInteger(0);
    private final AtomicLong lastUpdate = new AtomicLong(0L);
    private final long timeWindow;
    private final int operationPerWindow;

    public SimpleRateLimiter(long timeWindow, int operationPerWindow) {
        this.timeWindow = timeWindow;
        this.operationPerWindow = operationPerWindow;
    }

    public boolean canExecute() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate.get() > this.timeWindow) {
            this.lastUpdate.set(now);
            this.countDownLatch.set(this.operationPerWindow);
        }
        return this.countDownLatch.decrementAndGet() >= 0;
    }
}

