/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfiguration;
import apoc.export.util.CountingInputStream;
import apoc.export.util.CountingReader;
import apoc.export.util.ExportConfig;
import apoc.util.MissingDependencyException;
import apoc.util.StreamConnection;
import apoc.util.Util;
import apoc.util.hdfs.HDFSUtils;
import apoc.util.s3.S3URLConnection;
import apoc.util.s3.S3UploadUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    public static final String LOAD_FROM_FILE_ERROR = "Import from files not enabled, please set apoc.import.file.enabled=true in your neo4j.conf";
    public static final String EXPORT_TO_FILE_ERROR = "Export to files not enabled, please set apoc.export.file.enabled=true in your neo4j.conf";
    public static final String ERROR_READ_FROM_FS_NOT_ALLOWED = "Import file %s not enabled, please set dbms.security.allow_csv_import_from_file_urls=true in your neo4j.conf";
    public static final String ACCESS_OUTSIDE_DIR_ERROR = "You're providing a directory outside the import directory defined into `dbms.directories.import`";
    public static final List<String> NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES = Arrays.asList("dbms.directories.certificates", "dbms.directories.data", "dbms.directories.import", "dbms.directories.lib", "dbms.directories.logs", "dbms.directories.metrics", "dbms.directories.plugins", "dbms.directories.run", "dbms.directories.tx_log", "unsupported.dbms.directories.neo4j_home");

    public static CountingReader readerFor(String fileName) throws IOException {
        return FileUtils.readerFor(fileName, null, null);
    }

    public static CountingReader readerFor(String fileName, Map<String, Object> headers, String payload) throws IOException {
        return FileUtils.inputStreamFor(fileName, headers, payload).asReader();
    }

    public static CountingInputStream inputStreamFor(String fileName, Map<String, Object> headers, String payload) throws IOException {
        FileUtils.checkReadAllowed(fileName);
        if (fileName == null) {
            return null;
        }
        fileName = FileUtils.changeFileUrlIfImportDirectoryConstrained(fileName);
        return Util.openInputStream(fileName, headers, payload);
    }

    public static CountingInputStream inputStreamFor(String fileName) throws IOException {
        return FileUtils.inputStreamFor(fileName, null, null);
    }

    public static String changeFileUrlIfImportDirectoryConstrained(String url) throws IOException {
        if (FileUtils.isFile(url) && FileUtils.isImportUsingNeo4jConfig()) {
            if (!ApocConfiguration.isEnabled("import.file.allow_read_from_filesystem")) {
                throw new RuntimeException(String.format(ERROR_READ_FROM_FS_NOT_ALLOWED, url));
            }
            Path resolvedPath = FileUtils.resolvePath(url);
            return resolvedPath.normalize().toUri().toString();
        }
        return url;
    }

    private static Path resolvePath(String url) throws IOException {
        Path resolvedPath;
        Path urlPath = FileUtils.getPath(url);
        if (ApocConfiguration.isImportFolderConfigured() && FileUtils.isImportUsingNeo4jConfig()) {
            Path basePath = Paths.get(ApocConfiguration.getImportDir(), new String[0]);
            resolvedPath = basePath.resolve(urlPath = FileUtils.relativizeIfSamePrefix(urlPath, basePath)).toAbsolutePath().normalize();
            if (!FileUtils.pathStartsWithOther(resolvedPath, basePath)) {
                throw new IOException(ACCESS_OUTSIDE_DIR_ERROR);
            }
        } else {
            resolvedPath = urlPath;
        }
        return resolvedPath;
    }

    private static Path relativizeIfSamePrefix(Path urlPath, Path basePath) {
        if (urlPath.isAbsolute() && !urlPath.startsWith(basePath.toAbsolutePath())) {
            urlPath = urlPath.getRoot().relativize(urlPath);
        }
        return urlPath;
    }

    private static Path getPath(String url) {
        Path urlPath;
        URL toURL = null;
        try {
            URI uri = URI.create(url.trim());
            toURL = uri.toURL();
            urlPath = Paths.get(uri);
        }
        catch (Exception e) {
            urlPath = toURL != null ? Paths.get(StringUtils.isBlank((CharSequence)toURL.getFile()) ? toURL.getHost() : toURL.getFile(), new String[0]) : Paths.get(url, new String[0]);
        }
        return urlPath;
    }

    private static boolean pathStartsWithOther(Path resolvedPath, Path basePath) throws IOException {
        try {
            return resolvedPath.toRealPath(new LinkOption[0]).startsWith(basePath.toRealPath(new LinkOption[0]));
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileException) {
                return resolvedPath.normalize().startsWith(basePath);
            }
            return false;
        }
    }

    public static boolean isFile(String fileName) {
        return SupportedProtocols.from(fileName) == SupportedProtocols.file;
    }

    public static OutputStream getOutputStream(String fileName) {
        if (fileName.equals("-")) {
            return null;
        }
        return SupportedProtocols.from(fileName).getOutputStream(fileName);
    }

    private static boolean isImportUsingNeo4jConfig() {
        return ApocConfiguration.isEnabled("import.file.use_neo4j_config");
    }

    public static String getConfiguredImportDirectory() {
        return ApocConfiguration.get("dbms.directories.import", "import");
    }

    public static void checkReadAllowed(String url) throws IOException {
        if (FileUtils.isFile(url) && !ApocConfiguration.isEnabled("import.file.enabled")) {
            throw new RuntimeException(LOAD_FROM_FILE_ERROR);
        }
        ApocConfiguration.checkAllowedUrl(url);
    }

    public static void checkWriteAllowed(ExportConfig exportConfig, String fileName) {
        if (!(ApocConfiguration.isEnabled("export.file.enabled") || exportConfig != null && (fileName == null || fileName.equals("")) && exportConfig.streamStatements())) {
            throw new RuntimeException(EXPORT_TO_FILE_ERROR);
        }
    }

    public static void checkWriteAllowed(String fileName) {
        FileUtils.checkWriteAllowed(null, fileName);
    }

    public static StreamConnection openS3InputStream(URL url) throws IOException {
        if (!SupportedProtocols.s3.isEnabled()) {
            throw new MissingDependencyException("Cannot find the S3 jars in the plugins folder. \nPlease put these files into the plugins folder :\n\naws-java-sdk-core-x.y.z.jar\naws-java-sdk-s3-x.y.z.jar\nhttpclient-x.y.z.jar\nhttpcore-x.y.z.jar\njoda-time-x.y.z.jar\n\nSee the documentation: https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_loading_data_from_web_apis_json_xml_csv");
        }
        return S3URLConnection.openS3InputStream(url);
    }

    public static StreamConnection openHdfsInputStream(URL url) throws IOException {
        if (!SupportedProtocols.hdfs.isEnabled()) {
            throw new MissingDependencyException("Cannot find the HDFS/Hadoop jars in the plugins folder. \nPlease put these files into the plugins folder :\n\ncommons-cli\nhadoop-auth\nhadoop-client\nhadoop-common\nhadoop-hdfs\nhtrace-core-3.1.0-incubating\nprotobuf-java\n\nSee the documentation: https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_loading_data_from_web_apis_json_xml_csv");
        }
        return HDFSUtils.readFile(url);
    }

    public static File getLogDirectory() {
        File logs;
        String neo4jHome = ApocConfiguration.get("unsupported.dbms.directories.neo4j_home", "");
        String logDir = ApocConfiguration.get("dbms.directories.logs", "");
        File file = logs = logDir.isEmpty() ? new File(neo4jHome, "logs") : new File(logDir);
        if (logs.exists() && logs.canRead() && logs.isDirectory()) {
            return logs;
        }
        return null;
    }

    public static File getMetricsDirectory() {
        File metricsDir;
        String neo4jHome = ApocConfiguration.get("unsupported.dbms.directories.neo4j_home", "");
        String metricsSetting = ApocConfiguration.get("dbms.directories.metrics", "");
        File file = metricsDir = metricsSetting.isEmpty() ? new File(neo4jHome, "metrics") : new File(metricsSetting);
        if (metricsDir.exists() && metricsDir.canRead() && metricsDir.isDirectory()) {
            return metricsDir;
        }
        return null;
    }

    public static boolean inNeo4jOwnedDirectory(File f) throws IOException {
        String canonicalPath = f.getCanonicalPath();
        for (String dirSetting : NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES) {
            String actualDir = ApocConfiguration.get(dirSetting, null);
            if (!canonicalPath.contains(actualDir)) continue;
            return true;
        }
        return false;
    }

    public static void closeReaderSafely(CountingReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum SupportedProtocols {
        http(true, null),
        https(true, null),
        s3(Util.classExists("com.amazonaws.services.s3.AmazonS3"), (URLStreamHandlerFactory)Util.createInstanceOrNull("apoc.util.s3.S3UrlStreamHandlerFactory")),
        gs(Util.classExists("com.google.cloud.storage.Storage"), (URLStreamHandlerFactory)Util.createInstanceOrNull("apoc.util.google.cloud.GCStorageURLStreamHandlerFactory")),
        hdfs(Util.classExists("org.apache.hadoop.fs.FileSystem"), (URLStreamHandlerFactory)Util.createInstanceOrNull("org.apache.hadoop.fs.FsUrlStreamHandlerFactory")),
        file(true, null);

        private final boolean enabled;
        private final URLStreamHandlerFactory urlStreamHandlerFactory;

        private SupportedProtocols(boolean enabled, URLStreamHandlerFactory urlStreamHandlerFactory) {
            this.enabled = enabled;
            this.urlStreamHandlerFactory = urlStreamHandlerFactory;
        }

        public StreamConnection getStreamConnection(String urlAddress, Map<String, Object> headers, String payload) throws IOException {
            switch (this) {
                case s3: {
                    return FileUtils.openS3InputStream(new URL(urlAddress));
                }
                case hdfs: {
                    return FileUtils.openHdfsInputStream(new URL(urlAddress));
                }
                case http: 
                case https: 
                case gs: {
                    return Util.readHttpInputStream(urlAddress, headers, payload);
                }
            }
            try {
                return new StreamConnection.FileStreamConnection(URI.create(urlAddress));
            }
            catch (IllegalArgumentException iae) {
                try {
                    return new StreamConnection.FileStreamConnection(new URL(urlAddress).getFile());
                }
                catch (MalformedURLException mue) {
                    if (mue.getMessage().contains("no protocol")) {
                        return new StreamConnection.FileStreamConnection(urlAddress);
                    }
                    throw mue;
                }
            }
        }

        public OutputStream getOutputStream(String fileName) {
            if (fileName == null) {
                return null;
            }
            try {
                OutputStream outputStream;
                switch (this) {
                    case s3: {
                        outputStream = S3UploadUtils.writeFile(fileName);
                        break;
                    }
                    case hdfs: {
                        outputStream = HDFSUtils.writeFile(fileName);
                        break;
                    }
                    default: {
                        Path path = FileUtils.resolvePath(fileName);
                        outputStream = new FileOutputStream(path.toFile());
                    }
                }
                return new BufferedOutputStream(outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public URLStreamHandler createURLStreamHandler() {
            return this.urlStreamHandlerFactory == null ? null : this.urlStreamHandlerFactory.createURLStreamHandler(this.name());
        }

        public static SupportedProtocols from(String source) {
            try {
                URL url = new URL(source);
                return SupportedProtocols.from(url);
            }
            catch (MalformedURLException e) {
                if (!e.getMessage().contains("no protocol")) {
                    throw new RuntimeException(e);
                }
                return file;
            }
        }

        public static SupportedProtocols from(URL url) {
            return SupportedProtocols.of(url.getProtocol());
        }

        public static SupportedProtocols of(String name) {
            try {
                return SupportedProtocols.valueOf(name);
            }
            catch (Exception e) {
                return file;
            }
        }
    }
}

