/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class AsyncStream<T>
implements Consumer<T>,
Iterator<T> {
    private final BlockingQueue<T> queue;
    private final CountDownLatch done = new CountDownLatch(1);

    public static <T> Stream<T> async(Executor executor, String taskName, Consumer<Consumer<T>> body) {
        AsyncStream sink = new AsyncStream(16);
        executor.execute(() -> {
            Thread thread = Thread.currentThread();
            String name = thread.getName();
            thread.setName(taskName);
            try {
                body.accept(sink);
            }
            finally {
                thread.setName(name);
                sink.done();
            }
        });
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(sink, 0), false);
    }

    private AsyncStream(int capacity) {
        this.queue = new ArrayBlockingQueue<T>(capacity);
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            try {
                long timeout = 10L;
                while (!this.done.await(timeout, TimeUnit.MILLISECONDS)) {
                    if (!this.queue.isEmpty()) {
                        return true;
                    }
                    timeout = timeout > 1000L ? timeout : timeout * 2L;
                }
                return !this.queue.isEmpty();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return true;
    }

    @Override
    public T next() {
        return (T)this.queue.remove();
    }

    @Override
    public void accept(T t) {
        try {
            this.queue.put(t);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private void done() {
        this.done.countDown();
    }
}

