/*
 * Decompiled with CFR 0.152.
 */
package apoc.ttl;

import apoc.date.Date;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TTL {
    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.ttl.expireAtInstant(node,time,'time-unit') - expire node at specified time by setting :TTL label and `ttl` property")
    public void expire(@Name(value="node") Node node, @Name(value="time") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)Date.unit(timeUnit).toMillis(time));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.ttl.expireAfterTimeLength(node,timeDelta,'time-unit') - expire node after specified length of time time by setting :TTL label and `ttl` property")
    public void expireIn(@Name(value="node") Node node, @Name(value="timeDelta") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)(System.currentTimeMillis() + Date.unit(timeUnit).toMillis(time)));
    }
}

