/*
 * Decompiled with CFR 0.152.
 */
package apoc.search;

import apoc.result.NodeResult;
import apoc.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ParallelNodeSearch {
    private static final Set<String> OPERATORS = new HashSet<String>(Arrays.asList("exact", "starts with", "ends with", "contains", "<", ">", "=", "<>", "<=", ">=", "=~"));
    @Context
    public GraphDatabaseService api;
    @Context
    public Log log;

    @Procedure(value="apoc.search.nodeAllReduced")
    @Description(value="Do a parallel search over multiple indexes returning a reduced representation of the nodes found: node id, labels and the searched property. apoc.search.nodeShortAll( map of label and properties which will be searched upon, operator: EXACT / CONTAINS / STARTS WITH | ENDS WITH /\u00a0= / <> / < / > ..., value ). All 'hits' are returned.")
    public Stream<NodeReducedResult> multiSearchAll(@Name(value="LabelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") Object value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForData);
    }

    private NodeReducedResult merge(NodeReducedResult a, NodeReducedResult b) {
        a.values.putAll(b.values);
        for (String label : b.labels) {
            if (a.labels.contains(label)) continue;
            a.labels.add(label);
        }
        return a;
    }

    @Procedure(value="apoc.search.nodeReduced")
    @Description(value="Do a parallel search over multiple indexes returning a reduced representation of the nodes found: node id, labels and the searched properties. apoc.search.nodeReduced( map of label and properties which will be searched upon, operator: EXACT | CONTAINS | STARTS WITH | ENDS WITH, searchValue ). Multiple search results for the same node are merged into one record.")
    public Stream<NodeReducedResult> multiSearch(@Name(value="LabelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForData).collect(Collectors.groupingBy(res -> res.id, Collectors.reducing(this::merge))).values().stream().filter(Optional::isPresent).map(Optional::get);
    }

    @Procedure(value="apoc.search.multiSearchReduced")
    @Description(value="Do a parallel search over multiple indexes returning a reduced representation of the nodes found: node id, labels and the searched properties. apoc.search.multiSearchReduced( map of label and properties which will be searched upon, operator: EXACT | CONTAINS | STARTS WITH | ENDS WITH, searchValue ). Multiple search results for the same node are merged into one record.")
    public Stream<NodeReducedResult> multiSearchOld(@Name(value="LabelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForData).collect(Collectors.groupingBy(res -> res.id)).values().stream().map(list -> list.stream().reduce(this::merge)).filter(Optional::isPresent).map(Optional::get);
    }

    @Procedure(value="apoc.search.nodeAll")
    @Description(value="Do a parallel search over multiple indexes returning nodes. usage apoc.search.nodeAll( map of label and properties which will be searched upon, operator: EXACT | CONTAINS | STARTS WITH | ENDS WITH, searchValue ) returns all the Nodes found in the different searches.")
    public Stream<NodeResult> multiSearchNodeAll(@Name(value="LabelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForNode);
    }

    @Procedure(value="apoc.search.node")
    @Description(value="Do a parallel search over multiple indexes returning nodes. usage apoc.search.node( map of label and properties which will be searched upon, operator: EXACT | CONTAINS | STARTS WITH | ENDS WITH, searchValue ) returns all the DISTINCT Nodes found in the different searches.")
    public Stream<NodeResult> multiSearchNode(@Name(value="LabelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForNode).distinct();
    }

    private Stream<QueryWorker> createWorkersFromValidInput(Object labelPropertiesInput, String operatorInput, Object value) throws Exception {
        String operator;
        String operatorNormalized = operatorInput.trim().toLowerCase();
        if (operatorInput == null || !OPERATORS.contains(operatorNormalized)) {
            throw new Exception(String.format("operator `%s` invalid, it must have one of the following values (case insensitive): %s.", operatorInput, OPERATORS));
        }
        String string = operator = operatorNormalized.equals("exact") ? "=" : operatorNormalized;
        if (labelPropertiesInput == null || labelPropertiesInput instanceof String && labelPropertiesInput.toString().trim().isEmpty()) {
            throw new Exception("LabelProperties cannot be empty. example { Person: [\"fullName\",\"lastName\"],Company:\"name\", Event : \"Description\"}");
        }
        Map<String, Object> labelProperties = labelPropertiesInput instanceof Map ? (Map<String, Object>)labelPropertiesInput : Util.readMap(labelPropertiesInput.toString());
        return labelProperties.entrySet().parallelStream().flatMap(e -> {
            String label = (String)e.getKey();
            Object properties = e.getValue();
            if (properties instanceof String) {
                return Stream.of(new QueryWorker(this.api, label, (String)properties, operator, value, this.log));
            }
            if (properties instanceof List) {
                return ((List)properties).stream().map(prop -> new QueryWorker(this.api, label, (String)prop, operator, value, this.log));
            }
            throw new RuntimeException("Invalid type for properties " + properties + ": " + (properties == null ? "null" : properties.getClass()));
        });
    }

    public static class NodeReducedResult {
        public final long id;
        public final List<String> labels;
        public final Map<String, Object> values;

        public NodeReducedResult(long id, List<String> labels, Map<String, Object> val) {
            this.labels = labels;
            this.id = id;
            this.values = val;
        }
    }

    public static class QueryWorker {
        private GraphDatabaseService db;
        private String label;
        private String prop;
        private String operator;
        Object value;
        private Log log;

        public QueryWorker(GraphDatabaseService db, String label, String prop, String operator, Object value, Log log) {
            this.db = db;
            this.label = label;
            this.prop = prop;
            this.value = value;
            this.operator = operator;
            this.log = log;
        }

        public Stream<NodeReducedResult> queryForData() {
            List<String> labels = Collections.singletonList(this.label);
            String query = String.format("match (n:`%s`) where n.`%s` %s {value} return id(n) as id,  n.`%s` as value", this.label, this.prop, this.operator, this.prop);
            return this.queryForNode(query, row -> new NodeReducedResult((Long)row.get("id"), labels, Collections.singletonMap(this.prop, row.get("value")))).stream();
        }

        public Stream<NodeResult> queryForNode() {
            String query = String.format("match (n:`%s`) where n.`%s` %s {value} return n", this.label, this.prop, this.operator);
            return this.queryForNode(query, row -> new NodeResult((Node)row.get("n"))).stream();
        }

        /*
         * Exception decompiling
         */
        public <T> List<T> queryForNode(String query, Function<Map<String, Object>, T> transformer) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

