/*
 * Decompiled with CFR 0.152.
 */
package apoc.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SchemaConfig {
    private Set<String> labels;
    private Set<String> excludeLabels;
    private Set<String> relationships;
    private Set<String> excludeRelationships;

    public Set<String> getLabels() {
        return this.labels;
    }

    public Set<String> getExcludeLabels() {
        return this.excludeLabels;
    }

    public Set<String> getRelationships() {
        return this.relationships;
    }

    public Set<String> getExcludeRelationships() {
        return this.excludeRelationships;
    }

    public SchemaConfig(Map<String, Object> config) {
        config = config != null ? config : Collections.emptyMap();
        this.labels = new HashSet<String>((Collection)config.getOrDefault("labels", Collections.EMPTY_SET));
        this.excludeLabels = new HashSet<String>((Collection)config.getOrDefault("excludeLabels", Collections.EMPTY_SET));
        this.validateParameters(this.labels, this.excludeLabels, "labels");
        this.relationships = new HashSet<String>((Collection)config.getOrDefault("relationships", Collections.EMPTY_SET));
        this.excludeRelationships = new HashSet<String>((Collection)config.getOrDefault("excludeRelationships", Collections.EMPTY_SET));
        this.validateParameters(this.labels, this.excludeLabels, "relationships");
    }

    private void validateParameters(Set<String> include, Set<String> exclude, String parametrType) {
        if (!include.isEmpty() && !exclude.isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameters %s and exclude%s are both valuated. Please check parameters and valuate only one.", parametrType, parametrType));
        }
    }
}

