/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor.util;

import apoc.refactor.util.PropertiesManager;
import apoc.refactor.util.RefactorConfig;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Pair;

public class RefactorUtil {
    public static void mergeRelsWithSameTypeAndDirectionInMergeNodes(Node node, RefactorConfig config, Direction dir) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            StreamSupport.stream(node.getRelationships(dir, new RelationshipType[]{type}).spliterator(), false).collect(Collectors.groupingBy(rel -> Pair.of((Object)rel.getStartNode(), (Object)rel.getEndNode()))).values().stream().filter(list -> !list.isEmpty()).forEach(list -> {
                Relationship first = (Relationship)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    Relationship relationship = (Relationship)list.get(i);
                    RefactorUtil.mergeRels(relationship, first, true, config);
                }
            });
        }
    }

    public static void mergeRels(Relationship source, Relationship target, boolean delete, RefactorConfig conf) {
        Map properties = source.getAllProperties();
        if (delete) {
            source.delete();
        }
        PropertiesManager.mergeProperties(properties, (PropertyContainer)target, conf);
    }

    public static <T extends PropertyContainer> T copyProperties(PropertyContainer source, T target) {
        return RefactorUtil.copyProperties(source.getAllProperties(), target);
    }

    public static <T extends PropertyContainer> T copyProperties(Map<String, Object> source, T target) {
        for (Map.Entry<String, Object> prop : source.entrySet()) {
            target.setProperty(prop.getKey(), prop.getValue());
        }
        return target;
    }
}

