/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.algo.Cover;
import apoc.path.LabelSequenceEvaluator;
import apoc.path.NodeEvaluators;
import apoc.path.RelationshipSequenceExpander;
import apoc.result.GraphResult;
import apoc.result.NodeResult;
import apoc.result.PathResult;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class PathExplorer {
    public static final Uniqueness UNIQUENESS = Uniqueness.RELATIONSHIP_PATH;
    public static final boolean BFS = true;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Procedure(value="apoc.path.expand")
    @Description(value="apoc.path.expand(startNode <id>|Node|list, 'TYPE|TYPE_OUT>|<TYPE_IN', '+YesLabel|-NoLabel', minLevel, maxLevel ) yield path - expand from start node following the given relationships from min to max-level adhering to the label filters")
    public Stream<PathResult> explorePath(@Name(value="start") Object start, @Name(value="relationshipFilter") String pathFilter, @Name(value="labelFilter") String labelFilter, @Name(value="minLevel") long minLevel, @Name(value="maxLevel") long maxLevel) throws Exception {
        List<Node> nodes = this.startToNodes(start);
        return this.explorePathPrivate(nodes, pathFilter, labelFilter, minLevel, maxLevel, true, UNIQUENESS, false, -1L, null, null, true).map(PathResult::new);
    }

    @Procedure(value="apoc.path.expandConfig")
    @Description(value="apoc.path.expandConfig(startNode <id>|Node|list, {minLevel,maxLevel,uniqueness,relationshipFilter,labelFilter,uniqueness:'RELATIONSHIP_PATH',bfs:true, filterStartNode:false, limit:-1, optional:false, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield path - expand from start node following the given relationships from min to max-level adhering to the label filters. ")
    public Stream<PathResult> expandConfig(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        return this.expandConfigPrivate(start, config).map(PathResult::new);
    }

    @Procedure(value="apoc.path.subgraphNodes")
    @Description(value="apoc.path.subgraphNodes(startNode <id>|Node|list, {maxLevel,relationshipFilter,labelFilter,bfs:true, filterStartNode:false, limit:-1, optional:false, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield node - expand the subgraph nodes reachable from start node following relationships to max-level adhering to the label filters")
    public Stream<NodeResult> subgraphNodes(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel") && !config.get("minLevel").equals(0L) && !config.get("minLevel").equals(1L)) {
            throw new IllegalArgumentException("minLevel can only be 0 or 1 in subgraphNodes()");
        }
        return this.expandConfigPrivate(start, configMap).map(path -> path == null ? new NodeResult(null) : new NodeResult(path.endNode()));
    }

    @Procedure(value="apoc.path.subgraphAll")
    @Description(value="apoc.path.subgraphAll(startNode <id>|Node|list, {maxLevel,relationshipFilter,labelFilter,bfs:true, filterStartNode:false, limit:-1, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield nodes, relationships - expand the subgraph reachable from start node following relationships to max-level adhering to the label filters, and also return all relationships within the subgraph")
    public Stream<GraphResult> subgraphAll(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.remove("optional");
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel") && !config.get("minLevel").equals(0L) && !config.get("minLevel").equals(1L)) {
            throw new IllegalArgumentException("minLevel can only be 0 or 1 in subgraphAll()");
        }
        List<Node> subgraphNodes = this.expandConfigPrivate(start, configMap).map(Path::endNode).collect(Collectors.toList());
        List<Relationship> subgraphRels = Cover.coverNodes(subgraphNodes).collect(Collectors.toList());
        return Stream.of(new GraphResult(subgraphNodes, subgraphRels));
    }

    @Procedure(value="apoc.path.spanningTree")
    @Description(value="apoc.path.spanningTree(startNode <id>|Node|list, {maxLevel,relationshipFilter,labelFilter,bfs:true, filterStartNode:false, limit:-1, optional:false, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield path - expand a spanning tree reachable from start node following relationships to max-level adhering to the label filters")
    public Stream<PathResult> spanningTree(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel") && !config.get("minLevel").equals(0L) && !config.get("minLevel").equals(1L)) {
            throw new IllegalArgumentException("minLevel can only be 0 or 1 in spanningTree()");
        }
        return this.expandConfigPrivate(start, configMap).map(PathResult::new);
    }

    private Uniqueness getUniqueness(String uniqueness) {
        for (Uniqueness u : Uniqueness.values()) {
            if (!u.name().equalsIgnoreCase(uniqueness)) continue;
            return u;
        }
        return UNIQUENESS;
    }

    private List<Node> startToNodes(Object start) throws Exception {
        if (start == null) {
            return Collections.emptyList();
        }
        if (start instanceof Node) {
            return Collections.singletonList((Node)start);
        }
        if (start instanceof Number) {
            return Collections.singletonList(this.db.getNodeById(((Number)start).longValue()));
        }
        if (start instanceof List) {
            List list = (List)start;
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            Object first = list.get(0);
            if (first instanceof Node) {
                return list;
            }
            if (first instanceof Number) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (Number n : list) {
                    nodes.add(this.db.getNodeById(n.longValue()));
                }
                return nodes;
            }
        }
        throw new Exception("Unsupported data type for start parameter a Node or an Identifier (long) of a Node must be given!");
    }

    private Stream<Path> expandConfigPrivate(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        List<Node> nodes = this.startToNodes(start);
        String uniqueness = (String)config.getOrDefault("uniqueness", UNIQUENESS.name());
        String relationshipFilter = config.getOrDefault("relationshipFilter", null);
        String labelFilter = config.getOrDefault("labelFilter", null);
        long minLevel = Util.toLong(config.getOrDefault("minLevel", "-1"));
        long maxLevel = Util.toLong(config.getOrDefault("maxLevel", "-1"));
        boolean bfs = Util.toBoolean(config.getOrDefault("bfs", true));
        boolean filterStartNode = Util.toBoolean(config.getOrDefault("filterStartNode", false));
        long limit = Util.toLong(config.getOrDefault("limit", "-1"));
        boolean optional = Util.toBoolean(config.getOrDefault("optional", false));
        String sequence = config.getOrDefault("sequence", null);
        boolean beginSequenceAtStart = Util.toBoolean(config.getOrDefault("beginSequenceAtStart", true));
        List<Node> endNodes = this.startToNodes(config.get("endNodes"));
        List<Node> terminatorNodes = this.startToNodes(config.get("terminatorNodes"));
        List<Node> whitelistNodes = this.startToNodes(config.get("whitelistNodes"));
        List<Node> blacklistNodes = this.startToNodes(config.get("blacklistNodes"));
        EnumMap<NodeFilter, List<Node>> nodeFilter = new EnumMap<NodeFilter, List<Node>>(NodeFilter.class);
        if (endNodes != null && !endNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.END_NODES, endNodes);
        }
        if (terminatorNodes != null && !terminatorNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.TERMINATOR_NODES, terminatorNodes);
        }
        if (whitelistNodes != null && !whitelistNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.WHITELIST_NODES, whitelistNodes);
        }
        if (blacklistNodes != null && !blacklistNodes.isEmpty()) {
            nodeFilter.put(NodeFilter.BLACKLIST_NODES, blacklistNodes);
        }
        Stream<Path> results = this.explorePathPrivate(nodes, relationshipFilter, labelFilter, minLevel, maxLevel, bfs, this.getUniqueness(uniqueness), filterStartNode, limit, nodeFilter, sequence, beginSequenceAtStart);
        if (optional) {
            return this.optionalStream(results);
        }
        return results;
    }

    private Stream<Path> explorePathPrivate(Iterable<Node> startNodes, String pathFilter, String labelFilter, long minLevel, long maxLevel, boolean bfs, Uniqueness uniqueness, boolean filterStartNode, long limit, EnumMap<NodeFilter, List<Node>> nodeFilter, String sequence, boolean beginSequenceAtStart) {
        Traverser traverser = PathExplorer.traverse(this.db.traversalDescription(), startNodes, pathFilter, labelFilter, minLevel, maxLevel, uniqueness, bfs, filterStartNode, nodeFilter, sequence, beginSequenceAtStart);
        if (limit == -1L) {
            return traverser.stream();
        }
        return traverser.stream().limit(limit);
    }

    private Stream<Path> optionalStream(Stream<Path> stream) {
        Stream<Object> optionalStream;
        Iterator itr = stream.iterator();
        if (itr.hasNext()) {
            optionalStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 0), false);
        } else {
            ArrayList listOfNull = new ArrayList();
            listOfNull.add(null);
            optionalStream = listOfNull.stream();
        }
        return optionalStream;
    }

    public static Traverser traverse(TraversalDescription traversalDescription, Iterable<Node> startNodes, String pathFilter, String labelFilter, long minLevel, long maxLevel, Uniqueness uniqueness, boolean bfs, boolean filterStartNode, EnumMap<NodeFilter, List<Node>> nodeFilter, String sequence, boolean beginSequenceAtStart) {
        TraversalDescription td = traversalDescription;
        TraversalDescription traversalDescription2 = td = bfs ? td.breadthFirst() : td.depthFirst();
        if (sequence != null && !sequence.trim().isEmpty()) {
            String[] sequenceSteps = sequence.split(",");
            ArrayList<String> labelSequenceList = new ArrayList<String>();
            ArrayList<String> relSequenceList = new ArrayList<String>();
            for (int index = 0; index < sequenceSteps.length; ++index) {
                ArrayList<Object> seq = (beginSequenceAtStart ? index : index - 1) % 2 == 0 ? labelSequenceList : relSequenceList;
                seq.add(sequenceSteps[index]);
            }
            td = td.expand((PathExpander)new RelationshipSequenceExpander(relSequenceList, beginSequenceAtStart));
            td = td.evaluator((Evaluator)new LabelSequenceEvaluator(labelSequenceList, filterStartNode, beginSequenceAtStart, (int)minLevel));
        } else {
            if (pathFilter != null && !pathFilter.trim().isEmpty()) {
                td = td.expand((PathExpander)new RelationshipSequenceExpander(pathFilter.trim(), beginSequenceAtStart));
            }
            if (labelFilter != null && sequence == null && !labelFilter.trim().isEmpty()) {
                td = td.evaluator((Evaluator)new LabelSequenceEvaluator(labelFilter.trim(), filterStartNode, beginSequenceAtStart, (int)minLevel));
            }
        }
        if (minLevel != -1L) {
            td = td.evaluator(Evaluators.fromDepth((int)((int)minLevel)));
        }
        if (maxLevel != -1L) {
            td = td.evaluator(Evaluators.toDepth((int)((int)maxLevel)));
        }
        if (nodeFilter != null && !nodeFilter.isEmpty()) {
            Evaluator endAndTerminatorNodeEvaluator;
            List<Node> endNodes = nodeFilter.getOrDefault((Object)NodeFilter.END_NODES, Collections.EMPTY_LIST);
            List<Node> terminatorNodes = nodeFilter.getOrDefault((Object)NodeFilter.TERMINATOR_NODES, Collections.EMPTY_LIST);
            List<Node> blacklistNodes = nodeFilter.getOrDefault((Object)NodeFilter.BLACKLIST_NODES, Collections.EMPTY_LIST);
            ArrayList<Node> whitelistNodes = nodeFilter.containsKey((Object)NodeFilter.WHITELIST_NODES) ? new ArrayList<Node>((Collection)nodeFilter.get((Object)NodeFilter.WHITELIST_NODES)) : Collections.EMPTY_LIST;
            if (!blacklistNodes.isEmpty()) {
                td = td.evaluator(NodeEvaluators.blacklistNodeEvaluator(filterStartNode, (int)minLevel, blacklistNodes));
            }
            if ((endAndTerminatorNodeEvaluator = NodeEvaluators.endAndTerminatorNodeEvaluator(filterStartNode, (int)minLevel, endNodes, terminatorNodes)) != null) {
                td = td.evaluator(endAndTerminatorNodeEvaluator);
            }
            if (!whitelistNodes.isEmpty()) {
                whitelistNodes.addAll(endNodes);
                whitelistNodes.addAll(terminatorNodes);
                td = td.evaluator(NodeEvaluators.whitelistNodeEvaluator(filterStartNode, (int)minLevel, whitelistNodes));
            }
        }
        td = td.uniqueness((UniquenessFactory)uniqueness);
        return td.traverse(startNodes);
    }

    static enum NodeFilter {
        WHITELIST_NODES,
        BLACKLIST_NODES,
        END_NODES,
        TERMINATOR_NODES;

    }
}

