/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.PathEvaluator;

public final class NodeEvaluators {
    private NodeEvaluators() {
    }

    public static Evaluator endAndTerminatorNodeEvaluator(boolean filterStartNode, int minLevel, List<Node> endNodes, List<Node> terminatorNodes) {
        Node[] nodes;
        PathEvaluator endNodeEvaluator = null;
        PathEvaluator terminatorNodeEvaluator = null;
        if (!endNodes.isEmpty()) {
            nodes = endNodes.toArray(new Node[endNodes.size()]);
            endNodeEvaluator = Evaluators.includeWhereEndNodeIs((Node[])nodes);
        }
        if (!terminatorNodes.isEmpty()) {
            nodes = terminatorNodes.toArray(new Node[terminatorNodes.size()]);
            terminatorNodeEvaluator = Evaluators.pruneWhereEndNodeIs((Node[])nodes);
        }
        if (endNodeEvaluator != null || terminatorNodeEvaluator != null) {
            return new EndAndTerminatorNodeEvaluator(filterStartNode, minLevel, (Evaluator)endNodeEvaluator, (Evaluator)terminatorNodeEvaluator);
        }
        return null;
    }

    public static Evaluator whitelistNodeEvaluator(boolean filterStartNode, int minLevel, List<Node> whitelistNodes) {
        return new WhitelistNodeEvaluator(filterStartNode, minLevel, whitelistNodes);
    }

    public static Evaluator blacklistNodeEvaluator(boolean filterStartNode, int minLevel, List<Node> blacklistNodes) {
        return new BlacklistNodeEvaluator(filterStartNode, minLevel, blacklistNodes);
    }

    private static abstract class PathExpanderNodeEvaluator
    implements Evaluator {
        public final boolean filterStartNode;
        public final int minLevel;

        private PathExpanderNodeEvaluator(boolean filterStartNode, int minLevel) {
            this.filterStartNode = filterStartNode;
            this.minLevel = minLevel;
        }
    }

    private static class WhitelistNodeEvaluator
    extends PathExpanderNodeEvaluator {
        private Set<Node> whitelistSet;

        public WhitelistNodeEvaluator(boolean filterStartNode, int minLevel, List<Node> whitelistNodes) {
            super(filterStartNode, minLevel);
            this.whitelistSet = new HashSet<Node>(whitelistNodes);
        }

        public Evaluation evaluate(Path path) {
            return path.length() == 0 && !this.filterStartNode ? Evaluation.INCLUDE_AND_CONTINUE : (this.whitelistSet.contains(path.endNode()) ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.EXCLUDE_AND_PRUNE);
        }
    }

    private static class BlacklistNodeEvaluator
    extends PathExpanderNodeEvaluator {
        private Set<Node> blacklistSet;

        public BlacklistNodeEvaluator(boolean filterStartNode, int minLevel, List<Node> blacklistNodes) {
            super(filterStartNode, minLevel);
            this.blacklistSet = new HashSet<Node>(blacklistNodes);
        }

        public Evaluation evaluate(Path path) {
            return path.length() == 0 && !this.filterStartNode ? Evaluation.INCLUDE_AND_CONTINUE : (this.blacklistSet.contains(path.endNode()) ? Evaluation.EXCLUDE_AND_PRUNE : Evaluation.INCLUDE_AND_CONTINUE);
        }
    }

    private static class EndAndTerminatorNodeEvaluator
    implements Evaluator {
        private boolean filterStartNode;
        private int minLevel;
        private Evaluator endNodeEvaluator;
        private Evaluator terminatorNodeEvaluator;

        public EndAndTerminatorNodeEvaluator(boolean filterStartNode, int minLevel, Evaluator endNodeEvaluator, Evaluator terminatorNodeEvaluator) {
            this.filterStartNode = filterStartNode;
            this.minLevel = minLevel;
            this.endNodeEvaluator = endNodeEvaluator;
            this.terminatorNodeEvaluator = terminatorNodeEvaluator;
        }

        public Evaluation evaluate(Path path) {
            if (path.length() == 0 && !this.filterStartNode || path.length() < this.minLevel) {
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
            boolean includes = this.evalIncludes(this.endNodeEvaluator, path) || this.evalIncludes(this.terminatorNodeEvaluator, path);
            boolean continues = this.terminatorNodeEvaluator == null || this.terminatorNodeEvaluator.evaluate(path).continues();
            return Evaluation.of((boolean)includes, (boolean)continues);
        }

        private boolean evalIncludes(Evaluator eval, Path path) {
            return eval != null && eval.evaluate(path).includes();
        }
    }
}

