/*
 * Decompiled with CFR 0.152.
 */
package apoc.model;

import apoc.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelConfig {
    private final boolean write;
    private final String schema;
    private final List<String> tables;
    private final List<String> views;
    private final List<String> columns;

    public ModelConfig(Map<String, Object> config) {
        this.write = Util.toBoolean(config.getOrDefault("write", false));
        Map filters = config.getOrDefault("filters", Collections.emptyMap());
        this.tables = this.toPatternList(filters.getOrDefault("tables", Collections.emptyList()));
        this.views = this.toPatternList(filters.getOrDefault("views", Collections.emptyList()));
        this.columns = this.toPatternList(filters.getOrDefault("columns", Collections.emptyList()));
        this.schema = config.getOrDefault("schema", "").toString();
    }

    private List<String> toPatternList(List<String> patterns) {
        return patterns.stream().collect(Collectors.toList());
    }

    public List<String> getViews() {
        return this.views;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public boolean isWrite() {
        return this.write;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public String getSchema() {
        return this.schema;
    }
}

