/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.util;

import apoc.load.LoadCsv;
import apoc.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadCsvConfig {
    public static final char DEFAULT_ARRAY_SEP = ';';
    public static final char DEFAULT_SEP = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    private final boolean ignoreErrors;
    private char separator;
    private char arraySep;
    private char quoteChar;
    private long skip;
    private boolean hasHeader;
    private long limit;
    private boolean failOnError;
    private boolean ignoreQuotations;
    private EnumSet<Results> results;
    private List<String> ignore;
    private List<String> nullValues;
    private Map<String, Map<String, Object>> mapping;
    private Map<String, LoadCsv.Mapping> mappings;

    public LoadCsvConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.ignoreErrors = Util.toBoolean(config.getOrDefault("ignoreErrors", false));
        this.separator = Util.parseCharFromConfig(config, "sep", ',');
        this.arraySep = Util.parseCharFromConfig(config, "arraySep", ';');
        this.quoteChar = Util.parseCharFromConfig(config, "quoteChar", '\"');
        this.skip = (Long)config.getOrDefault("skip", 0L);
        this.hasHeader = (Boolean)config.getOrDefault("header", true);
        this.limit = (Long)config.getOrDefault("limit", Long.MAX_VALUE);
        this.failOnError = (Boolean)config.getOrDefault("failOnError", true);
        this.ignoreQuotations = (Boolean)config.getOrDefault("ignoreQuotations", false);
        this.results = EnumSet.noneOf(Results.class);
        List<String> resultList = config.getOrDefault("results", Arrays.asList("map", "list"));
        for (String result : resultList) {
            this.results.add(Results.valueOf(result));
        }
        this.ignore = config.getOrDefault("ignore", Collections.emptyList());
        this.nullValues = config.getOrDefault("nullValues", Collections.emptyList());
        this.mapping = config.getOrDefault("mapping", Collections.emptyMap());
        this.mappings = this.createMapping(this.mapping, this.arraySep, this.ignore);
    }

    private Map<String, LoadCsv.Mapping> createMapping(Map<String, Map<String, Object>> mapping, char arraySep, List<String> ignore) {
        if (mapping.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, LoadCsv.Mapping> result = new HashMap<String, LoadCsv.Mapping>(mapping.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapping.entrySet()) {
            String name = entry.getKey();
            result.put(name, new LoadCsv.Mapping(name, entry.getValue(), arraySep, ignore.contains(name)));
        }
        return result;
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getArraySep() {
        return this.arraySep;
    }

    public long getSkip() {
        return this.skip;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public EnumSet<Results> getResults() {
        return this.results;
    }

    public List<String> getIgnore() {
        return this.ignore;
    }

    public List<String> getNullValues() {
        return this.nullValues;
    }

    public Map<String, Map<String, Object>> getMapping() {
        return this.mapping;
    }

    public Map<String, LoadCsv.Mapping> getMappings() {
        return this.mappings;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public boolean getIgnoreErrors() {
        return this.ignoreErrors;
    }

    public boolean isIgnoreQuotations() {
        return this.ignoreQuotations;
    }

    public static enum Results {
        map,
        list,
        strings,
        stringMap;

    }
}

