/*
 * Decompiled with CFR 0.152.
 */
package apoc.graph.document.builder;

import apoc.graph.document.builder.LabelBuilder;
import apoc.graph.document.builder.RelationshipBuilder;
import apoc.graph.util.GraphsConfig;
import apoc.result.VirtualGraph;
import apoc.result.VirtualNode;
import apoc.util.FixedSizeStringWriter;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class DocumentToGraph {
    private static final String JSON_ROOT = "$";
    private GraphDatabaseService db;
    private RelationshipBuilder documentRelationBuilder;
    private LabelBuilder documentLabelBuilder;
    private GraphsConfig config;

    public DocumentToGraph(GraphDatabaseService db, GraphsConfig config) {
        this.db = db;
        this.documentRelationBuilder = new RelationshipBuilder(config);
        this.documentLabelBuilder = new LabelBuilder(config);
        this.config = config;
    }

    private boolean hasId(Map<String, Object> map, String path) {
        List<String> ids = this.config.idsForPath(path);
        if (ids.isEmpty()) {
            return map.containsKey(this.config.getIdField());
        }
        return map.keySet().containsAll(ids);
    }

    private boolean hasLabel(Map<String, Object> map, String path) {
        return !this.config.labelsForPath(path).isEmpty() || map.containsKey(this.config.getLabelField());
    }

    public Map<Map<String, Object>, List<String>> validate(Map<String, Object> map, String path) {
        return this.flatMapFieldsWithPath(map, path).entrySet().stream().flatMap(elem -> ((List)elem.getValue()).stream().map(data -> new AbstractMap.SimpleEntry(elem.getKey(), (Map)data))).map(elem -> {
            String subPath = (String)elem.getKey();
            List<String> valueObjects = this.config.valueObjectForPath(subPath);
            ArrayList<String> msgs = new ArrayList<String>();
            Map value = (Map)elem.getValue();
            if (valueObjects.isEmpty()) {
                if (!this.hasId(value, subPath)) {
                    msgs.add("`" + this.config.getIdField() + "` as id-field name");
                }
                if (!this.hasLabel(value, subPath)) {
                    msgs.add("`" + this.config.getLabelField() + "` as label-field name");
                }
            }
            return new AbstractMap.SimpleEntry(value, msgs);
        }).filter(elem -> !((List)elem.getValue()).isEmpty()).collect(Collectors.toMap(e -> (Map)e.getKey(), e -> (List)e.getValue()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String formatDocument(Map map) {
        try (FixedSizeStringWriter writer = new FixedSizeStringWriter(100);){
            JsonUtil.OBJECT_MAPPER.writeValue((Writer)writer, (Object)map);
            String string = writer.toString().concat(writer.isExceeded() ? "...}" : "");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void fromDocument(Map<String, Object> document, Node source, String type, Map<Set<String>, Set<Node>> nodes, Set<Relationship> relationships, String propertyName) {
        Map<Map<String, Object>, List<String>> errors;
        String path;
        String string = path = propertyName == null ? JSON_ROOT : propertyName;
        if (!this.config.allPropertiesForPath(path)) {
            document.keySet().retainAll(this.config.propertiesForPath(path));
        }
        boolean isRootNode = source == null;
        this.prepareData(document, path);
        if (!this.config.isSkipValidation() && !(errors = this.validate(document, path)).isEmpty()) {
            this.throwError(errors);
        }
        Label[] labels = this.documentLabelBuilder.buildLabel(document, path);
        Map<String, Object> idValues = this.filterNodeIdProperties(document, path);
        Node node = this.config.isWrite() ? this.getOrCreateRealNode(labels, idValues) : this.getOrCreateVirtualNode(nodes, labels, idValues);
        document.entrySet().stream().filter(e -> this.isSimpleType((Map.Entry<String, Object>)e, path)).flatMap(e -> {
            if (e.getValue() instanceof Map) {
                return Util.flattenMap((Map)e.getValue(), (String)e.getKey()).entrySet().stream();
            }
            return Stream.of(e);
        }).forEach(e -> {
            List list;
            Object value = e.getValue();
            if (value instanceof List && !(list = (List)value).isEmpty()) {
                value = Array.newInstance(list.get(0).getClass(), list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(value, i, list.get(i));
                }
            }
            node.setProperty((String)e.getKey(), value);
        });
        document.entrySet().stream().filter(e -> !this.isSimpleType((Map.Entry<String, Object>)e, path)).forEach(e -> {
            String newPath = path + "." + (String)e.getKey();
            if (e.getValue() instanceof Map) {
                Map inner = (Map)e.getValue();
                this.fromDocument(inner, node, (String)e.getKey(), nodes, relationships, newPath);
            } else {
                List list = (List)e.getValue();
                list.forEach(map -> this.fromDocument((Map<String, Object>)map, node, (String)e.getKey(), nodes, relationships, newPath));
            }
        });
        Set<Node> nodesWithSameIds = this.getNodesWithSameLabels(nodes, labels);
        nodesWithSameIds.add(node);
        if (!isRootNode) {
            relationships.addAll(this.documentRelationBuilder.buildRelation(source, node, type));
        }
    }

    private void throwError(Map<Map<String, Object>, List<String>> errors) {
        String error = this.formatError(errors);
        throw new RuntimeException(error);
    }

    private String formatError(Map<Map<String, Object>, List<String>> errors) {
        return errors.entrySet().stream().map(e -> "The object `" + this.formatDocument((Map)e.getKey()) + "` must have " + String.join((CharSequence)" and ", (Iterable)e.getValue())).collect(Collectors.joining("\n"));
    }

    public void prepareData(Map<String, Object> document, String path) {
        if (this.config.isGenerateId()) {
            List<String> ids = this.config.idsForPath(path);
            String idField = ids.isEmpty() ? this.config.getIdField() : ids.get(0);
            document.computeIfAbsent(idField, key -> UUID.randomUUID().toString());
        }
    }

    private Map<String, Object> filterNodeIdProperties(Map<String, Object> document, String path) {
        List<String> ids = this.config.idsForPath(path);
        HashMap<String, Object> idMap = new HashMap<String, Object>(document);
        if (ids.isEmpty()) {
            idMap.keySet().retainAll(Collections.singleton(this.config.getIdField()));
        } else {
            idMap.keySet().retainAll(ids);
        }
        return idMap;
    }

    private Map<String, Object> filterNodeIdProperties(Node n, Map<String, Object> idMap) {
        return n.getProperties(idMap.keySet().toArray(new String[idMap.keySet().size()]));
    }

    private Set<Node> getNodesWithSameLabels(Map<Set<String>, Set<Node>> nodes, Label[] labels) {
        Set set = Stream.of(labels).map(Label::name).collect(Collectors.toSet());
        return nodes.computeIfAbsent(set, k -> new LinkedHashSet());
    }

    private Node getOrCreateVirtualNode(Map<Set<String>, Set<Node>> nodes, Label[] labels, Map<String, Object> idValues) {
        Set<Node> nodesWithSameIds = this.getNodesWithSameLabels(nodes, labels);
        return nodesWithSameIds.stream().filter(n -> {
            if (Stream.of(labels).anyMatch(label -> n.hasLabel(label))) {
                Map<String, Object> ids = this.filterNodeIdProperties((Node)n, idValues);
                return idValues.equals(ids);
            }
            return StreamSupport.stream(n.getRelationships().spliterator(), false).anyMatch(r -> {
                Node otherNode = r.getOtherNode(n);
                Map<String, Object> ids = this.filterNodeIdProperties(otherNode, idValues);
                return Stream.of(labels).anyMatch(label -> otherNode.hasLabel(label)) && idValues.equals(ids);
            });
        }).findFirst().orElseGet(() -> new VirtualNode(labels, Collections.emptyMap(), this.db));
    }

    private Node getOrCreateRealNode(Label[] labels, Map<String, Object> idValues) {
        return Stream.of(labels).map(label -> this.db.findNodes(label, idValues)).filter(it -> it.hasNext()).map(it -> (Node)it.next()).findFirst().orElseGet(() -> this.db.createNode(labels));
    }

    private boolean isSimpleType(Map.Entry<String, Object> e, String path) {
        Object object;
        List list;
        List<String> valueObjects = this.config.valueObjectForPath(path);
        if (e.getValue() instanceof Map) {
            return valueObjects.contains(e.getKey());
        }
        return !(e.getValue() instanceof List) || (list = (List)e.getValue()).isEmpty() || !((object = list.get(0)) instanceof Map);
    }

    private List<Map<String, Object>> getDocumentCollection(Object document) {
        if (document instanceof String) {
            document = JsonUtil.parse((String)document, null, Object.class);
        }
        List<Map> coll = document instanceof List ? (List<Map>)document : Arrays.asList((Map)document);
        return coll;
    }

    public VirtualGraph create(Object documentObj) {
        List<Map<String, Object>> coll = this.getDocumentCollection(documentObj);
        LinkedHashMap nodes = new LinkedHashMap();
        LinkedHashSet<Relationship> relationships = new LinkedHashSet<Relationship>();
        coll.forEach(map -> this.fromDocument((Map<String, Object>)map, null, null, nodes, (Set<Relationship>)relationships, JSON_ROOT));
        return new VirtualGraph("Graph", nodes.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new)), relationships, Collections.emptyMap());
    }

    public Map<Long, List<String>> findDuplicates(Object doc) {
        AtomicLong index = new AtomicLong(-1L);
        return this.getDocumentCollection(doc).stream().flatMap(e -> {
            long lineDup = index.incrementAndGet();
            return this.flatMapFields((Map<String, Object>)e).map(ee -> new AbstractMap.SimpleEntry<Map, Long>((Map)ee, lineDup));
        }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> {
            long line = (Long)((List)e.getValue()).get(0);
            String elem = this.formatDocument((Map)e.getKey());
            String dupLines = ((List)e.getValue()).subList(1, ((List)e.getValue()).size()).stream().map(ee -> String.valueOf(ee)).collect(Collectors.joining(","));
            return new AbstractMap.SimpleEntry<Long, String>(line, String.format("The object `%s` has duplicate at lines [%s]", elem, dupLines));
        }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private Stream<Map<String, Object>> flatMapFields(Map<String, Object> map) {
        Stream<Map<String, Object>> stream = Stream.of(map);
        return Stream.concat(stream, map.values().stream().filter(e -> e instanceof Map).flatMap(e -> this.flatMapFields((Map)e)));
    }

    private Map<String, List<Map<String, Object>>> flatMapFieldsWithPath(Map<String, Object> map, String path) {
        HashMap<String, List<Map<String, Object>>> flatWithPath = new HashMap<String, List<Map<String, Object>>>();
        String newPath = path == null ? JSON_ROOT : path;
        flatWithPath.computeIfAbsent(newPath, e -> new ArrayList()).add(map);
        Map collect = map.entrySet().stream().filter(e -> !this.isSimpleType((Map.Entry<String, Object>)e, path)).flatMap(e -> {
            String subPath = newPath + "." + (String)e.getKey();
            if (e.getValue() instanceof Map) {
                return this.flatMapFieldsWithPath((Map)e.getValue(), subPath).entrySet().stream();
            }
            List list = (List)e.getValue();
            return list.stream().flatMap(le -> this.flatMapFieldsWithPath((Map<String, Object>)le, subPath).entrySet().stream());
        }).flatMap(e -> ((List)e.getValue()).stream().map(ee -> new AbstractMap.SimpleEntry(e.getKey(), (Map)ee))).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(e -> (Map)e.getValue(), Collectors.toList())));
        flatWithPath.putAll(collect);
        return flatWithPath;
    }

    public Map<Long, String> validate(Object doc) {
        AtomicLong index = new AtomicLong(-1L);
        return this.getDocumentCollection(doc).stream().map(elem -> {
            long line = index.incrementAndGet();
            this.prepareData((Map<String, Object>)elem, JSON_ROOT);
            Map<Map<String, Object>, List<String>> errors = this.validate((Map<String, Object>)elem, JSON_ROOT);
            if (errors.isEmpty()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<Long, String>(line, this.formatError(errors));
        }).filter(e -> e != null).collect(Collectors.toMap(e -> (Long)e.getKey(), e -> (String)e.getValue()));
    }

    public Map<Long, List<String>> validateDocument(Object document) {
        Map<Long, List<String>> dups = this.findDuplicates(document);
        Map<Long, String> invalids = this.validate(document);
        for (Map.Entry<Long, String> invalid : invalids.entrySet()) {
            dups.computeIfAbsent(invalid.getKey(), key -> new ArrayList()).add(invalid.getValue());
        }
        return dups;
    }
}

