/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;

public class NodesAndRelsSubGraph
implements SubGraph {
    private final Collection<Node> nodes;
    private final Collection<Relationship> rels;
    private final GraphDatabaseService db;
    private final HashSet<String> labels = new HashSet(20);

    public NodesAndRelsSubGraph(GraphDatabaseService db, Collection<Node> nodes, Collection<Relationship> rels) {
        this.db = db;
        this.nodes = new ArrayList<Node>(nodes.size());
        for (Node node : nodes) {
            for (Label label : node.getLabels()) {
                this.labels.add(label.name());
            }
            this.nodes.add(node);
        }
        this.rels = new HashSet<Relationship>(rels);
    }

    public Iterable<Node> getNodes() {
        return this.nodes;
    }

    public Iterable<Relationship> getRelationships() {
        return this.rels;
    }

    public boolean contains(Relationship relationship) {
        return this.rels.contains(relationship);
    }

    public Iterable<IndexDefinition> getIndexes() {
        Schema schema = this.db.schema();
        ArrayList<IndexDefinition> indexes = new ArrayList<IndexDefinition>(this.labels.size() * 2);
        for (String label : this.labels) {
            Iterables.addAll(indexes, (Iterable)schema.getIndexes(Label.label((String)label)));
        }
        return indexes;
    }

    public Iterable<ConstraintDefinition> getConstraints() {
        Schema schema = this.db.schema();
        ArrayList<ConstraintDefinition> constraints = new ArrayList<ConstraintDefinition>(this.labels.size() * 2);
        for (String label : this.labels) {
            Iterables.addAll(constraints, (Iterable)schema.getConstraints(Label.label((String)label)));
        }
        return constraints;
    }
}

