/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.SizeCounter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class CountingReader
extends FilterReader
implements SizeCounter {
    public static final int BUFFER_SIZE = 0x100000;
    private final long total;
    private long count = 0L;
    private long newLines;

    public CountingReader(File file) throws FileNotFoundException {
        super(new BufferedReader(new FileReader(file), 0x100000));
        this.total = file.length();
    }

    public CountingReader(Reader reader, long total) throws FileNotFoundException {
        super(new BufferedReader(reader, 0x100000));
        this.total = total;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        this.count += (long)read;
        for (int i = off; i < off + len; ++i) {
            if (cbuf[i] != '\n') continue;
            ++this.newLines;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        int read = super.read();
        if (read == 10) {
            ++this.newLines;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        this.count += n;
        return super.skip(n);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getNewLines() {
        return this.newLines;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public long getPercent() {
        if (this.total <= 0L) {
            return 0L;
        }
        return this.count * 100L / this.total;
    }
}

