/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.formatter.CypherFormatter;
import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.Reporter;
import apoc.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;

public class MultiStatementCypherSubGraphExporter {
    private final SubGraph graph;
    private final Map<String, Set<String>> uniqueConstraints = new HashMap<String, Set<String>>();
    private Set<String> indexNames = new LinkedHashSet<String>();
    private Set<String> indexedProperties = new LinkedHashSet<String>();
    private Long artificialUniques = 0L;
    private ExportFormat exportFormat;
    private CypherFormatter cypherFormat;
    private ExportConfig exportConfig;
    private GraphDatabaseService db;

    public MultiStatementCypherSubGraphExporter(SubGraph graph, ExportConfig config, GraphDatabaseService db) {
        this.graph = graph;
        this.exportFormat = config.getFormat();
        this.exportConfig = config;
        this.cypherFormat = config.getCypherFormat().getFormatter();
        this.db = db;
        this.gatherUniqueConstraints();
    }

    public void export(ExportConfig config, Reporter reporter, ExportFileManager cypherFileManager) throws IOException {
        int batchSize = config.getBatchSize();
        ExportConfig.OptimizationType useOptimizations = config.getOptimizationType();
        try (PrintWriter schemaWriter = cypherFileManager.getPrintWriter("schema");
             PrintWriter nodesWriter = cypherFileManager.getPrintWriter("nodes");
             PrintWriter relationshipsWriter = cypherFileManager.getPrintWriter("relationships");
             PrintWriter cleanupWriter = cypherFileManager.getPrintWriter("cleanup");){
            switch (useOptimizations) {
                case NONE: {
                    this.exportNodes(nodesWriter, reporter, batchSize);
                    this.exportSchema(schemaWriter);
                    this.exportRelationships(relationshipsWriter, reporter, batchSize);
                    break;
                }
                default: {
                    this.artificialUniques = this.artificialUniques + this.countArtificialUniques(this.graph.getNodes());
                    this.exportSchema(schemaWriter);
                    this.exportNodesUnwindBatch(nodesWriter, reporter);
                    this.exportRelationshipsUnwindBatch(relationshipsWriter, reporter);
                }
            }
            this.exportCleanUp(cleanupWriter, batchSize);
        }
        reporter.done();
    }

    public void exportOnlySchema(ExportFileManager cypherFileManager) throws IOException {
        try (PrintWriter schemaWriter = cypherFileManager.getPrintWriter("schema");){
            this.exportSchema(schemaWriter);
        }
    }

    private void exportNodes(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.graph.getNodes().iterator().hasNext()) {
            this.begin(out);
            this.appendNodes(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private void exportNodesUnwindBatch(PrintWriter out, Reporter reporter) {
        if (this.graph.getNodes().iterator().hasNext()) {
            this.cypherFormat.statementForNodes(this.graph.getNodes(), this.uniqueConstraints, this.exportConfig, out, reporter, this.db);
            out.flush();
        }
    }

    private long appendNodes(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Node node : this.graph.getNodes()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendNode(out, node, reporter);
        }
        return count;
    }

    private void appendNode(PrintWriter out, Node node, Reporter reporter) {
        this.artificialUniques = this.artificialUniques + this.countArtificialUniques(node);
        String cypher = this.cypherFormat.statementForNode(node, this.uniqueConstraints, this.indexedProperties, this.indexNames);
        if (Util.isNotNullOrEmpty(cypher)) {
            out.println(cypher);
            reporter.update(1L, 0L, Iterables.count((Iterable)node.getPropertyKeys()));
        }
    }

    private void exportRelationships(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.graph.getRelationships().iterator().hasNext()) {
            this.begin(out);
            this.appendRelationships(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private void exportRelationshipsUnwindBatch(PrintWriter out, Reporter reporter) {
        if (this.graph.getRelationships().iterator().hasNext()) {
            this.cypherFormat.statementForRelationships(this.graph.getRelationships(), this.uniqueConstraints, this.exportConfig, out, reporter, this.db);
            out.flush();
        }
    }

    private long appendRelationships(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Relationship rel : this.graph.getRelationships()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendRelationship(out, rel, reporter);
        }
        return count;
    }

    private void appendRelationship(PrintWriter out, Relationship rel, Reporter reporter) {
        String cypher = this.cypherFormat.statementForRelationship(rel, this.uniqueConstraints, this.indexedProperties);
        if (cypher != null && !"".equals(cypher)) {
            out.println(cypher);
            reporter.update(0L, 1L, Iterables.count((Iterable)rel.getPropertyKeys()));
        }
    }

    private void exportSchema(PrintWriter out) {
        String cypher;
        ArrayList<String> indexesAndConstraints = new ArrayList<String>();
        indexesAndConstraints.addAll(this.exportIndexes());
        indexesAndConstraints.addAll(this.exportConstraints());
        if (indexesAndConstraints.isEmpty() && this.artificialUniques == 0L) {
            return;
        }
        this.begin(out);
        for (String index : indexesAndConstraints) {
            out.println(index);
        }
        if (this.artificialUniques > 0L && (cypher = this.cypherFormat.statementForConstraint("UNIQUE IMPORT LABEL", Collections.singleton("UNIQUE IMPORT ID"))) != null && !"".equals(cypher)) {
            out.println(cypher);
        }
        this.commit(out);
        if (this.graph.getIndexes().iterator().hasNext()) {
            out.print(this.exportFormat.indexAwait(this.exportConfig.getAwaitForIndexes()));
        }
        this.schemaAwait(out);
        out.flush();
    }

    private List<String> exportIndexes() {
        Result execute = this.db.execute("CALL db.indexes()");
        return execute.stream().map(map -> {
            List props = (List)map.get("properties");
            List tokenNames = (List)map.get("tokenNames");
            String name = (String)map.get("indexName");
            boolean inGraph = this.tokensInGraph(tokenNames);
            if (!inGraph) {
                return null;
            }
            switch (IndexType.from(map.get("type").toString())) {
                case RELATIONSHIP_FULLTEXT: {
                    List<RelationshipType> types = this.toRelationshipTypes(tokenNames);
                    return this.cypherFormat.statementForRelationshipFullTextIndex(name, types, props);
                }
                case NODE_FULLTEXT: {
                    List<Label> labels = this.toLabels(tokenNames);
                    return this.cypherFormat.statementForNodeFullTextIndex(name, labels, props);
                }
                case NODE_UNIQUE_PROPERTY: {
                    return null;
                }
            }
            String tokenName = (String)tokenNames.get(0);
            return this.cypherFormat.statementForIndex(tokenName, props);
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private boolean tokensInGraph(List<String> tokens) {
        return StreamSupport.stream(this.graph.getIndexes().spliterator(), false).anyMatch(indexDefinition -> {
            if (indexDefinition.isRelationshipIndex()) {
                List typeNames = StreamSupport.stream(indexDefinition.getRelationshipTypes().spliterator(), false).map(RelationshipType::name).collect(Collectors.toList());
                return typeNames.containsAll(tokens);
            }
            List labelNames = StreamSupport.stream(indexDefinition.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toList());
            return labelNames.containsAll(tokens);
        });
    }

    private List<Label> toLabels(List<String> tokenNames) {
        return tokenNames.stream().map(Label::label).collect(Collectors.toList());
    }

    private List<RelationshipType> toRelationshipTypes(List<String> tokenNames) {
        return tokenNames.stream().map(RelationshipType::withName).collect(Collectors.toList());
    }

    private List<String> exportConstraints() {
        return StreamSupport.stream(this.graph.getIndexes().spliterator(), false).filter(index -> index.isConstraintIndex()).map(index -> {
            String label = index.getLabel().name();
            Iterable props = index.getPropertyKeys();
            return this.cypherFormat.statementForConstraint(label, props);
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private void exportCleanUp(PrintWriter out, int batchSize) {
        if (this.artificialUniques > 0L) {
            String cypher;
            while (this.artificialUniques > 0L) {
                cypher = this.cypherFormat.statementForCleanUp(batchSize);
                this.begin(out);
                if (cypher != null && !"".equals(cypher)) {
                    out.println(cypher);
                }
                this.commit(out);
                this.artificialUniques = this.artificialUniques - (long)batchSize;
            }
            this.begin(out);
            cypher = this.cypherFormat.statementForConstraint("UNIQUE IMPORT LABEL", Collections.singleton("UNIQUE IMPORT ID")).replaceAll("^CREATE", "DROP");
            if (cypher != null && !"".equals(cypher)) {
                out.println(cypher);
            }
            this.commit(out);
        }
        out.flush();
    }

    public void begin(PrintWriter out) {
        out.print(this.exportFormat.begin());
    }

    private void schemaAwait(PrintWriter out) {
        out.print(this.exportFormat.schemaAwait());
    }

    private void restart(PrintWriter out) {
        this.commit(out);
        this.begin(out);
    }

    public void commit(PrintWriter out) {
        out.print(this.exportFormat.commit());
    }

    private void gatherUniqueConstraints() {
        for (IndexDefinition index : this.graph.getIndexes()) {
            Set label = StreamSupport.stream(index.getLabels().spliterator(), false).map(l -> l.name()).collect(Collectors.toSet());
            Set props = StreamSupport.stream(index.getPropertyKeys().spliterator(), false).collect(Collectors.toSet());
            this.indexNames.add(index.getName());
            this.indexedProperties.addAll(props);
            if (!index.isConstraintIndex()) continue;
            this.uniqueConstraints.compute(String.join((CharSequence)":", label), (k, v) -> v == null || v.size() > props.size() ? props : v);
        }
    }

    private long countArtificialUniques(Node node) {
        long artificialUniques = 0L;
        artificialUniques = this.getArtificialUniques(node, artificialUniques);
        return artificialUniques;
    }

    private long countArtificialUniques(Iterable<Node> n) {
        long artificialUniques = 0L;
        for (Node node : n) {
            artificialUniques = this.getArtificialUniques(node, artificialUniques);
        }
        return artificialUniques;
    }

    private long getArtificialUniques(Node node, long artificialUniques) {
        Iterator labels = node.getLabels().iterator();
        boolean uniqueFound = false;
        while (labels.hasNext()) {
            Label next = (Label)labels.next();
            String labelName = next.name();
            uniqueFound = CypherFormatterUtils.isUniqueLabelFound(node, this.uniqueConstraints, labelName);
        }
        if (!uniqueFound) {
            ++artificialUniques;
        }
        return artificialUniques;
    }

    private static enum IndexType {
        NODE_LABEL_PROPERTY("node_label_property"),
        NODE_UNIQUE_PROPERTY("node_unique_property"),
        REL_TYPE_PROPERTY("relationship_type_property"),
        NODE_FULLTEXT("node_fulltext"),
        RELATIONSHIP_FULLTEXT("relationship_fulltext");

        private final String typeName;

        private IndexType(String typeName) {
            this.typeName = typeName;
        }

        static IndexType from(String stringType) {
            return Stream.of(IndexType.values()).filter(type -> type.typeName().equals(stringType)).findFirst().orElse(null);
        }

        public String typeName() {
            return this.typeName;
        }
    }
}

