/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.export.cypher.ExportFileManager;
import apoc.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FileManagerFactory {
    public static ExportFileManager createFileManager(String fileName, boolean separatedFiles) {
        if (fileName == null) {
            return new StringExportCypherFileManager(separatedFiles);
        }
        int indexOfDot = fileName.lastIndexOf(".");
        String fileType = fileName.substring(indexOfDot + 1);
        return new PhysicalExportFileManager(fileType, fileName, separatedFiles);
    }

    private static class StringExportCypherFileManager
    implements ExportFileManager {
        private final boolean separatedFiles;
        private final ConcurrentMap<String, StringWriter> writers = new ConcurrentHashMap<String, StringWriter>();

        public StringExportCypherFileManager(boolean separatedFiles) {
            this.separatedFiles = separatedFiles;
        }

        @Override
        public PrintWriter getPrintWriter(String type) throws IOException {
            if (!this.separatedFiles) {
                switch (type) {
                    case "csv": 
                    case "json": 
                    case "graphml": {
                        break;
                    }
                    default: {
                        type = "cypher";
                    }
                }
            }
            return new PrintWriter(this.getStringWriter(type));
        }

        @Override
        public StringWriter getStringWriter(String type) {
            return this.writers.computeIfAbsent(type, key -> new StringWriter());
        }

        @Override
        public synchronized String drain(String type) {
            StringWriter writer = (StringWriter)this.writers.get(type);
            if (writer != null) {
                String text = writer.toString();
                writer.getBuffer().setLength(0);
                return text;
            }
            return null;
        }

        @Override
        public String getFileName() {
            return null;
        }
    }

    private static class PhysicalExportFileManager
    implements ExportFileManager {
        private final String fileName;
        private final String fileType;
        private final boolean separatedFiles;
        private final Map<String, PrintWriter> writerCache;

        public PhysicalExportFileManager(String fileType, String fileName, boolean separatedFiles) {
            this.fileType = fileType;
            this.fileName = fileName;
            this.separatedFiles = separatedFiles;
            this.writerCache = new ConcurrentHashMap<String, PrintWriter>();
        }

        @Override
        public PrintWriter getPrintWriter(String type) throws IOException {
            String newFileName = this.separatedFiles ? this.normalizeFileName(this.fileName, type) : this.normalizeFileName(this.fileName, null);
            return this.writerCache.computeIfAbsent(newFileName, key -> {
                OutputStream outputStream = FileUtils.getOutputStream(newFileName);
                return outputStream == null ? null : new PrintWriter(outputStream);
            });
        }

        @Override
        public StringWriter getStringWriter(String type) {
            return null;
        }

        private String normalizeFileName(String fileName, String suffix) {
            return fileName.replace("." + this.fileType, "." + (suffix != null ? suffix + "." + this.fileType : this.fileType));
        }

        @Override
        public String drain(String type) {
            return null;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }
}

