/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.cypher.ExportFileManager;
import apoc.export.util.BulkImportUtil;
import apoc.export.util.ExportConfig;
import apoc.export.util.Format;
import apoc.export.util.FormatUtils;
import apoc.export.util.MetaInformation;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class CsvFormat
implements Format {
    public static final String ID = "id";
    private final GraphDatabaseService db;
    private boolean applyQuotesToAll = true;
    private static final String[] NODE_HEADER_FIXED_COLUMNS = new String[]{"_id:id", "_labels:label"};
    private static final String[] REL_HEADER_FIXED_COLUMNS = new String[]{"_start:id", "_end:id", "_type:label"};

    public CsvFormat(GraphDatabaseService db) {
        this.db = db;
    }

    @Override
    public ProgressInfo load(Reader reader, Reporter reporter, ExportConfig config) throws Exception {
        return null;
    }

    @Override
    public ProgressInfo dump(SubGraph graph, ExportFileManager writer, Reporter reporter, ExportConfig config) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            if (config.isBulkImport()) {
                this.writeAllBulkImport(graph, reporter, config, writer);
            } else {
                try (PrintWriter printWriter = writer.getPrintWriter("csv");){
                    CSVWriter out = this.getCsvWriter(printWriter, config);
                    this.writeAll(graph, reporter, config, out);
                }
            }
            tx.success();
            reporter.done();
            ProgressInfo progressInfo = reporter.getTotal();
            return progressInfo;
        }
    }

    private CSVWriter getCsvWriter(Writer writer, ExportConfig config) {
        CSVWriter out;
        switch (config.isQuotes()) {
            case "none": {
                out = new CSVWriter(writer, config.getDelimChar(), '\u0000', '\u0000', "\n");
                this.applyQuotesToAll = false;
                break;
            }
            case "ifNeeded": {
                out = new CSVWriter(writer, config.getDelimChar(), '\"', '\u0000', "\n");
                this.applyQuotesToAll = false;
                break;
            }
            default: {
                out = new CSVWriter(writer, config.getDelimChar(), '\"', '\"', "\n");
                this.applyQuotesToAll = true;
            }
        }
        return out;
    }

    /*
     * Exception decompiling
     */
    public ProgressInfo dump(Result result, ExportFileManager writer, Reporter reporter, ExportConfig config) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] writeResultHeader(Result result, CSVWriter out) {
        List columns = result.columns();
        int cols = columns.size();
        String[] header = columns.toArray(new String[cols]);
        out.writeNext(header, this.applyQuotesToAll);
        return header;
    }

    public void writeAll(SubGraph graph, Reporter reporter, ExportConfig config, CSVWriter out) {
        Map<String, Class> nodePropTypes = MetaInformation.collectPropTypesForNodes(graph);
        Map<String, Class> relPropTypes = MetaInformation.collectPropTypesForRelationships(graph);
        List<String> nodeHeader = this.generateHeader(nodePropTypes, config.useTypes(), NODE_HEADER_FIXED_COLUMNS);
        List<String> relHeader = this.generateHeader(relPropTypes, config.useTypes(), REL_HEADER_FIXED_COLUMNS);
        ArrayList<String> header = new ArrayList<String>(nodeHeader);
        header.addAll(relHeader);
        out.writeNext(header.toArray(new String[header.size()]), this.applyQuotesToAll);
        int cols = header.size();
        this.writeNodes(graph, out, reporter, nodeHeader.subList(NODE_HEADER_FIXED_COLUMNS.length, nodeHeader.size()), cols, config.getBatchSize(), config.getDelim());
        this.writeRels(graph, out, reporter, relHeader.subList(REL_HEADER_FIXED_COLUMNS.length, relHeader.size()), cols, nodeHeader.size(), config.getBatchSize(), config.getDelim());
    }

    private void writeAllBulkImport(SubGraph graph, Reporter reporter, ExportConfig config, ExportFileManager writer) {
        Map<Iterable<Label>, List<Node>> objectNodes = StreamSupport.stream(graph.getNodes().spliterator(), false).collect(Collectors.groupingBy(Node::getLabels));
        Map<RelationshipType, List<Relationship>> objectRels = StreamSupport.stream(graph.getRelationships().spliterator(), false).collect(Collectors.groupingBy(Relationship::getType));
        this.writeNodesBulkImport(reporter, config, writer, objectNodes);
        this.writeRelsBulkImport(reporter, config, writer, objectRels);
    }

    private void writeNodesBulkImport(Reporter reporter, ExportConfig config, ExportFileManager writer, Map<Iterable<Label>, List<Node>> objectNode) {
        objectNode.entrySet().forEach(entrySet -> {
            Set<String> headerNode = this.generateHeaderNodeBulkImport((Map.Entry<Iterable<Label>, List<Node>>)entrySet);
            List<List<String>> rows = ((List)entrySet.getValue()).stream().map(n -> {
                reporter.update(1L, 0L, n.getAllProperties().size());
                return headerNode.stream().map(s -> {
                    if (s.equals(":LABEL")) {
                        return Util.joinLabels((Iterable)entrySet.getKey(), config.getArrayDelim());
                    }
                    String prop = s.split(":")[0];
                    return "".equals(prop) ? String.valueOf(n.getId()) : this.cleanPoint(FormatUtils.toString(n.getProperty(prop, (Object)"")));
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
            String type = Util.joinLabels((Iterable)entrySet.getKey(), ".");
            this.writeRow(config, writer, headerNode, rows, "nodes." + type);
        });
    }

    private void writeRelsBulkImport(Reporter reporter, ExportConfig config, ExportFileManager writer, Map<RelationshipType, List<Relationship>> objectRel) {
        objectRel.entrySet().forEach(entrySet -> {
            Set<String> headerRel = this.generateHeaderRelationshipBulkImport((Map.Entry<RelationshipType, List<Relationship>>)entrySet);
            List<List<String>> rows = ((List)entrySet.getValue()).stream().map(r -> {
                reporter.update(0L, 1L, r.getAllProperties().size());
                return headerRel.stream().map(s -> {
                    switch (s) {
                        case ":START_ID": {
                            return String.valueOf(r.getStartNodeId());
                        }
                        case ":END_ID": {
                            return String.valueOf(r.getEndNodeId());
                        }
                        case ":TYPE": {
                            return ((RelationshipType)entrySet.getKey()).name();
                        }
                    }
                    String prop = s.split(":")[0];
                    return "".equals(prop) ? String.valueOf(r.getId()) : this.cleanPoint(FormatUtils.toString(r.getProperty(prop, (Object)"")));
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
            this.writeRow(config, writer, headerRel, rows, "relationships." + ((RelationshipType)entrySet.getKey()).name());
        });
    }

    private String cleanPoint(String point) {
        point = point.replace(",\"z\":null", "");
        point = point.replace(",\"heigth\":null", "");
        point = point.replace("\"", "");
        return point;
    }

    private Set<String> generateHeaderNodeBulkImport(Map.Entry<Iterable<Label>, List<Node>> entrySet) {
        LinkedHashSet<String> headerNode = new LinkedHashSet<String>();
        headerNode.add(":ID");
        LinkedHashMap keyTypes = new LinkedHashMap();
        entrySet.getValue().forEach(node -> MetaInformation.updateKeyTypes(keyTypes, (PropertyContainer)node));
        LinkedHashSet otherFields = keyTypes.entrySet().stream().map(stringClassEntry -> BulkImportUtil.formatHeader(stringClassEntry)).collect(Collectors.toCollection(LinkedHashSet::new));
        headerNode.addAll(otherFields);
        headerNode.add(":LABEL");
        return headerNode;
    }

    private Set<String> generateHeaderRelationshipBulkImport(Map.Entry<RelationshipType, List<Relationship>> entrySet) {
        LinkedHashSet<String> headerNode = new LinkedHashSet<String>();
        LinkedHashMap keyTypes = new LinkedHashMap();
        entrySet.getValue().forEach(relationship -> MetaInformation.updateKeyTypes(keyTypes, (PropertyContainer)relationship));
        headerNode.add(":START_ID");
        headerNode.add(":END_ID");
        headerNode.add(":TYPE");
        headerNode.addAll(keyTypes.entrySet().stream().map(stringClassEntry -> BulkImportUtil.formatHeader(stringClassEntry)).collect(Collectors.toCollection(LinkedHashSet::new)));
        return headerNode;
    }

    private void writeRow(ExportConfig config, ExportFileManager writer, Set<String> headerNode, List<List<String>> rows, String name) {
        try (PrintWriter pw = writer.getPrintWriter(name);
             CSVWriter csvWriter = this.getCsvWriter(pw, config);){
            if (config.isSeparateHeader()) {
                try (PrintWriter pwHeader = writer.getPrintWriter("header." + name);){
                    CSVWriter csvWriterHeader = this.getCsvWriter(pwHeader, config);
                    csvWriterHeader.writeNext(headerNode.toArray(new String[headerNode.size()]), false);
                }
            } else {
                csvWriter.writeNext(headerNode.toArray(new String[headerNode.size()]), false);
            }
            rows.forEach(row -> csvWriter.writeNext(row.toArray(new String[row.size()]), false));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeAll2(SubGraph graph, Reporter reporter, ExportConfig config, CSVWriter out) {
        this.writeNodes(graph, out, reporter, config);
        this.writeRels(graph, out, reporter, config);
    }

    private List<String> generateHeader(Map<String, Class> propTypes, boolean useTypes, String ... starters) {
        ArrayList<String> result = new ArrayList<String>();
        if (useTypes) {
            Collections.addAll(result, starters);
        } else {
            result.addAll(Stream.of(starters).map(s -> s.split(":")[0]).collect(Collectors.toList()));
        }
        result.addAll(propTypes.entrySet().stream().map(entry -> {
            String type = MetaInformation.typeFor((Class)entry.getValue(), null);
            return type == null || type.equals("string") || !useTypes ? (String)entry.getKey() : (String)entry.getKey() + ":" + type;
        }).sorted().collect(Collectors.toList()));
        return result;
    }

    private void writeNodes(SubGraph graph, CSVWriter out, Reporter reporter, ExportConfig config) {
        Map<String, Class> nodePropTypes = MetaInformation.collectPropTypesForNodes(graph);
        List<String> nodeHeader = this.generateHeader(nodePropTypes, config.useTypes(), NODE_HEADER_FIXED_COLUMNS);
        String[] header = nodeHeader.toArray(new String[nodeHeader.size()]);
        out.writeNext(header, this.applyQuotesToAll);
        int cols = header.length;
        this.writeNodes(graph, out, reporter, nodeHeader.subList(NODE_HEADER_FIXED_COLUMNS.length, nodeHeader.size()), cols, config.getBatchSize(), config.getDelim());
    }

    private void writeNodes(SubGraph graph, CSVWriter out, Reporter reporter, List<String> header, int cols, int batchSize, String delimiter) {
        String[] row = new String[cols];
        int nodes = 0;
        for (Node node : graph.getNodes()) {
            row[0] = String.valueOf(node.getId());
            row[1] = MetaInformation.getLabelsString(node);
            this.collectProps(header, (PropertyContainer)node, reporter, row, 2, delimiter);
            out.writeNext(row, this.applyQuotesToAll);
            if (batchSize != -1 && ++nodes % batchSize != 0) continue;
            reporter.update(nodes, 0L, 0L);
            nodes = 0;
        }
        if (nodes > 0) {
            reporter.update(nodes, 0L, 0L);
        }
    }

    private void collectProps(Collection<String> fields, PropertyContainer pc, Reporter reporter, String[] row, int offset, String delimiter) {
        for (String field : fields) {
            if (pc.hasProperty(field)) {
                row[offset] = FormatUtils.toString(pc.getProperty(field));
                reporter.update(0L, 0L, 1L);
            } else {
                row[offset] = "";
            }
            ++offset;
        }
    }

    private void writeRels(SubGraph graph, CSVWriter out, Reporter reporter, ExportConfig config) {
        Map<String, Class> relPropTypes = MetaInformation.collectPropTypesForRelationships(graph);
        List<String> header = this.generateHeader(relPropTypes, config.useTypes(), REL_HEADER_FIXED_COLUMNS);
        out.writeNext(header.toArray(new String[header.size()]), this.applyQuotesToAll);
        int cols = header.size();
        int offset = 0;
        this.writeRels(graph, out, reporter, header.subList(REL_HEADER_FIXED_COLUMNS.length, header.size()), cols, offset, config.getBatchSize(), config.getDelim());
    }

    private void writeRels(SubGraph graph, CSVWriter out, Reporter reporter, List<String> relHeader, int cols, int offset, int batchSize, String delimiter) {
        String[] row = new String[cols];
        int rels = 0;
        for (Relationship rel : graph.getRelationships()) {
            row[offset] = String.valueOf(rel.getStartNode().getId());
            row[offset + 1] = String.valueOf(rel.getEndNode().getId());
            row[offset + 2] = rel.getType().name();
            this.collectProps(relHeader, (PropertyContainer)rel, reporter, row, 3 + offset, delimiter);
            out.writeNext(row, this.applyQuotesToAll);
            if (batchSize != -1 && ++rels % batchSize != 0) continue;
            reporter.update(0L, rels, 0L);
            rels = 0;
        }
        if (rels > 0) {
            reporter.update(0L, rels, 0L);
        }
    }

    private /* synthetic */ boolean lambda$dump$0(String[] header, String[] data, Reporter reporter, CSVWriter out, Result.ResultRow row) throws RuntimeException {
        for (int col = 0; col < header.length; ++col) {
            String key = header[col];
            Object value = row.get(key);
            data[col] = FormatUtils.toString(value);
            reporter.update(value instanceof Node ? 1L : 0L, value instanceof Relationship ? 1L : 0L, value instanceof PropertyContainer ? 0L : 1L);
        }
        out.writeNext(data, this.applyQuotesToAll);
        reporter.nextRow();
        return true;
    }
}

