/*
 * Decompiled with CFR 0.152.
 */
package apoc.data.email;

import apoc.util.Util;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class ExtractEmail {
    @UserFunction(value="apoc.data.email")
    @Description(value="apoc.data.email('email_address') as {personal,user,domain} - extract the personal name, user and domain as a map")
    public Map<String, String> email(@Name(value="email_address") String value) {
        if (value == null || value.indexOf(64) == -1) {
            return null;
        }
        try {
            InternetAddress addr = new InternetAddress(value);
            String rawAddr = addr.getAddress();
            int idx = rawAddr.indexOf(64);
            return Util.map("personal", addr.getPersonal(), "user", rawAddr.substring(0, idx), "domain", rawAddr.substring(idx + 1));
        }
        catch (AddressException adr) {
            return null;
        }
    }
}

