/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.ApocConfiguration;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class CypherInitializer
implements AvailabilityListener {
    public static final String INITIALIZER_CYPHER = "initializer.cypher";
    private final GraphDatabaseAPI db;
    private final Log userLog;
    private final Procedures procs;
    private boolean finished = false;

    public CypherInitializer(GraphDatabaseAPI db, Log userLog) {
        this.db = db;
        this.userLog = userLog;
        this.procs = (Procedures)db.getDependencyResolver().resolveDependency(Procedures.class, DependencyResolver.SelectionStrategy.FIRST);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void available() {
        new Thread(() -> {
            try {
                this.awaitApocProceduresRegistered();
                String singleInitializer = ApocConfiguration.get(INITIALIZER_CYPHER, null);
                Map<String, Object> stringObjectMap = singleInitializer != null ? Collections.singletonMap("1", singleInitializer) : ApocConfiguration.get(INITIALIZER_CYPHER);
                TreeMap<String, Object> initializers = new TreeMap<String, Object>(stringObjectMap);
                for (Object initializer : initializers.values()) {
                    String query = initializer.toString();
                    try {
                        this.db.execute(query);
                        this.userLog.info("successfully initialized: " + query);
                    }
                    catch (Exception e) {
                        this.userLog.warn("error upon initialization, running: " + query, (Throwable)e);
                    }
                }
            }
            finally {
                this.finished = true;
            }
        }).start();
    }

    private void awaitApocProceduresRegistered() {
        while (!this.areApocProceduresRegistered()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean areApocProceduresRegistered() {
        try {
            return this.procs.getAllProcedures().stream().anyMatch(signature -> signature.name().toString().startsWith("apoc"));
        }
        catch (ConcurrentModificationException e) {
            return false;
        }
    }

    public void unavailable() {
    }
}

