/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.custom.SignatureLexer;
import apoc.custom.SignatureParser;
import apoc.util.JsonUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.procedure.Mode;

public class Signatures {
    private final String prefix;

    public Signatures(String prefix) {
        this.prefix = prefix;
    }

    public Signatures() {
        this(null);
    }

    public SignatureParser.ProcedureContext parseProcedure(String procedureSignatureText) {
        return this.parse(procedureSignatureText).procedure();
    }

    public SignatureParser.FunctionContext parseFunction(String functionSignatureText) {
        return this.parse(functionSignatureText).function();
    }

    public SignatureParser parse(String signatureText) {
        CodePointCharStream inputStream = CharStreams.fromString((String)signatureText);
        SignatureLexer signatureLexer = new SignatureLexer((CharStream)inputStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)signatureLexer);
        final ArrayList errors = new ArrayList();
        SignatureParser signatureParser = new SignatureParser((TokenStream)commonTokenStream);
        signatureParser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errors.add("line " + line + ":" + charPositionInLine + " " + msg);
            }
        });
        if (signatureParser.getNumberOfSyntaxErrors() > 0) {
            throw new RuntimeException("Syntax Error in " + signatureText + " : " + ((Object)errors).toString());
        }
        return signatureParser;
    }

    public ProcedureSignature toProcedureSignature(SignatureParser.ProcedureContext signature) {
        return this.toProcedureSignature(signature, null, Mode.DEFAULT);
    }

    public ProcedureSignature toProcedureSignature(SignatureParser.ProcedureContext signature, String description, Mode mode) {
        QualifiedName name = new QualifiedName(this.namespace(signature.namespace()), this.name(signature.name()));
        if (signature.results() == null) {
            System.out.println("signature = " + (Object)((Object)signature));
            return null;
        }
        List<FieldSignature> outputSignature = signature.results().empty() != null ? Collections.emptyList() : signature.results().result().stream().map(p -> FieldSignature.outputField((String)this.name(p.name()), (Neo4jTypes.AnyType)this.type(p.type()))).collect(Collectors.toList());
        List<FieldSignature> inputSignatures = signature.parameter().stream().map(p -> FieldSignature.inputField((String)this.name(p.name()), (Neo4jTypes.AnyType)this.type(p.type()), (DefaultParameterValue)this.defaultValue(p.defaultValue(), this.type(p.type())))).collect(Collectors.toList());
        boolean admin = false;
        String deprecated = "";
        String[] allowed = new String[]{};
        String warning = null;
        boolean eager = false;
        boolean caseInsensitive = true;
        return Signatures.createProcedureSignature(name, inputSignatures, outputSignature, mode, admin, deprecated, allowed, description, warning, eager, caseInsensitive, false);
    }

    public List<String> namespace(SignatureParser.NamespaceContext namespaceContext) {
        List<String> parsed;
        List<String> list = parsed = namespaceContext == null ? Collections.emptyList() : namespaceContext.name().stream().map(this::name).collect(Collectors.toList());
        if (this.prefix == null) {
            return parsed;
        }
        ArrayList<String> namespace = new ArrayList<String>();
        namespace.add(this.prefix);
        namespace.addAll(parsed);
        return namespace;
    }

    public UserFunctionSignature toFunctionSignature(SignatureParser.FunctionContext signature, String description) {
        QualifiedName name = new QualifiedName(this.namespace(signature.namespace()), this.name(signature.name()));
        if (signature.type() == null) {
            System.out.println("signature = " + (Object)((Object)signature));
            return null;
        }
        Neo4jTypes.AnyType type = this.type(signature.type());
        List inputSignatures = signature.parameter().stream().map(p -> FieldSignature.inputField((String)this.name(p.name()), (Neo4jTypes.AnyType)this.type(p.type()), (DefaultParameterValue)this.defaultValue(p.defaultValue(), this.type(p.type())))).collect(Collectors.toList());
        String deprecated = "";
        String[] allowed = new String[]{};
        boolean caseInsensitive = true;
        return new UserFunctionSignature(name, inputSignatures, type, deprecated, allowed, description, caseInsensitive);
    }

    private DefaultParameterValue defaultValue(SignatureParser.DefaultValueContext defaultValue, Neo4jTypes.AnyType type) {
        if (defaultValue == null) {
            return DefaultParameterValue.nullValue((Neo4jTypes.AnyType)type);
        }
        SignatureParser.ValueContext v = defaultValue.value();
        if (v.nullValue() != null) {
            return DefaultParameterValue.nullValue((Neo4jTypes.AnyType)type);
        }
        if (v.boolValue() != null) {
            return DefaultParameterValue.ntBoolean((boolean)Boolean.parseBoolean(v.boolValue().getText()));
        }
        if (v.stringValue() != null) {
            return DefaultParameterValue.ntString((String)v.stringValue().getText());
        }
        if (v.INT_VALUE() != null) {
            return DefaultParameterValue.ntInteger((long)Integer.parseInt(v.INT_VALUE().getText()));
        }
        if (v.FLOAT_VALUE() != null) {
            return DefaultParameterValue.ntFloat((double)Integer.parseInt(v.FLOAT_VALUE().getText()));
        }
        if (v.mapValue() != null) {
            Map map = JsonUtil.parse(v.mapValue().getText(), null, Map.class);
            return DefaultParameterValue.ntMap((Map)map);
        }
        if (v.listValue() != null) {
            List list = JsonUtil.parse(v.listValue().getText(), null, List.class);
            return DefaultParameterValue.ntList((List)list, (Neo4jTypes.AnyType)((Neo4jTypes.ListType)type).innerType());
        }
        return DefaultParameterValue.nullValue((Neo4jTypes.AnyType)type);
    }

    public String name(SignatureParser.NameContext ns) {
        if (ns.IDENTIFIER() != null) {
            return ns.IDENTIFIER().getText();
        }
        if (ns.QUOTED_IDENTIFIER() != null) {
            return ns.QUOTED_IDENTIFIER().getText();
        }
        throw new IllegalStateException("Invalid Name " + (Object)((Object)ns));
    }

    private Neo4jTypes.AnyType type(SignatureParser.TypeContext typeContext) {
        if (typeContext.list_type() != null) {
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.type(typeContext.list_type().opt_type()));
        }
        if (typeContext.opt_type() != null) {
            return this.type(typeContext.opt_type());
        }
        return Neo4jTypes.NTAny;
    }

    private Neo4jTypes.AnyType type(SignatureParser.Opt_typeContext opt_type) {
        switch (opt_type.base_type().getText()) {
            case "ANY": {
                return Neo4jTypes.NTAny;
            }
            case "MAP": {
                return Neo4jTypes.NTMap;
            }
            case "NODE": {
                return Neo4jTypes.NTNode;
            }
            case "REL": {
                return Neo4jTypes.NTRelationship;
            }
            case "RELATIONSHIP": {
                return Neo4jTypes.NTRelationship;
            }
            case "EDGE": {
                return Neo4jTypes.NTRelationship;
            }
            case "PATH": {
                return Neo4jTypes.NTPath;
            }
            case "NUMBER": {
                return Neo4jTypes.NTNumber;
            }
            case "LONG": {
                return Neo4jTypes.NTInteger;
            }
            case "INT": {
                return Neo4jTypes.NTInteger;
            }
            case "INTEGER": {
                return Neo4jTypes.NTInteger;
            }
            case "FLOAT": {
                return Neo4jTypes.NTFloat;
            }
            case "DOUBLE": {
                return Neo4jTypes.NTFloat;
            }
            case "BOOL": {
                return Neo4jTypes.NTBoolean;
            }
            case "BOOLEAN": {
                return Neo4jTypes.NTBoolean;
            }
            case "DATE": {
                return Neo4jTypes.NTDate;
            }
            case "TIME": {
                return Neo4jTypes.NTTime;
            }
            case "LOCALTIME": {
                return Neo4jTypes.NTLocalTime;
            }
            case "DATETIME": {
                return Neo4jTypes.NTDateTime;
            }
            case "LOCALDATETIME": {
                return Neo4jTypes.NTLocalDateTime;
            }
            case "DURATION": {
                return Neo4jTypes.NTDuration;
            }
            case "POINT": {
                return Neo4jTypes.NTPoint;
            }
            case "GEO": {
                return Neo4jTypes.NTGeometry;
            }
            case "GEOMETRY": {
                return Neo4jTypes.NTGeometry;
            }
            case "STRING": {
                return Neo4jTypes.NTString;
            }
            case "TEXT": {
                return Neo4jTypes.NTString;
            }
        }
        return Neo4jTypes.NTString;
    }

    public UserFunctionSignature asFunctionSignature(String signature, String description) {
        SignatureParser.FunctionContext functionContext = this.parseFunction(signature);
        return this.toFunctionSignature(functionContext, description);
    }

    public ProcedureSignature asProcedureSignature(String signature, String description, Mode mode) {
        SignatureParser.ProcedureContext ctx = this.parseProcedure(signature);
        return this.toProcedureSignature(ctx, description, mode);
    }

    public static ProcedureSignature createProcedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String[] allowed, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure) {
        try {
            Class<?> clazz = Class.forName("org.neo4j.internal.kernel.api.procs.ProcedureSignature");
            Constructor<?>[] constructors = clazz.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                switch (constructor.getParameterCount()) {
                    case 12: {
                        return (ProcedureSignature)constructor.newInstance(name, inputSignature, outputSignature, mode, admin, deprecated, allowed, description, warning, eager, caseInsensitive, systemProcedure);
                    }
                    case 11: {
                        return (ProcedureSignature)constructor.newInstance(name, inputSignature, outputSignature, mode, admin, deprecated, allowed, description, warning, eager, caseInsensitive);
                    }
                }
            }
            throw new RuntimeException("Constructor of org.neo4j.internal.kernel.api.procs.ProcedureSignature not found");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

