/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.ApocConfiguration;
import apoc.couchbase.CouchbaseConnection;
import com.couchbase.client.java.auth.PasswordAuthenticator;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.Pair;
import org.parboiled.common.StringUtils;

public class CouchbaseManager {
    protected static final String COUCHBASE_CONFIG_KEY = "couchbase.";
    protected static final String USERNAME_CONFIG_KEY = "username";
    protected static final String PASSWORD_CONFIG_KEY = "password";
    protected static final String URI_CONFIG_KEY = "uri";
    protected static final String PORT_CONFIG_KEY = "port";
    private static final Map<String, Object> DEFAULT_CONFIG;

    protected CouchbaseManager() {
    }

    protected static URI checkAndGetURI(String hostOrKey) {
        URI uri = URI.create(hostOrKey);
        if (!StringUtils.isEmpty((String)uri.getScheme())) {
            String userInfo = uri.getUserInfo();
            if (StringUtils.isEmpty((String)userInfo)) {
                throw new RuntimeException("URI must include credentials otherwise use apoc.couchbase.<key>.* configuration");
            }
            String[] infoTokens = userInfo.split(":");
            if (infoTokens.length != 2) {
                throw new RuntimeException("Credentials must be defined according URI specifications");
            }
            return uri;
        }
        return null;
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromConfigurationKey(String configurationKey) {
        Object password;
        Map<String, Object> couchbaseConfig = CouchbaseManager.getKeyMap(configurationKey);
        Object username = couchbaseConfig.get(USERNAME_CONFIG_KEY);
        if (username == null || (password = couchbaseConfig.get(PASSWORD_CONFIG_KEY)) == null) {
            throw new RuntimeException("Please check you 'apoc.couchbase." + configurationKey + "' configuration, username and password are missing");
        }
        Object url = couchbaseConfig.get(URI_CONFIG_KEY);
        if (url == null) {
            throw new RuntimeException("Please check you 'apoc.couchbase." + configurationKey + "' configuration, url is missing");
        }
        return Pair.of((Object)new PasswordAuthenticator(username.toString(), password.toString()), Arrays.asList(url.toString().split(",")));
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromHost(URI host) {
        List<Object> nodes = Collections.emptyList();
        try {
            nodes = Arrays.asList(new URI(host.getScheme(), null, host.getHost(), host.getPort(), null, null, null).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String[] credentials = host.getUserInfo().split(":");
        return Pair.of((Object)new PasswordAuthenticator(credentials[0], credentials[1]), nodes);
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromHostOrKey(String hostOrKey) {
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            return CouchbaseManager.getConnectionObjectsFromConfigurationKey(hostOrKey);
        }
        return CouchbaseManager.getConnectionObjectsFromHost(singleHostURI);
    }

    public static CouchbaseConnection getConnection(String hostOrKey, String bucketName) {
        PasswordAuthenticator passwordAuthenticator = CouchbaseManager.getPasswordAuthenticator(hostOrKey);
        List<String> nodes = CouchbaseManager.getNodes(hostOrKey);
        DefaultCouchbaseEnvironment env = CouchbaseManager.getEnv(hostOrKey);
        String[] bucketCredentials = bucketName.split(":");
        return new CouchbaseConnection(nodes, passwordAuthenticator, bucketCredentials[0], bucketCredentials.length == 2 ? bucketCredentials[1] : null, (CouchbaseEnvironment)env);
    }

    private static DefaultCouchbaseEnvironment getEnv(String hostOrKey) {
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        DefaultCouchbaseEnvironment.Builder builder = DefaultCouchbaseEnvironment.builder();
        builder.connectTimeout(Long.parseLong(CouchbaseManager.getConfig("connectTimeout")));
        builder.socketConnectTimeout(Integer.parseInt(CouchbaseManager.getConfig("socketConnectTimeout")));
        builder.kvTimeout((long)Integer.parseInt(CouchbaseManager.getConfig("kvTimeout")));
        builder.ioPoolSize(Integer.parseInt(CouchbaseManager.getConfig("ioPoolSize")));
        builder.computationPoolSize(Integer.parseInt(CouchbaseManager.getConfig("computationPoolSize")));
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            Map<String, Object> couchbaseConfig = CouchbaseManager.getKeyMap(hostOrKey);
            Object port = couchbaseConfig.get(PORT_CONFIG_KEY);
            if (port != null) {
                builder.bootstrapHttpDirectPort(Integer.parseInt(port.toString()));
            }
        } else if (singleHostURI.getPort() != -1) {
            builder.bootstrapHttpDirectPort(singleHostURI.getPort());
        }
        return builder.build();
    }

    private static List<String> getNodes(String hostOrKey) {
        Object url;
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            Map<String, Object> couchbaseConfig = CouchbaseManager.getKeyMap(hostOrKey);
            url = couchbaseConfig.get(URI_CONFIG_KEY);
            if (url == null) {
                throw new RuntimeException("Please check you 'apoc.couchbase." + hostOrKey + "' configuration, url is missing");
            }
        } else {
            url = singleHostURI.getHost();
        }
        return Arrays.asList(url.toString().split(","));
    }

    private static PasswordAuthenticator getPasswordAuthenticator(String hostOrKey) {
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            Object password;
            Map<String, Object> couchbaseConfig = CouchbaseManager.getKeyMap(hostOrKey);
            Object username = couchbaseConfig.get(USERNAME_CONFIG_KEY);
            if (username == null || (password = couchbaseConfig.get(PASSWORD_CONFIG_KEY)) == null) {
                throw new RuntimeException("Please check you 'apoc.couchbase." + hostOrKey + "' configuration, username and password are missing");
            }
            return new PasswordAuthenticator(username.toString(), password.toString());
        }
        String[] userInfo = singleHostURI.getUserInfo().split(":");
        return new PasswordAuthenticator(userInfo[0], userInfo[1]);
    }

    private static Map<String, Object> getKeyMap(String hostOrKey) {
        Map<String, Object> couchbaseConfig = ApocConfiguration.get(COUCHBASE_CONFIG_KEY + hostOrKey);
        if (couchbaseConfig.isEmpty()) {
            throw new RuntimeException("Please check neo4j.conf file 'apoc.couchbase." + hostOrKey + "' is missing");
        }
        return couchbaseConfig;
    }

    public static String getConfig(String key) {
        return ApocConfiguration.get(COUCHBASE_CONFIG_KEY + key, DEFAULT_CONFIG.get(key)).toString();
    }

    static {
        HashMap<String, Number> cfg = new HashMap<String, Number>();
        cfg.put("connectTimeout", 5000L);
        cfg.put("socketConnectTimeout", 1500);
        cfg.put("kvTimeout", 2500);
        cfg.put("ioPoolSize", 3);
        cfg.put("computationPoolSize", 3);
        DEFAULT_CONFIG = Collections.unmodifiableMap(cfg);
    }
}

