/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.couchbase.CouchbaseConnection;
import apoc.couchbase.CouchbaseManager;
import apoc.couchbase.document.CouchbaseJsonDocument;
import apoc.couchbase.document.CouchbaseQueryResult;
import apoc.couchbase.document.CouchbaseUtils;
import apoc.result.BooleanResult;
import apoc.util.MissingDependencyException;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Couchbase {
    @Procedure
    @Description(value="apoc.couchbase.get(hostOrKey, bucket, documentId) yield id, expiry, cas, mutationToken, content - retrieves a couchbase json document by its unique ID.")
    public Stream<CouchbaseJsonDocument> get(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.get(documentId);
            Stream<CouchbaseJsonDocument> stream = jsonDocument == null ? Stream.empty() : Stream.of(new CouchbaseJsonDocument(jsonDocument));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.exists(hostOrKey, bucket, documentId) yield value - check whether a couchbase json document with the given ID does exist.")
    public Stream<BooleanResult> exists(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            Stream<BooleanResult> stream = Stream.of(new BooleanResult(couchbaseConnection.exists(documentId)));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.insert(hostOrKey, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - insert a couchbase json document with its unique ID.")
    public Stream<CouchbaseJsonDocument> insert(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.insert(documentId, json);
            Stream<CouchbaseJsonDocument> stream = jsonDocument == null ? Stream.empty() : Stream.of(new CouchbaseJsonDocument(jsonDocument));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.upsert(hostOrKey, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - insert or overwrite a couchbase json document with its unique ID.")
    public Stream<CouchbaseJsonDocument> upsert(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.upsert(documentId, json);
            Stream<CouchbaseJsonDocument> stream = jsonDocument == null ? Stream.empty() : Stream.of(new CouchbaseJsonDocument(jsonDocument));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.append(hostOrKey, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - append a couchbase json document to an existing one.")
    public Stream<CouchbaseJsonDocument> append(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.append(documentId, json);
            Stream<CouchbaseJsonDocument> stream = jsonDocument == null ? Stream.empty() : Stream.of(new CouchbaseJsonDocument(jsonDocument));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.prepend(hostOrKey, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - prepend a couchbase json document to an existing one.")
    public Stream<CouchbaseJsonDocument> prepend(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        Object result = null;
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.prepend(documentId, json);
            Stream<CouchbaseJsonDocument> stream = jsonDocument == null ? Stream.empty() : Stream.of(new CouchbaseJsonDocument(jsonDocument));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.remove(hostOrKey, bucket, documentId) yield id, expiry, cas, mutationToken, content - remove the couchbase json document identified by its unique ID.")
    public Stream<CouchbaseJsonDocument> remove(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.remove(documentId);
            Stream<CouchbaseJsonDocument> stream = jsonDocument == null ? Stream.empty() : Stream.of(new CouchbaseJsonDocument(jsonDocument));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.replace(hostOrKey, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - replace the content of the couchbase json document identified by its unique ID.")
    public Stream<CouchbaseJsonDocument> replace(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            JsonDocument jsonDocument = couchbaseConnection.replace(documentId, json);
            Stream<CouchbaseJsonDocument> stream = jsonDocument == null ? Stream.empty() : Stream.of(new CouchbaseJsonDocument(jsonDocument));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.query(hostOrKey, bucket, statement) yield queryResult - executes a plain un-parameterized N1QL statement.")
    public Stream<CouchbaseQueryResult> query(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="statement") String statement) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            List<JsonObject> statementResult = couchbaseConnection.executeStatement(statement);
            Stream<CouchbaseQueryResult> stream = statementResult == null ? Stream.empty() : Stream.of(CouchbaseUtils.convertToCouchbaseQueryResult(statementResult));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.posParamsQuery(hostOrKey, bucket, statement, params) yield queryResult - executes a N1QL statement with positional parameters.")
    public Stream<CouchbaseQueryResult> posParamsQuery(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="statement") String statement, @Name(value="params") List<Object> params) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            List<JsonObject> statementResult = couchbaseConnection.executeParametrizedStatement(statement, params);
            Stream<CouchbaseQueryResult> stream = statementResult == null ? Stream.empty() : Stream.of(CouchbaseUtils.convertToCouchbaseQueryResult(statementResult));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.namedParamsQuery(hostkOrKey, bucket, statement, paramNames, paramValues) yield queryResult - executes a N1QL statement with named parameters.")
    public Stream<CouchbaseQueryResult> namedParamsQuery(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="statement") String statement, @Name(value="paramNames") List<String> paramNames, @Name(value="paramValues") List<Object> paramValues) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket);){
            List<JsonObject> statementResult = couchbaseConnection.executeParametrizedStatement(statement, paramNames, paramValues);
            Stream<CouchbaseQueryResult> stream = statementResult == null ? Stream.empty() : Stream.of(CouchbaseUtils.convertToCouchbaseQueryResult(statementResult));
            return stream;
        }
    }

    private CouchbaseConnection getCouchbaseConnection(String hostOrKey, String bucket) {
        try {
            return CouchbaseManager.getConnection(hostOrKey, bucket);
        }
        catch (NoClassDefFoundError e) {
            System.out.println(e.getMessage());
            throw new MissingDependencyException("Cannot find the jar into the plugins folder. \nPlease put these jar in the plugins folder : \n\njava-client-x.y.z.jar\n\ncore-io-x.y.z.jar\n\nrxjava-x.y.z.jar\n\nSee the documentation: https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_interacting_with_couchbase");
        }
    }
}

