/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.util.Util;
import java.util.Collections;
import java.util.Map;

public class BoltConfig {
    private final boolean virtual;
    private final boolean addStatistics;
    private final boolean readOnly;
    private final boolean withRelationshipNodeProperties;

    public BoltConfig(Map<String, Object> configMap) {
        if (configMap == null) {
            configMap = Collections.emptyMap();
        }
        this.virtual = Util.toBoolean(configMap.getOrDefault("virtual", false));
        this.addStatistics = Util.toBoolean(configMap.getOrDefault("statistics", false));
        this.readOnly = Util.toBoolean(configMap.getOrDefault("readOnly", true));
        this.withRelationshipNodeProperties = Util.toBoolean(configMap.getOrDefault("withRelationshipNodeProperties", false));
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isAddStatistics() {
        return this.addStatistics;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isWithRelationshipNodeProperties() {
        return this.withRelationshipNodeProperties;
    }
}

